/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.state.get;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class GetWatchStateResponse
extends ActionResponse
implements ToXContentObject {
    private RestStatus restStatus;
    private Map<String, BytesReference> watchToStatusMap;

    public GetWatchStateResponse() {
    }

    public GetWatchStateResponse(RestStatus restStatus, Map<String, BytesReference> watchToStatusMap) {
        this.restStatus = restStatus;
        this.watchToStatusMap = watchToStatusMap;
    }

    public GetWatchStateResponse(StreamInput in) throws IOException {
        super(in);
        this.restStatus = (RestStatus)in.readEnum(RestStatus.class);
        this.watchToStatusMap = in.readMap(StreamInput::readString, StreamInput::readBytesReference);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.restStatus);
        out.writeMap(this.watchToStatusMap, StreamOutput::writeString, StreamOutput::writeBytesReference);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, BytesReference> entry : this.watchToStatusMap.entrySet()) {
            builder.rawField(entry.getKey(), (InputStream)entry.getValue().streamInput(), XContentType.JSON);
        }
        builder.endObject();
        return builder;
    }

    public RestStatus status() {
        return this.restStatus;
    }

    public Map<String, BytesReference> getWatchToStatusMap() {
        return this.watchToStatusMap;
    }
}

