/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.signals.actions.watch.ack.AckWatchAction;
import com.floragunn.signals.actions.watch.ack.AckWatchRequest;
import com.floragunn.signals.actions.watch.ack.AckWatchResponse;
import com.floragunn.signals.api.SignalsTenantAwareRestHandler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class AckWatchApiAction
extends SignalsTenantAwareRestHandler {
    public AckWatchApiAction(Settings settings, RestController controller) {
        super(settings);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, "/_signals/watch/{tenant}/{id}/_ack"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_signals/watch/{tenant}/{id}/_ack/{actionId}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_signals/watch/{tenant}/{id}/_ack"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_signals/watch/{tenant}/{id}/_ack/{actionId}"));
    }

    @Override
    protected final BaseRestHandler.RestChannelConsumer getRestChannelConsumer(RestRequest request, NodeClient client) throws IOException {
        String watchId = request.param("id");
        String actionId = request.param("actionId");
        request.param("tenant");
        return channel -> client.execute((ActionType)AckWatchAction.INSTANCE, (ActionRequest)new AckWatchRequest(watchId, actionId, request.getHttpRequest().method() == RestRequest.Method.PUT), (ActionListener)new ActionListener<AckWatchResponse>(){

            public void onResponse(AckWatchResponse response) {
                if (response.getStatus() == AckWatchResponse.Status.SUCCESS) {
                    AckWatchApiAction.this.response(channel, RestStatus.OK);
                } else if (response.getStatus() == AckWatchResponse.Status.NO_SUCH_WATCH) {
                    AckWatchApiAction.this.errorResponse(channel, RestStatus.NOT_FOUND, response.getStatusMessage());
                } else if (response.getStatus() == AckWatchResponse.Status.ILLEGAL_STATE) {
                    AckWatchApiAction.this.errorResponse(channel, RestStatus.PRECONDITION_FAILED, response.getStatusMessage());
                } else if (response.getStatus() == AckWatchResponse.Status.NO_SUCH_ACTION) {
                    AckWatchApiAction.this.errorResponse(channel, RestStatus.NOT_FOUND, response.getStatusMessage());
                } else if (response.getStatus() == AckWatchResponse.Status.NOT_ACKNOWLEDGEABLE) {
                    AckWatchApiAction.this.errorResponse(channel, RestStatus.BAD_REQUEST, response.getStatusMessage());
                } else {
                    AckWatchApiAction.this.errorResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, response.getStatusMessage());
                }
            }

            public void onFailure(Exception e) {
                AckWatchApiAction.this.errorResponse(channel, e);
            }
        });
    }

    public String getName() {
        return "Ack Watch";
    }
}

