/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.proxy.service;

import com.floragunn.signals.proxy.service.ProxyCrudService;
import com.floragunn.signals.proxy.service.persistence.ProxyData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpProxyHostRegistry {
    private static final Logger log = LogManager.getLogger(HttpProxyHostRegistry.class);
    private final ProxyCrudService proxyCrudService;
    private volatile Map<String, HttpHost> proxyHostMap;

    public HttpProxyHostRegistry(ProxyCrudService proxyCrudService) {
        this.proxyCrudService = Objects.requireNonNull(proxyCrudService, "Proxy crud service is required");
        this.proxyHostMap = Collections.synchronizedMap(new HashMap());
        log.info("Http proxy host registry service created");
    }

    public void onProxyUpdate(String proxyId, String operationType) {
        log.debug("Notification about operation '{}' on proxy '{}' received.", (Object)operationType, (Object)proxyId);
        try {
            Optional<ProxyData> proxyData = this.proxyCrudService.findOneById(proxyId);
            if (proxyData.isPresent()) {
                this.proxyHostMap.put(proxyId, HttpHost.create((String)proxyData.get().getUri()));
            } else {
                this.proxyHostMap.remove(proxyId);
                log.info("Proxy with id '{}' not found. Corresponding http proxy host was removed.", (Object)proxyId);
            }
            if (log.isInfoEnabled()) {
                String ids = this.getAvailableProxyHostsIds();
                log.info("Http proxy hosts available after proxy update: '{}'", (Object)ids);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                String ids = this.getAvailableProxyHostsIds();
                log.debug("Cannot create http proxy host based on proxy with id '{}', available http proxy hosts '{}'.", (Object)proxyId, (Object)ids, (Object)e);
            }
            throw new RuntimeException("Cannot update http proxy host after operation '" + operationType + "' on proxy '" + proxyId + "'.", e);
        }
    }

    public Optional<HttpHost> findHttpProxyHost(String proxyId) {
        Objects.requireNonNull(proxyId, "Proxy id must not be null");
        Optional<HttpHost> httpHost = Optional.ofNullable(this.proxyHostMap.get(proxyId));
        log.trace("Http proxy host loaded by id '{}' is '{}'.", (Object)proxyId, httpHost);
        return httpHost;
    }

    public void reloadAll() {
        List<ProxyData> proxies = this.proxyCrudService.loadAll();
        log.info("Loaded '{}' proxies to init cache.", (Object)proxies.size());
        HashMap<String, HttpHost> httpHosts = new HashMap<String, HttpHost>();
        for (ProxyData proxyData : proxies) {
            try {
                httpHosts.put(proxyData.getId(), HttpHost.create((String)proxyData.getUri()));
            }
            catch (Exception e) {
                log.error("Cannot create http proxy host based on proxy data: {}. Proxy will be not available. Please check proxy data.", (Object)proxyData.getId(), (Object)e);
            }
        }
        this.proxyHostMap = Collections.synchronizedMap(httpHosts);
        if (log.isInfoEnabled()) {
            String ids = this.getAvailableProxyHostsIds();
            log.info("Reloaded all Http proxy hosts, available proxy hosts: '{}'", (Object)ids);
        }
    }

    private String getAvailableProxyHostsIds() {
        return new HashSet<String>(this.proxyHostMap.keySet()).stream().sorted().collect(Collectors.joining(", "));
    }
}

