/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClient
extends CloseableHttpClient {
    private final CloseableHttpClient delegate;

    HttpClient(CloseableHttpClient delegate) {
        this.delegate = delegate;
    }

    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        try {
            return this.delegate.execute(target, request, context);
        }
        catch (SSLHandshakeException e) {
            if (e.getMessage().contains("unable to find valid certification path to requested target")) {
                SSLHandshakeException e2 = new SSLHandshakeException("The server certificate could not be validated using the current truststore: Unable to find valid certification path to requested target. Check authenticity of server and the truststore you are using. ");
                e2.initCause(e);
                throw e2;
            }
            if (e.getMessage().contains("Received fatal alert: bad_certificate")) {
                SSLHandshakeException e2 = new SSLHandshakeException("Certificate validation failed. Check if the host requires client certificate authentication");
                e2.initCause(e);
                throw e2;
            }
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }
}

