/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.service.persistence;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.client.SearchScroller;
import com.floragunn.signals.settings.SignalsSettings;
import com.floragunn.signals.truststore.service.persistence.TruststoreData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;

public class TruststoreRepository {
    private final PrivilegedConfigClient client;
    private final SignalsSettings signalsSettings;

    public TruststoreRepository(SignalsSettings signalsSettings, PrivilegedConfigClient client) {
        this.signalsSettings = Objects.requireNonNull(signalsSettings, "Signals settings is required");
        this.client = Objects.requireNonNull(client, "Node client is required");
    }

    public DocWriteResponse createOrReplace(String truststoreId, TruststoreData truststoreData) {
        Objects.requireNonNull(truststoreId, "Truststore id is required");
        Objects.requireNonNull(truststoreData, "Truststore data are required");
        String json = truststoreData.toJsonString();
        IndexRequest storeRequest = ((IndexRequest)new IndexRequest(".signals_truststores").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(truststoreId).source(json, XContentType.JSON);
        return (DocWriteResponse)this.client.index(storeRequest).actionGet();
    }

    public List<TruststoreData> findAll() {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.sort("store_time");
        TimeValue scrollTimeout = new TimeValue(1000L);
        SearchRequest searchRequest = new SearchRequest(new String[]{".signals_truststores"}).source(sourceBuilder);
        SearchScroller searchScroller = new SearchScroller((Client)this.client);
        ArrayList<TruststoreData> results = new ArrayList<TruststoreData>();
        searchScroller.scroll(searchRequest, scrollTimeout, searchHit -> {
            try {
                return this.searchHitToTruststoreData((SearchHit)searchHit);
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException("Cannot parse trust store content stored in an index.", e);
            }
        }, results::addAll);
        return results;
    }

    public Optional<TruststoreData> findOneById(String truststoreId) {
        Objects.requireNonNull(truststoreId, "Trust store id is required");
        GetResponse getResponse = (GetResponse)this.client.get(new GetRequest(".signals_truststores").id(truststoreId)).actionGet();
        try {
            return this.getResponseToTruststoreData(getResponse);
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException("Cannot parse trust store '" + truststoreId + "' content stored in an index.", e);
        }
    }

    private Optional<TruststoreData> getResponseToTruststoreData(GetResponse response) throws ConfigValidationException {
        return response.isExists() ? Optional.of(this.jsonToTruststoreData(response.getId(), response.getSourceAsString())) : Optional.empty();
    }

    private TruststoreData searchHitToTruststoreData(SearchHit searchHit) throws ConfigValidationException {
        return this.jsonToTruststoreData(searchHit.getId(), searchHit.getSourceAsString());
    }

    private TruststoreData jsonToTruststoreData(String truststoreId, String json) throws ConfigValidationException {
        DocNode docNode = TruststoreRepository.parseJsonAsDocNode(json);
        return new TruststoreData(truststoreId, docNode);
    }

    private static DocNode parseJsonAsDocNode(String json) throws DocumentParseException {
        return DocNode.parse((Format)Format.JSON).from(json);
    }

    public Boolean deleteById(String truststoreId) {
        Objects.requireNonNull(truststoreId, "Truststore id is required");
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".signals_truststores").id(truststoreId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        DeleteResponse deleteResponse = (DeleteResponse)this.client.delete(deleteRequest).actionGet();
        return RestStatus.OK.equals((Object)deleteResponse.status());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTruststoreUsedByAnyWatch(String truststoreId) {
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"actions.tls.truststore_id.keyword", (String)truststoreId)).should((QueryBuilder)QueryBuilders.termQuery((String)"checks.tls.truststore_id.keyword", (String)truststoreId)).should((QueryBuilder)QueryBuilders.queryStringQuery((String)truststoreId).field("actions.attachments.*.tls.truststore_id.keyword"))));
        SearchRequest searchWatchesRequest = new SearchRequest(new String[]{this.signalsSettings.getStaticSettings().getIndexNames().getWatches()}).source(searchSourceBuilder).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        SearchResponse searchResponse = (SearchResponse)this.client.search(searchWatchesRequest).actionGet();
        try {
            boolean bl = searchResponse.getHits().getTotalHits().value > 0L;
            return bl;
        }
        finally {
            searchResponse.decRef();
        }
    }
}

