/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.init;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.accounts.Account;
import com.floragunn.signals.accounts.AccountRegistry;
import com.floragunn.signals.accounts.NoSuchAccountException;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.script.SignalsScriptContextFactory;
import com.floragunn.signals.support.ScriptValidationError;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.common.throttle.ThrottlePeriodParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;

public class WatchInitializationService {
    private static final Logger log = LogManager.getLogger(WatchInitializationService.class);
    private final ScriptService scriptService;
    private final AccountRegistry accountRegistry;
    private final ThrottlePeriodParser throttlePeriodParser;
    private final TrustManagerRegistry trustManagerRegistry;
    private final HttpProxyHostRegistry httpProxyHostRegistry;
    private final ValidationLevel validationLevel;

    public WatchInitializationService(AccountRegistry accountRegistry, ScriptService scriptService, TrustManagerRegistry trustManagerRegistry, HttpProxyHostRegistry httpProxyHostRegistry, ThrottlePeriodParser throttlePeriodParser, ValidationLevel validationLevel) {
        this.accountRegistry = accountRegistry;
        this.scriptService = scriptService;
        this.trustManagerRegistry = trustManagerRegistry;
        this.httpProxyHostRegistry = httpProxyHostRegistry;
        this.throttlePeriodParser = throttlePeriodParser;
        this.validationLevel = Objects.requireNonNull(validationLevel, "Life cycle stage is required");
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public boolean isScriptCompilationRequired() {
        return this.scriptService != null;
    }

    public TemplateScript.Factory compileTemplate(String attribute, String scriptSource, ValidationErrors validationErrors) {
        return this.compile(attribute, scriptSource, "mustache", SignalsScriptContextFactory.TEMPLATE_CONTEXT, validationErrors);
    }

    public List<TemplateScript.Factory> compileTemplates(String attribute, String[] scriptSourceArray, ValidationErrors validationErrors) {
        if (scriptSourceArray == null || scriptSourceArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TemplateScript.Factory> result = new ArrayList<TemplateScript.Factory>(scriptSourceArray.length);
        int i = 0;
        for (String scriptSource : scriptSourceArray) {
            result.add(this.compileTemplate(attribute + "[" + i + "]", scriptSource, validationErrors));
            ++i;
        }
        return result;
    }

    public List<TemplateScript.Factory> compileTemplates(String attribute, List<String> scriptSources, ValidationErrors validationErrors) {
        if (scriptSources == null) {
            return null;
        }
        if (scriptSources.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<TemplateScript.Factory> result = new ArrayList<TemplateScript.Factory>(scriptSources.size());
        int i = 0;
        for (String scriptSource : scriptSources) {
            result.add(this.compileTemplate(attribute + "[" + i + "]", scriptSource, validationErrors));
            ++i;
        }
        return result;
    }

    public <FactoryType> FactoryType compile(String attribute, String scriptSource, String language, ScriptContext<FactoryType> context, ValidationErrors validationErrors) {
        if (scriptSource == null) {
            return null;
        }
        return this.compile(attribute, new Script(ScriptType.INLINE, language, scriptSource, Collections.emptyMap()), context, validationErrors);
    }

    public <FactoryType> FactoryType compile(String attribute, Script script, ScriptContext<FactoryType> context, ValidationErrors validationErrors) {
        if (this.scriptService == null) {
            return null;
        }
        try {
            return (FactoryType)this.scriptService.compile(script, context);
        }
        catch (ScriptException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error while compiling script " + String.valueOf(script), (Throwable)e);
            }
            validationErrors.add((ValidationError)new ScriptValidationError(attribute, e));
            return null;
        }
    }

    public <T extends Account> boolean verifyAccount(String id, Class<T> accountType, ValidationErrors validationErrors, DocNode jsonObject) {
        if (this.accountRegistry == null) {
            return true;
        }
        try {
            this.accountRegistry.lookupAccount(id, accountType);
            return true;
        }
        catch (NoSuchAccountException e) {
            validationErrors.add(new ValidationError("account", e.getMessage(), (Object)jsonObject).cause((Throwable)e));
            return false;
        }
    }

    public AccountRegistry getAccountRegistry() {
        return this.accountRegistry;
    }

    public ThrottlePeriodParser getThrottlePeriodParser() {
        return this.throttlePeriodParser;
    }

    public TrustManagerRegistry getTrustManagerRegistry() {
        return this.trustManagerRegistry;
    }

    public HttpProxyHostRegistry getHttpProxyHostRegistry() {
        return this.httpProxyHostRegistry;
    }

    public ValidationLevel getValidationLevel() {
        return this.validationLevel;
    }

    public String toString() {
        return "WatchInitializationService{scriptService=" + String.valueOf(this.scriptService) + ", accountRegistry=" + String.valueOf(this.accountRegistry) + ", trustManagerRegistry=" + String.valueOf(this.trustManagerRegistry) + ", httpProxyConfigRegistry=" + String.valueOf(this.httpProxyHostRegistry) + ", validationLevel=" + String.valueOf((Object)this.validationLevel) + "}";
    }
}

