/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.WatchBuilder;
import com.floragunn.signals.watch.severity.SeverityLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.awaitility.Awaitility;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ToXContentObject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

class PredefinedWatches {
    private static final Logger log = LogManager.getLogger(PredefinedWatches.class);
    public static final String ACTION_CREATE_ALARM_ONE = "create_alarmOne";
    public static final String ACTION_CREATE_ALARM_TWO = "create_alarmTwo";
    private final LocalCluster.Embedded localCluster;
    private final TestSgConfig.User watchUser;
    private final String tenant;
    private List<WatchPointer> watchesToDelete;

    public PredefinedWatches(LocalCluster.Embedded localCluster, TestSgConfig.User watchUser, String tenant) {
        this.localCluster = Objects.requireNonNull(localCluster);
        this.watchUser = Objects.requireNonNull(watchUser, "Watch user is required");
        this.tenant = Objects.requireNonNull(tenant, "Tenant is required");
        this.watchesToDelete = new ArrayList<WatchPointer>();
    }

    public WatchPointer defineTemperatureWithoutSeverities(String watchId, String inputTemperatureIndex, String outputAlarmIndex, double temperatureLimit, String actionName) {
        WatchPointer watchPointer;
        block8: {
            String aggregationNameMaxTemperature = "max_temperature";
            String maxTemperatureSearch = "max_temperature_search";
            String maxTemperatureLimitName = "max_temperature";
            String staticLimitsName = "limits";
            String tooHighTemperatureCondition = "data." + "max_temperature_search" + ".aggregations." + "max_temperature" + ".value > data." + "limits" + "." + "max_temperature";
            GenericRestClient restClient = this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.watchUser, new Header[0]);
            try {
                DocNode aggregation = DocNode.of((String)"max_temperature", (Object)DocNode.of((String)"max", (Object)DocNode.of((String)"field", (Object)"temperature")));
                Watch watch = new WatchBuilder(watchId).triggerNow().search(inputTemperatureIndex).size(0).aggregation(aggregation).as("max_temperature_search").put(String.format("{\"%s\": %.2f}", "max_temperature", temperatureLimit)).as("limits").checkCondition(tooHighTemperatureCondition).then().index(outputAlarmIndex).name(actionName).build();
                String watchPath = this.createWatchPath(watchId);
                log.info("Predefined watch will be created using path '{}' and body '{}'", (Object)watchPath, (Object)watch.toJson());
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)201));
                WatchPointer watchPointer2 = new WatchPointer(watchPath);
                this.watchesToDelete.add(watchPointer2);
                watchPointer = watchPointer2;
                if (restClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restClient != null) {
                        try {
                            restClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot define test watch", e);
                }
            }
            restClient.close();
        }
        return watchPointer;
    }

    public WatchPointer defineTemperatureSeverityWatch(String watchId, String inputTemperatureIndex, String outputAlarmIndex, double temperatureLimit, String ... actionNames) {
        WatchPointer watchPointer;
        block11: {
            if (actionNames == null || actionNames.length == 0) {
                throw new IllegalArgumentException("At least one action name is required.");
            }
            String aggregationNameMaxTemperature = "max_temperature";
            String maxTemperatureSearch = "max_temperature_search";
            String maxTemperatureLimitName = "max_temperature";
            String staticLimitsName = "limits";
            String tooHighTemperatureCondition = "data." + "max_temperature_search" + ".aggregations." + "max_temperature" + ".value > data." + "limits" + "." + "max_temperature";
            GenericRestClient restClient = this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.watchUser, new Header[0]);
            try {
                DocNode aggregation = DocNode.of((String)"max_temperature", (Object)DocNode.of((String)"max", (Object)DocNode.of((String)"field", (Object)"temperature")));
                WatchBuilder.ActionBuilder severityMappingBuilder = new WatchBuilder(watchId).triggerNow().search(inputTemperatureIndex).size(0).aggregation(aggregation).as("max_temperature_search").put(String.format("{\"%s\": %.2f}", "max_temperature", temperatureLimit)).as("limits").checkCondition(tooHighTemperatureCondition).consider("data.max_temperature_search.aggregations.max_temperature.value").greaterOrEqual(0.0).as(SeverityLevel.NONE).greaterOrEqual(3.0).as(SeverityLevel.INFO).greaterOrEqual(7.0).as(SeverityLevel.WARNING).greaterOrEqual(10.0).as(SeverityLevel.ERROR).greaterOrEqual(15.0).as(SeverityLevel.CRITICAL).then();
                WatchBuilder.AbstractActionBuilder abstractActionBuilder = null;
                for (String actionName : actionNames) {
                    if (abstractActionBuilder != null) {
                        abstractActionBuilder.and();
                    }
                    abstractActionBuilder = severityMappingBuilder.index(outputAlarmIndex).name(actionName);
                }
                Watch watch = abstractActionBuilder.build();
                String watchPath = this.createWatchPath(watchId);
                log.info("Predefined watch will be created using path '{}' and body '{}'", (Object)watchPath, (Object)watch.toJson());
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.anyOf((Matcher)CoreMatchers.equalTo((Object)201), (Matcher)CoreMatchers.equalTo((Object)200)));
                WatchPointer watchPointer2 = new WatchPointer(watchPath);
                this.watchesToDelete.add(watchPointer2);
                watchPointer = watchPointer2;
                if (restClient == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (restClient != null) {
                        try {
                            restClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot define test watch", e);
                }
            }
            restClient.close();
        }
        return watchPointer;
    }

    public WatchPointer defineErrorWatch(String watchId, String inputTemperatureIndex, double temperatureLimit, String actionName) {
        WatchPointer watchPointer;
        block8: {
            String aggregationNameMaxTemperature = "max_temperature";
            String maxTemperatureSearch = "max_temperature_search";
            String maxTemperatureLimitName = "max_temperature";
            String staticLimitsName = "limits";
            String tooHighTemperatureCondition = "data." + "max_temperature_search" + ".aggregations." + "max_temperature" + "value > data." + "limits" + "." + "max_temperature";
            GenericRestClient restClient = this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.watchUser, new Header[0]);
            try {
                DocNode aggregation = DocNode.of((String)"max_temperature", (Object)DocNode.of((String)"max", (Object)DocNode.of((String)"field", (Object)"temperature")));
                Watch watch = new WatchBuilder(watchId).triggerNow().search(inputTemperatureIndex).size(0).aggregation(aggregation).as("max_temperature_search").put(String.format("{\"%s\": %.2f}", "max_temperature", temperatureLimit)).as("limits").checkCondition(tooHighTemperatureCondition).consider("data.max_temperature_search.aggregations.max_temperature.value").greaterOrEqual(0.0).as(SeverityLevel.NONE).greaterOrEqual(3.0).as(SeverityLevel.INFO).greaterOrEqual(7.0).as(SeverityLevel.WARNING).greaterOrEqual(10.0).as(SeverityLevel.ERROR).greaterOrEqual(15.0).as(SeverityLevel.CRITICAL).then().index("! this is an invalid index name !?#").name(actionName).build();
                String watchPath = this.createWatchPath(watchId);
                log.info("Predefined watch will be created using path '{}' and body '{}'", (Object)watchPath, (Object)watch.toJson());
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)201));
                WatchPointer watchPointer2 = new WatchPointer(watchPath);
                this.watchesToDelete.add(watchPointer2);
                watchPointer = watchPointer2;
                if (restClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restClient != null) {
                        try {
                            restClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot define test watch", e);
                }
            }
            restClient.close();
        }
        return watchPointer;
    }

    public WatchPointer defineTemperatureSeverityWatchWithCronTrigger(String watchId, String inputTemperatureIndex, String outputAlarmIndex, double temperatureLimit, String actionName, String cronExpression) {
        WatchPointer watchPointer;
        block8: {
            String aggregationNameMaxTemperature = "max_temperature";
            String maxTemperatureSearch = "max_temperature_search";
            String maxTemperatureLimitName = "max_temperature";
            String staticLimitsName = "limits";
            String tooHighTemperatureCondition = "data." + "max_temperature_search" + ".aggregations." + "max_temperature" + ".value > data." + "limits" + "." + "max_temperature";
            GenericRestClient restClient = this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.watchUser, new Header[0]);
            try {
                DocNode aggregation = DocNode.of((String)"max_temperature", (Object)DocNode.of((String)"max", (Object)DocNode.of((String)"field", (Object)"temperature")));
                Watch watch = new WatchBuilder(watchId).cronTrigger(cronExpression).search(inputTemperatureIndex).size(0).aggregation(aggregation).as("max_temperature_search").put(String.format("{\"%s\": %.2f}", "max_temperature", temperatureLimit)).as("limits").checkCondition(tooHighTemperatureCondition).consider("data.max_temperature_search.aggregations.max_temperature.value").greaterOrEqual(0.0).as(SeverityLevel.NONE).greaterOrEqual(3.0).as(SeverityLevel.INFO).greaterOrEqual(7.0).as(SeverityLevel.WARNING).greaterOrEqual(10.0).as(SeverityLevel.ERROR).greaterOrEqual(15.0).as(SeverityLevel.CRITICAL).then().index(outputAlarmIndex).name(actionName).build();
                String watchPath = this.createWatchPath(watchId);
                log.info("Predefined watch will be created using path '{}' and body '{}'", (Object)watchPath, (Object)watch.toJson());
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)201));
                WatchPointer watchPointer2 = new WatchPointer(watchPath);
                this.watchesToDelete.add(watchPointer2);
                watchPointer = watchPointer2;
                if (restClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restClient != null) {
                        try {
                            restClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot define test watch", e);
                }
            }
            restClient.close();
        }
        return watchPointer;
    }

    public WatchPointer defineSimpleTemperatureWatch(String watchId, String inputTemperatureIndex, String outputAlarmIndex, double temperatureLimit) {
        WatchPointer watchPointer;
        block8: {
            String aggregationNameMaxTemperature = "max_temperature";
            String maxTemperatureSearch = "max_temperature_search";
            String maxTemperatureLimitName = "max_temperature";
            String staticLimitsName = "limits";
            String tooHighTemperatureCondition = "data." + "max_temperature_search" + ".aggregations." + "max_temperature" + ".value > data." + "limits" + "." + "max_temperature";
            GenericRestClient restClient = this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.watchUser, new Header[0]);
            try {
                DocNode aggregation = DocNode.of((String)"max_temperature", (Object)DocNode.of((String)"max", (Object)DocNode.of((String)"field", (Object)"temperature")));
                Watch watch = new WatchBuilder(watchId).triggerNow().search(inputTemperatureIndex).size(0).aggregation(aggregation).as("max_temperature_search").put(String.format("{\"%s\": %.2f}", "max_temperature", temperatureLimit)).as("limits").checkCondition(tooHighTemperatureCondition).consider("data.max_temperature_search.aggregations.max_temperature.value").greaterOrEqual(-1000.0).as(SeverityLevel.INFO).then().index(outputAlarmIndex).name("createAlarm").build();
                String watchPath = this.createWatchPath(watchId);
                log.info("Predefined watch will be created using path '{}' and body '{}'", (Object)watchPath, (Object)watch.toJson());
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
                log.info("Watch creation response code '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)201));
                WatchPointer watchPointer2 = new WatchPointer(watchPath);
                this.watchesToDelete.add(watchPointer2);
                watchPointer = watchPointer2;
                if (restClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restClient != null) {
                        try {
                            restClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot define test watch", e);
                }
            }
            restClient.close();
        }
        return watchPointer;
    }

    public WatchPointer defineSimpleTemperatureWatchWitDoubleActions(String watchId, String inputTemperatureIndex, String outputAlarmIndex, double temperatureLimit) {
        WatchPointer watchPointer;
        block8: {
            String aggregationNameMaxTemperature = "max_temperature";
            String maxTemperatureSearch = "max_temperature_search";
            String maxTemperatureLimitName = "max_temperature";
            String staticLimitsName = "limits";
            String tooHighTemperatureCondition = "data." + "max_temperature_search" + ".aggregations." + "max_temperature" + ".value > data." + "limits" + "." + "max_temperature";
            GenericRestClient restClient = this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.watchUser, new Header[0]);
            try {
                DocNode aggregation = DocNode.of((String)"max_temperature", (Object)DocNode.of((String)"max", (Object)DocNode.of((String)"field", (Object)"temperature")));
                Watch watch = new WatchBuilder(watchId).triggerNow().search(inputTemperatureIndex).size(0).aggregation(aggregation).as("max_temperature_search").put(String.format("{\"%s\": %.2f}", "max_temperature", temperatureLimit)).as("limits").checkCondition(tooHighTemperatureCondition).consider("data.max_temperature_search.aggregations.max_temperature.value").greaterOrEqual(-1000.0).as(SeverityLevel.INFO).then().index(outputAlarmIndex).name(ACTION_CREATE_ALARM_ONE).and().index(outputAlarmIndex).name(ACTION_CREATE_ALARM_TWO).build();
                String watchPath = this.createWatchPath(watchId);
                log.info("Predefined watch will be created using path '{}' and body '{}'", (Object)watchPath, (Object)watch.toJson());
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)201));
                WatchPointer watchPointer2 = new WatchPointer(watchPath);
                this.watchesToDelete.add(watchPointer2);
                watchPointer = watchPointer2;
                if (restClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restClient != null) {
                        try {
                            restClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot define test watch", e);
                }
            }
            restClient.close();
        }
        return watchPointer;
    }

    public WatchPointer defineSimpleTemperatureWatchWitDoubleActionsAndVariousSeverity(String watchId, String inputTemperatureIndex, String outputAlarmIndex, double temperatureLimit) {
        WatchPointer watchPointer;
        block8: {
            String aggregationNameMaxTemperature = "max_temperature";
            String maxTemperatureSearch = "max_temperature_search";
            String maxTemperatureLimitName = "max_temperature";
            String staticLimitsName = "limits";
            String tooHighTemperatureCondition = "data." + "max_temperature_search" + ".aggregations." + "max_temperature" + ".value > data." + "limits" + "." + "max_temperature";
            GenericRestClient restClient = this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.watchUser, new Header[0]);
            try {
                DocNode aggregation = DocNode.of((String)"max_temperature", (Object)DocNode.of((String)"max", (Object)DocNode.of((String)"field", (Object)"temperature")));
                Watch watch = new WatchBuilder(watchId).triggerNow().search(inputTemperatureIndex).size(0).aggregation(aggregation).as("max_temperature_search").put(String.format("{\"%s\": %.2f}", "max_temperature", temperatureLimit)).as("limits").checkCondition(tooHighTemperatureCondition).consider("data.max_temperature_search.aggregations.max_temperature.value").greaterOrEqual(0.0).as(SeverityLevel.NONE).greaterOrEqual(3.0).as(SeverityLevel.INFO).greaterOrEqual(7.0).as(SeverityLevel.WARNING).greaterOrEqual(10.0).as(SeverityLevel.ERROR).greaterOrEqual(15.0).as(SeverityLevel.CRITICAL).then().when(SeverityLevel.ERROR, SeverityLevel.WARNING).index(outputAlarmIndex).name(ACTION_CREATE_ALARM_ONE).and().when(SeverityLevel.CRITICAL, new SeverityLevel[0]).index(outputAlarmIndex).name(ACTION_CREATE_ALARM_TWO).build();
                String watchPath = this.createWatchPath(watchId);
                log.info("Predefined watch will be created using path '{}' and body '{}'", (Object)watchPath, (Object)watch.toJson());
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)201));
                WatchPointer watchPointer2 = new WatchPointer(watchPath);
                this.watchesToDelete.add(watchPointer2);
                watchPointer = watchPointer2;
                if (restClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restClient != null) {
                        try {
                            restClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot define test watch", e);
                }
            }
            restClient.close();
        }
        return watchPointer;
    }

    private String createWatchPath(String watchId) {
        return "/_signals/watch/" + this.tenant + "/" + watchId;
    }

    public void deleteWatches() {
        for (WatchPointer watchPointer : this.watchesToDelete) {
            try {
                watchPointer.delete();
                log.info("Watch '{}' deleted.", (Object)watchPointer);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot delete watch " + String.valueOf(watchPointer), ex);
            }
        }
        this.watchesToDelete.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCountOfDocuments(String index) throws InterruptedException, ExecutionException {
        Client client = this.localCluster.getPrivilegedInternalNodeClient();
        SearchRequest request = new SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        request.source(searchSourceBuilder);
        SearchResponse response = (SearchResponse)client.search(request).get();
        try {
            long l = response.getHits().getTotalHits().value;
            return l;
        }
        finally {
            response.decRef();
        }
    }

    public long countWatchStatusWithAvailableStatusCode(String watchStateIndexName) {
        ExistsQueryBuilder query = QueryBuilders.existsQuery((String)"last_status.code");
        return this.countWatchByQuery(watchStateIndexName, (QueryBuilder)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countWatchByQuery(String watchStateIndexName, QueryBuilder query) {
        long l;
        Client client = this.localCluster.getPrivilegedInternalNodeClient();
        SearchRequest request = new SearchRequest(new String[]{watchStateIndexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(query);
        request.source(searchSourceBuilder);
        SearchResponse response = (SearchResponse)client.search(request).get();
        try {
            l = response.getHits().getTotalHits().value;
        }
        catch (Throwable throwable) {
            try {
                response.decRef();
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Cannot count watch states with available status code.", e);
            }
        }
        response.decRef();
        return l;
    }

    public long countWatchByActionName(String watchStateIndexName, String actionName) {
        return this.countWatchByQuery(watchStateIndexName, (QueryBuilder)QueryBuilders.existsQuery((String)("actions." + actionName)));
    }

    public long countWatchByAckStatus(String watchStateIndexName, String actionName) {
        return this.countWatchByQuery(watchStateIndexName, (QueryBuilder)QueryBuilders.existsQuery((String)("actions." + actionName + ".acked.on")));
    }

    public boolean watchHasEmptyLastStatus(String watchIdWithTenantPrefix) {
        Objects.requireNonNull(watchIdWithTenantPrefix, "Watch id is required");
        if (!watchIdWithTenantPrefix.contains("/")) {
            throw new IllegalArgumentException("Watch id must contain tenant prefix, e.g. 'tenant/watchIdWithTenantPrefix'. Provided: " + watchIdWithTenantPrefix);
        }
        Client client = this.localCluster.getPrivilegedInternalNodeClient();
        GetResponse getResponse = (GetResponse)client.get(new GetRequest(".signals_watches_state", watchIdWithTenantPrefix)).actionGet();
        if (getResponse.isExists()) {
            DocNode sources = DocNode.wrap((Object)getResponse.getSourceAsMap());
            DocNode lastStatus = sources.getAsNode("last_status");
            return lastStatus == null || lastStatus.isEmpty();
        }
        return false;
    }

    public WatchPointer defineTemperatureWatchWithActionOnCriticalSeverity(String watchId, String inputTemperatureIndex, String outputAlarmIndex, double temperatureLimit) {
        WatchPointer watchPointer;
        block8: {
            String aggregationNameMaxTemperature = "max_temperature";
            String maxTemperatureSearch = "max_temperature_search";
            String maxTemperatureLimitName = "max_temperature";
            String staticLimitsName = "limits";
            String tooHighTemperatureCondition = "data." + "max_temperature_search" + ".aggregations." + "max_temperature" + ".value > data." + "limits" + "." + "max_temperature";
            GenericRestClient restClient = this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.watchUser, new Header[0]);
            try {
                DocNode aggregation = DocNode.of((String)"max_temperature", (Object)DocNode.of((String)"max", (Object)DocNode.of((String)"field", (Object)"temperature")));
                Watch watch = new WatchBuilder(watchId).triggerNow().search(inputTemperatureIndex).size(0).aggregation(aggregation).as("max_temperature_search").put(String.format("{\"%s\": %.2f}", "max_temperature", temperatureLimit)).as("limits").checkCondition(tooHighTemperatureCondition).consider("data.max_temperature_search.aggregations.max_temperature.value").greaterOrEqual(0.0).as(SeverityLevel.NONE).greaterOrEqual(3.0).as(SeverityLevel.INFO).greaterOrEqual(10.0).as(SeverityLevel.ERROR).greaterOrEqual(15.0).as(SeverityLevel.CRITICAL).when(SeverityLevel.CRITICAL, new SeverityLevel[0]).index(outputAlarmIndex).refreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).name("createAlarm").build();
                String watchPath = this.createWatchPath(watchId);
                log.info("Predefined watch will be created using path '{}' and body '{}'", (Object)watchPath, (Object)watch.toJson());
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)201));
                WatchPointer watchPointer2 = new WatchPointer(watchPath);
                this.watchesToDelete.add(watchPointer2);
                watchPointer = watchPointer2;
                if (restClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restClient != null) {
                        try {
                            restClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot define test watch", e);
                }
            }
            restClient.close();
        }
        return watchPointer;
    }

    public class WatchPointer {
        private final String watchPath;

        private WatchPointer(String watchPath) {
            this.watchPath = Objects.requireNonNull(watchPath);
        }

        public void delete() {
            try (GenericRestClient restClient = PredefinedWatches.this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)PredefinedWatches.this.watchUser, new Header[0]);){
                GenericRestClient.HttpResponse response = restClient.delete(this.watchPath, new Header[0]);
                log.info("Delete '{}' watch response code '{}' and body '{}'.", (Object)this.watchPath, (Object)response.getStatusCode(), (Object)response.getBody());
                Awaitility.await().until(this::notExist);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot delete watch", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean exists() {
            try (GenericRestClient restClient = PredefinedWatches.this.localCluster.getRestClient((EsClientProvider.UserCredentialsHolder)PredefinedWatches.this.watchUser, new Header[0]);){
                GenericRestClient.HttpResponse response = restClient.get(this.watchPath, new Header[0]);
                int statusCode = response.getStatusCode();
                switch (statusCode) {
                    case 200: {
                        boolean bl = true;
                        return bl;
                    }
                    case 404: {
                        boolean bl = false;
                        return bl;
                    }
                }
                throw new RuntimeException("Cannot check if watch " + this.watchPath + " exists.");
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot check if watch " + this.watchPath + " exists.", e);
            }
        }

        public boolean notExist() {
            return !this.exists();
        }

        public String toString() {
            return "WatchPointer{watchPath='" + this.watchPath + "'}";
        }
    }
}

