/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.signals.watch.common.ProxyTypeProvider;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProxyTypeProviderTest {
    private final String proxyValue;
    private final ProxyTypeProvider.Type expectedType;

    public ProxyTypeProviderTest(String proxyValue, ProxyTypeProvider.Type expectedType) {
        this.proxyValue = proxyValue;
        this.expectedType = expectedType;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testParameters() {
        return Arrays.asList({null, ProxyTypeProvider.Type.USE_DEFAULT_PROXY}, {"", ProxyTypeProvider.Type.USE_DEFAULT_PROXY}, {"default", ProxyTypeProvider.Type.USE_DEFAULT_PROXY}, {"dEfAUlT", ProxyTypeProvider.Type.USE_DEFAULT_PROXY}, {"none", ProxyTypeProvider.Type.USE_NO_PROXY}, {"NoNe", ProxyTypeProvider.Type.USE_NO_PROXY}, {"http://127.0.0.1", ProxyTypeProvider.Type.USE_INLINE_PROXY}, {"hTTp://127.0.0.1", ProxyTypeProvider.Type.USE_INLINE_PROXY}, {"https://127.0.0.1", ProxyTypeProvider.Type.USE_INLINE_PROXY}, {"hTTpS://127.0.0.1", ProxyTypeProvider.Type.USE_INLINE_PROXY}, {"id", ProxyTypeProvider.Type.USE_STORED_PROXY}, {"adefault", ProxyTypeProvider.Type.USE_STORED_PROXY});
    }

    @Test
    public void shouldDetermineProxyTypeBasedOnProxyValue() {
        ProxyTypeProvider.Type determinedType = ProxyTypeProvider.determineTypeBasedOnValue((String)this.proxyValue);
        MatcherAssert.assertThat((Object)determinedType, (Matcher)Matchers.equalTo((Object)this.expectedType));
    }
}

