/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.checks;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.watch.checks.AbstractInput;
import com.floragunn.signals.watch.checks.Check;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class StaticInput
extends AbstractInput {
    private Map<String, Object> value;

    static Check create(DocNode jsonObject) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonObject, validationErrors);
        vJsonNode.used(new String[]{"type"});
        String name = vJsonNode.get("name").asString();
        String target = vJsonNode.get("target").asString();
        ImmutableMap value = Collections.emptyMap();
        if (vJsonNode.hasNonNull("value_no_map")) {
            value = jsonObject.getAsNode("value_no_map").toMap();
        } else if (vJsonNode.hasNonNull("value")) {
            value = jsonObject.getAsNode("value").toMap();
        }
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        StaticInput result = new StaticInput(name, target, (Map<String, Object>)value);
        return result;
    }

    public StaticInput(String name, String target, Map<String, Object> value) {
        super(name, target);
        this.value = Collections.unmodifiableMap(value);
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    @Override
    public boolean execute(WatchExecutionContext ctx) {
        if (this.value != null) {
            ctx.getContextData().getData().put(this.target, this.value);
        }
        return true;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", "static");
        builder.field("name", this.name);
        builder.field("target", this.target);
        builder.field("value_no_map", this.value);
        builder.endObject();
        return builder;
    }

    static void addIndexMappingProperties(NestedValueMap mapping) {
        mapping.put(new NestedValueMap.Path("value_no_map", "type"), (Object)"object");
        mapping.put(new NestedValueMap.Path("value_no_map", "dynamic"), (Object)true);
        mapping.put(new NestedValueMap.Path("value_no_map", "enabled"), (Object)false);
    }

    public static void patchForIndexMappingBugFix(Map<String, Object> watchJson) {
        if (watchJson.get("checks") instanceof List) {
            for (Object checkObject : (List)watchJson.get("checks")) {
                Object value;
                Map check;
                if (!(checkObject instanceof Map) || !"static".equals((check = (Map)checkObject).get("type")) || (value = check.remove("value")) == null) continue;
                check.put("value_no_map", value);
            }
        }
        if (watchJson.get("actions") instanceof List) {
            for (Object actionObject : (List)watchJson.get("actions")) {
                Map action;
                if (!(actionObject instanceof Map) || !((action = (Map)actionObject).get("checks") instanceof List)) continue;
                for (Object checkObject : (List)action.get("checks")) {
                    Object value;
                    Map check;
                    if (!(checkObject instanceof Map) || !"static".equals((check = (Map)checkObject).get("type")) || (value = check.remove("value")) == null) continue;
                    check.put("value_no_map", value);
                }
            }
        }
    }

    public static void unpatchForIndexMappingBugFix(Map<String, Object> watchJson) {
        if (watchJson.get("checks") instanceof List) {
            for (Object checkObject : (List)watchJson.get("checks")) {
                Object value;
                Map check;
                if (!(checkObject instanceof Map) || !"static".equals((check = (Map)checkObject).get("type")) || (value = check.remove("value_no_map")) == null) continue;
                check.put("value", value);
            }
        }
        if (watchJson.get("actions") instanceof List) {
            for (Object actionObject : (List)watchJson.get("actions")) {
                Map action;
                if (!(actionObject instanceof Map) || !((action = (Map)actionObject).get("checks") instanceof List)) continue;
                for (Object checkObject : (List)action.get("checks")) {
                    Object value;
                    Map check;
                    if (!(checkObject instanceof Map) || !"static".equals((check = (Map)checkObject).get("type")) || (value = check.remove("value_no_map")) == null) continue;
                    check.put("value", value);
                }
            }
        }
    }
}

