/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.confconv.es;

import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.confconv.ConversionResult;

public class MustacheTemplateConverter {
    private final String script;

    MustacheTemplateConverter(String script) {
        this.script = script;
    }

    public ConversionResult<String> convertToSignals() {
        if (this.script == null) {
            return new ConversionResult<Object>(null);
        }
        ValidationErrors validationErrors = new ValidationErrors();
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.script.length()) {
            String expression;
            int expressionStart = this.script.indexOf("{{", i);
            if (expressionStart == -1) {
                result.append(this.script.substring(i));
                break;
            }
            int expressionEnd = this.script.indexOf("}}", expressionStart + 1);
            if (expressionEnd == -1) {
                result.append(this.script.substring(i));
                break;
            }
            result.append(this.script.substring(i, expressionStart));
            result.append("{{");
            String convertedExpression = expression = this.script.substring(expressionStart + 2, expressionEnd);
            if (expression.contains("ctx.payload.")) {
                convertedExpression = convertedExpression.replace("ctx.payload.", "data.");
            } else if (expression.contains("params.")) {
                validationErrors.add(new ValidationError(null, "params script attribute is not supported by Signals"));
            } else if (expression.contains("ctx.metadata.")) {
                convertedExpression = convertedExpression.replace("ctx.metadata.", "data.");
            } else if (expression.contains("ctx.trigger.")) {
                convertedExpression = convertedExpression.replace("ctx.trigger.", "trigger.");
            }
            result.append(convertedExpression);
            result.append("}}");
            i = expressionEnd + 2;
        }
        return new ConversionResult<String>(result.toString());
    }
}

