/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.CertificatesParser;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.common.RefreshableX509TrustManager;
import com.floragunn.signals.watch.common.RejectAllTrustManager;
import com.floragunn.signals.watch.common.TlsClientAuthConfig;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class TlsConfig
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(TlsConfig.class);
    private static final List<String> DEFAULT_TLS_PROTOCOLS = ImmutableList.of((Object)"TLSv1.2", (Object)"TLSv1.1");
    public static final String FIELD_TRUSTSTORE_ID = "truststore_id";
    public static final String FIELD_CLIENT_SESSION_TIMEOUT = "client_session_timeout";
    private String inlineTruststorePem;
    private Collection<? extends Certificate> inlineTrustCerts;
    private KeyStore trustStore;
    private TlsClientAuthConfig clientAuthConfig;
    private boolean verifyHostnames;
    private boolean trustAll;
    private SSLContext sslContext;
    private final TrustManagerRegistry trustManagerRegistry;
    private final ValidationLevel validationLevel;
    private String truststoreId;
    private Integer clientSessionTimeout = null;

    public TlsConfig(TrustManagerRegistry trustManagerRegistry, ValidationLevel validationLevel) {
        this.trustManagerRegistry = Objects.requireNonNull(trustManagerRegistry, "TrustManagerRegistry ia required");
        this.validationLevel = validationLevel;
        log.debug("TlsConfig created with trust manager registry '{}' and strict validation '{}'", (Object)trustManagerRegistry, (Object)this.validationLevel);
    }

    public void init(DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        this.inlineTruststorePem = vJsonNode.get("trusted_certs").asString();
        this.truststoreId = vJsonNode.get(FIELD_TRUSTSTORE_ID).withDefault((String)null).asString();
        this.verifyHostnames = vJsonNode.get("verify_hostnames").withDefault(true).asBoolean();
        this.trustAll = vJsonNode.get("trust_all").withDefault(false).asBoolean();
        this.clientAuthConfig = (TlsClientAuthConfig)vJsonNode.get("client_auth").by(TlsClientAuthConfig::create);
        this.clientSessionTimeout = vJsonNode.hasNonNull(FIELD_CLIENT_SESSION_TIMEOUT) ? vJsonNode.get(FIELD_CLIENT_SESSION_TIMEOUT).asInteger() : null;
        this.init(validationErrors);
        validationErrors.throwExceptionForPresentErrors();
    }

    public void init() throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        this.init(validationErrors);
        validationErrors.throwExceptionForPresentErrors();
    }

    private void init(ValidationErrors validationErrors) {
        log.info("Init TLS config with strict validation '{}'.", (Object)this.validationLevel);
        String currentTruststoreId = this.truststoreId;
        try {
            if (Strings.isNullOrEmpty((String)currentTruststoreId)) {
                this.inlineTrustCerts = CertificatesParser.parseCertificates(this.inlineTruststorePem);
            }
            this.trustStore = CertificatesParser.toTruststore("prefix", this.inlineTrustCerts);
            if (!Strings.isNullOrEmpty((String)currentTruststoreId) && !Strings.isNullOrEmpty((String)this.inlineTruststorePem)) {
                String message = "Parameters truststore_id and trusted_certs cannot be combined.";
                validationErrors.add("tls", new ValidationErrors(new ValidationError(FIELD_TRUSTSTORE_ID, message)));
            }
        }
        catch (ConfigValidationException e) {
            validationErrors.add("trusted_certs", e);
        }
        try {
            this.sslContext = this.buildSSLContext(validationErrors);
        }
        catch (ConfigValidationException e) {
            validationErrors.add(null, e);
        }
    }

    public void setTruststoreId(String truststoreId) {
        this.truststoreId = truststoreId;
    }

    public void setClientSessionTimeout(Integer clientSessionTimeoutInSec) {
        this.clientSessionTimeout = clientSessionTimeoutInSec;
    }

    KeyStore getTrustStore() {
        return this.trustStore;
    }

    SSLContext buildSSLContext(ValidationErrors validationErrors) throws ConfigValidationException {
        log.debug("Building SSL context");
        try {
            if (this.trustAll) {
                log.debug("Overly trustful SSL context created");
                return new OverlyTrustfulSSLContextBuilder().build();
            }
            RefreshableTruststoreSSLContextBuilder sslContextBuilder = RefreshableTruststoreSSLContextBuilder.createRefreshable();
            String currentTruststoreId = this.truststoreId;
            log.debug("Trust store id defined in tls config '{}', and trust store '{}'", (Object)currentTruststoreId, (Object)this.trustStore);
            sslContextBuilder.setClientSessionTimeout(this.clientSessionTimeout);
            if (!Strings.isNullOrEmpty((String)currentTruststoreId)) {
                this.validateTruststoreIdIfStrictValidationIsRequired(currentTruststoreId);
                com.google.common.base.Supplier<X509ExtendedTrustManager> trustManagerSupplier = this.createTrustManagerSupplier(currentTruststoreId);
                sslContextBuilder.setTrustManager(new RefreshableX509TrustManager(currentTruststoreId, (Supplier<X509ExtendedTrustManager>)trustManagerSupplier));
            } else if (this.trustStore != null) {
                try {
                    sslContextBuilder.loadTrustMaterial(this.trustStore, null);
                }
                catch (KeyStoreException | NoSuchAlgorithmException e) {
                    log.error("Error while building SSLContext for " + String.valueOf(this), (Throwable)e);
                    throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
                }
            }
            if (this.clientAuthConfig != null) {
                log.debug("Client auth for SSL context available");
                try {
                    this.clientAuthConfig.loadKeyMaterial(sslContextBuilder);
                }
                catch (ConfigValidationException e) {
                    validationErrors.add("client_auth", e);
                }
            }
            log.debug("SSL context will be created using builder '{}'", (Object)sslContextBuilder);
            return sslContextBuilder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("Error while building SSLContext for " + String.valueOf(this), (Throwable)e);
            throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
        }
    }

    private void validateTruststoreIdIfStrictValidationIsRequired(String truststoreId) throws ConfigValidationException {
        log.debug("Validation of truststore with id '{}' will be performed '{}'.", (Object)truststoreId, (Object)this.validationLevel);
        if (this.validationLevel.isStrictValidation()) {
            this.trustManagerRegistry.findTrustManager(truststoreId).orElseThrow(() -> {
                ValidationError validationError = new ValidationError(null, "Trust store " + truststoreId + " not found.");
                return new ConfigValidationException(validationError);
            });
        }
    }

    private com.google.common.base.Supplier<X509ExtendedTrustManager> createTrustManagerSupplier(String currentTruststoreId) {
        return () -> this.trustManagerRegistry.findTrustManager(currentTruststoreId).orElseGet(() -> {
            log.warn("Watch uses not existing truststore with id '{}', all TLS connection will be impossible.", (Object)currentTruststoreId);
            return new RejectAllTrustManager(currentTruststoreId);
        });
    }

    private HostnameVerifier getHostnameVerifier() {
        if (this.verifyHostnames) {
            return new DefaultHostnameVerifier();
        }
        return NoopHostnameVerifier.INSTANCE;
    }

    private String[] getSupportedProtocols() {
        return DEFAULT_TLS_PROTOCOLS.toArray(new String[DEFAULT_TLS_PROTOCOLS.size()]);
    }

    private String[] getSupportedCipherSuites() {
        return null;
    }

    public SSLConnectionSocketFactory toSSLConnectionSocketFactory() {
        return new SSLConnectionSocketFactory(this.sslContext, this.getSupportedProtocols(), this.getSupportedCipherSuites(), this.getHostnameVerifier());
    }

    public static TlsConfig create(DocNode jsonNode, TrustManagerRegistry trustManagerRegistry, ValidationLevel validationLevel) throws ConfigValidationException {
        TlsConfig result = new TlsConfig(trustManagerRegistry, validationLevel);
        result.init(jsonNode);
        return result;
    }

    public static TlsConfig parseJson(String json, TrustManagerRegistry trustManagerRegistry) throws ConfigValidationException {
        return TlsConfig.create(DocNode.parse((Format)Format.JSON).from(json), trustManagerRegistry, ValidationLevel.LENIENT);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inlineTruststorePem != null) {
            builder.field("trusted_certs", this.inlineTruststorePem);
        }
        if (this.truststoreId != null) {
            builder.field(FIELD_TRUSTSTORE_ID, this.truststoreId);
        }
        if (this.clientSessionTimeout != null) {
            builder.field(FIELD_CLIENT_SESSION_TIMEOUT, this.clientSessionTimeout);
        }
        if (this.clientAuthConfig != null) {
            builder.field("client_auth");
            this.clientAuthConfig.toXContent(builder, params);
        }
        if (this.verifyHostnames) {
            builder.field("verify_hostnames", this.verifyHostnames);
        }
        if (this.trustAll) {
            builder.field("trust_all", this.trustAll);
        }
        builder.endObject();
        return builder;
    }

    public String getInlineTruststorePem() {
        return this.inlineTruststorePem;
    }

    public void setInlineTruststorePem(String inlineTruststorePem) {
        this.inlineTruststorePem = inlineTruststorePem;
    }

    public TlsClientAuthConfig getClientAuthConfig() {
        return this.clientAuthConfig;
    }

    public void setClientAuthConfig(TlsClientAuthConfig clientAuthConfig) {
        this.clientAuthConfig = clientAuthConfig;
    }

    public boolean isVerifyHostnames() {
        return this.verifyHostnames;
    }

    public void setVerifyHostnames(boolean verifyHostnames) {
        this.verifyHostnames = verifyHostnames;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    private static class OverlyTrustfulSSLContextBuilder
    extends SSLContextBuilder {
        private OverlyTrustfulSSLContextBuilder() {
        }

        protected void initSSLContext(SSLContext sslContext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers, SecureRandom secureRandom) throws KeyManagementException {
            sslContext.init(!keyManagers.isEmpty() ? keyManagers.toArray(new KeyManager[keyManagers.size()]) : null, new TrustManager[]{new OverlyTrustfulTrustManager()}, secureRandom);
        }
    }

    private static class RefreshableTruststoreSSLContextBuilder
    extends SSLContextBuilder {
        private volatile TrustManager trustManager;
        private volatile Integer clientSessionTimeout;

        private RefreshableTruststoreSSLContextBuilder() {
        }

        public static RefreshableTruststoreSSLContextBuilder createRefreshable() {
            return new RefreshableTruststoreSSLContextBuilder();
        }

        public void setTrustManager(TrustManager trustManager) {
            this.trustManager = trustManager;
        }

        public void setClientSessionTimeout(Integer clientSessionTimeout) {
            this.clientSessionTimeout = clientSessionTimeout;
        }

        protected void initSSLContext(SSLContext sslContext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers, SecureRandom secureRandom) throws KeyManagementException {
            TrustManager currentTrustManager = this.trustManager;
            if (currentTrustManager != null) {
                trustManagers = Collections.singleton(currentTrustManager);
            }
            if (Objects.nonNull(this.clientSessionTimeout)) {
                sslContext.getClientSessionContext().setSessionTimeout(this.clientSessionTimeout);
            }
            log.debug("Trust managers inserted into SSL context '{}', client session timeout '{}'.", trustManagers, (Object)this.clientSessionTimeout);
            super.initSSLContext(sslContext, keyManagers, trustManagers, secureRandom);
        }
    }

    private static class OverlyTrustfulTrustManager
    implements X509TrustManager {
        private OverlyTrustfulTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

