/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.watch.common.HttpProxyConfig;
import com.floragunn.signals.watch.common.ProxyTypeProvider;
import com.floragunn.signals.watch.common.ValidationLevel;
import java.util.Optional;
import org.apache.http.HttpHost;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class HttpProxyConfigTest {
    @Mock
    private HttpProxyHostRegistry httpProxyHostRegistry;

    @Test
    public void createHttpProxyConfig_shouldThrowError_proxyWithGivenIdDoesNotExists_andStrictValidationIsUsed() {
        String proxyId = "1";
        Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(proxyId)).thenReturn(Optional.empty());
        ValidatingDocNode config = new ValidatingDocNode(DocNode.of((String)"proxy", (Object)proxyId), new ValidationErrors());
        ConfigValidationException exception = (ConfigValidationException)ThrowableAssert.assertThatThrown(() -> HttpProxyConfig.create((ValidatingDocNode)config, (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT), (Matcher[])new Matcher[]{Matchers.instanceOf(ConfigValidationException.class)});
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)("Http proxy '" + proxyId + "' not found.")));
    }

    @Test
    public void createHttpProxyConfig_shouldNotThrowError_proxyWithGivenIdDoesNotExists_andLenientValidationIsUsed() throws ConfigValidationException {
        String proxyId = "1";
        Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(proxyId)).thenReturn(Optional.empty());
        ValidatingDocNode config = new ValidatingDocNode(DocNode.of((String)"proxy", (Object)proxyId), new ValidationErrors());
        HttpProxyConfig createdConfig = HttpProxyConfig.create((ValidatingDocNode)config, (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.LENIENT);
        MatcherAssert.assertThat((Object)createdConfig.getProxy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)createdConfig.getType(), (Matcher)Matchers.equalTo((Object)ProxyTypeProvider.Type.USE_STORED_PROXY));
    }

    @Test
    public void createHttpProxyConfig_proxyConfigIsCreatedUsingGivenProxyId() throws ConfigValidationException {
        String proxyId = "1";
        String proxyUri = "http://1.1.1.1:1";
        Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(proxyId)).thenReturn(Optional.of(HttpHost.create((String)proxyUri)));
        ValidatingDocNode config = new ValidatingDocNode(DocNode.of((String)"proxy", (Object)proxyId), new ValidationErrors());
        HttpProxyConfig createdConfig = HttpProxyConfig.create((ValidatingDocNode)config, (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
        MatcherAssert.assertThat((Object)createdConfig.getProxy().toURI(), (Matcher)Matchers.equalTo((Object)proxyUri));
        MatcherAssert.assertThat((Object)createdConfig.getType(), (Matcher)Matchers.equalTo((Object)ProxyTypeProvider.Type.USE_STORED_PROXY));
    }

    @Test
    public void createHttpProxyConfig_proxyConfigIsCreatedUsingGivenProxyUri() throws ConfigValidationException {
        String proxyUri = "http://1.2.3.4:5";
        ValidatingDocNode config = new ValidatingDocNode(DocNode.of((String)"proxy", (Object)proxyUri), new ValidationErrors());
        HttpProxyConfig createdConfig = HttpProxyConfig.create((ValidatingDocNode)config, (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
        MatcherAssert.assertThat((Object)createdConfig.getProxy().toURI(), (Matcher)Matchers.equalTo((Object)proxyUri));
        MatcherAssert.assertThat((Object)createdConfig.getType(), (Matcher)Matchers.equalTo((Object)ProxyTypeProvider.Type.USE_INLINE_PROXY));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.httpProxyHostRegistry});
        config = new ValidatingDocNode(DocNode.of((String)"proxy", (Object)"default"), new ValidationErrors());
        createdConfig = HttpProxyConfig.create((ValidatingDocNode)config, (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
        MatcherAssert.assertThat((Object)createdConfig.getProxy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)createdConfig.getType(), (Matcher)Matchers.equalTo((Object)ProxyTypeProvider.Type.USE_DEFAULT_PROXY));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.httpProxyHostRegistry});
        config = new ValidatingDocNode(DocNode.of((String)"proxy", (Object)"none"), new ValidationErrors());
        createdConfig = HttpProxyConfig.create((ValidatingDocNode)config, (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
        MatcherAssert.assertThat((Object)createdConfig.getProxy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)createdConfig.getType(), (Matcher)Matchers.equalTo((Object)ProxyTypeProvider.Type.USE_NO_PROXY));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.httpProxyHostRegistry});
    }
}

