/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.signals.watch.common.RefreshableX509TrustManager;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RefreshableX509TrustManagerTest {
    public static final String AUTH_TYPE_1 = "auth-type-1";
    public static final String AUTH_TYPE_2 = "auth-type-2";
    public static final String AUTH_TYPE_3 = "auth-type-3";
    public static final X509Certificate[] CHAIN_OF_TRUST_1 = new X509Certificate[0];
    public static final X509Certificate[] CHAIN_OF_TRUST_2 = new X509Certificate[1];
    public static final X509Certificate[] CHAIN_OF_TRUST_3 = new X509Certificate[3];
    @Mock
    private X509ExtendedTrustManager mainTrustManagerOne;
    @Mock
    private X509ExtendedTrustManager mainTrustManagerTwo;
    @Mock
    private X509ExtendedTrustManager mainTrustManagerThree;
    @Mock
    private SSLEngine engine;
    @Mock
    private Socket socket;
    private RefreshableX509TrustManager trustManager;

    @Before
    public void before() {
        this.trustManager = new RefreshableX509TrustManager("test-trust-manager", () -> this.mainTrustManagerOne);
    }

    @Test
    public void shouldDelegateInvocationOfCheckServerTrustedForFirstChainOfTrust() throws CertificateException {
        this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1);
        this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1, this.engine);
        this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1, this.socket);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1, this.engine);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1, this.socket);
    }

    @Test
    public void shouldDelegateInvocationOfCheckServerTrustedForSecondChainOfTrust() throws CertificateException {
        this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2);
        this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2, this.engine);
        this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2, this.socket);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2, this.engine);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2, this.socket);
    }

    @Test
    public void shouldThrowAnExceptionWhenServerCertificateIsNotTrusted() throws CertificateException {
        CertificateException exception = new CertificateException("For test purposes");
        ((X509ExtendedTrustManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3);
        ((X509ExtendedTrustManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3, this.engine);
        ((X509ExtendedTrustManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3, this.socket);
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3), (Matcher[])new Matcher[]{Matchers.sameInstance((Object)exception)});
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3, this.engine), (Matcher[])new Matcher[]{Matchers.sameInstance((Object)exception)});
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3, this.socket), (Matcher[])new Matcher[]{Matchers.sameInstance((Object)exception)});
    }

    @Test
    public void shouldUseVariousTrustManagers() throws CertificateException {
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)((X509ExtendedTrustManager)supplier.get())).thenReturn((Object)this.mainTrustManagerOne, (Object[])new X509ExtendedTrustManager[]{this.mainTrustManagerTwo, this.mainTrustManagerThree});
        this.trustManager = new RefreshableX509TrustManager("custom-supplier", supplier);
        this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_3);
        this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2);
        this.trustManager.checkServerTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_1);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkServerTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_3);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerTwo)).checkServerTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerThree)).checkServerTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_1);
    }

    @Test
    public void shouldReturnAcceptedIssuersFirst() {
        Mockito.when((Object)this.mainTrustManagerOne.getAcceptedIssuers()).thenReturn((Object)CHAIN_OF_TRUST_1);
        X509Certificate[] acceptedIssuers = this.trustManager.getAcceptedIssuers();
        MatcherAssert.assertThat((Object)acceptedIssuers, (Matcher)Matchers.sameInstance((Object)CHAIN_OF_TRUST_1));
    }

    @Test
    public void shouldReturnAcceptedIssuersSecond() {
        Mockito.when((Object)this.mainTrustManagerOne.getAcceptedIssuers()).thenReturn((Object)CHAIN_OF_TRUST_2);
        X509Certificate[] acceptedIssuers = this.trustManager.getAcceptedIssuers();
        MatcherAssert.assertThat((Object)acceptedIssuers, (Matcher)Matchers.sameInstance((Object)CHAIN_OF_TRUST_2));
    }

    @Test
    public void shouldDelegateInvocationOfCheckClientTrustedForFirstChainOfTrust() throws CertificateException {
        this.trustManager.checkClientTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1);
        this.trustManager.checkClientTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1, this.engine);
        this.trustManager.checkClientTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1, this.socket);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkClientTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkClientTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1, this.engine);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkClientTrusted(CHAIN_OF_TRUST_1, AUTH_TYPE_1, this.socket);
    }

    @Test
    public void shouldDelegateInvocationOfCheckClientTrustedForSecondChainOfTrust() throws CertificateException {
        this.trustManager.checkClientTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2);
        this.trustManager.checkClientTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2, this.engine);
        this.trustManager.checkClientTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2, this.socket);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkClientTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkClientTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2, this.engine);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mainTrustManagerOne)).checkClientTrusted(CHAIN_OF_TRUST_2, AUTH_TYPE_2, this.socket);
    }

    @Test
    public void shouldThrowAnExceptionWhenClientCertificateIsNotTrusted() throws CertificateException {
        CertificateException exception = new CertificateException("For test purposes");
        ((X509ExtendedTrustManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mainTrustManagerOne)).checkClientTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3);
        ((X509ExtendedTrustManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mainTrustManagerOne)).checkClientTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3, this.engine);
        ((X509ExtendedTrustManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mainTrustManagerOne)).checkClientTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3, this.socket);
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkClientTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3), (Matcher[])new Matcher[]{Matchers.sameInstance((Object)exception)});
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkClientTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3, this.engine), (Matcher[])new Matcher[]{Matchers.sameInstance((Object)exception)});
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkClientTrusted(CHAIN_OF_TRUST_3, AUTH_TYPE_3, this.socket), (Matcher[])new Matcher[]{Matchers.sameInstance((Object)exception)});
    }
}

