/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.proxy.rest;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.SearchGuardVersion;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.signals.Signals;
import com.floragunn.signals.proxy.rest.TransportProxyUpdatedAction;
import com.floragunn.signals.proxy.service.NoSuchProxyException;
import com.floragunn.signals.proxy.service.ProxyCrudService;
import com.floragunn.signals.proxy.service.persistence.ProxyRepository;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.injection.guice.Inject;

public class ProxyApi {
    public static final RestApi REST_API = new RestApi().responseHeaders((Map)SearchGuardVersion.header()).handlesPut("/_signals/proxies/{id}").with((Action)CreateOrReplaceProxyAction.INSTANCE, (params, body) -> new CreateOrReplaceProxyAction.CreateOrReplaceProxyRequest((String)params.get("id"), body)).handlesDelete("/_signals/proxies/{id}").with((Action)DeleteProxyAction.INSTANCE, (params, body) -> new StandardRequests.IdRequest((String)params.get("id"))).handlesGet("/_signals/proxies").with((Action)FindAllProxiesAction.INSTANCE).handlesGet("/_signals/proxies/{id}").with((Action)FindOneProxyAction.INSTANCE, (params, body) -> new StandardRequests.IdRequest((String)params.get("id"))).name("/_signals/proxies/");

    public static class CreateOrReplaceProxyAction
    extends Action<CreateOrReplaceProxyRequest, StandardResponse> {
        private static final Logger log = LogManager.getLogger(CreateOrReplaceProxyAction.class);
        public static final String NAME = "cluster:admin:searchguard:signals:proxies/createorreplace";
        public static final CreateOrReplaceProxyAction INSTANCE = new CreateOrReplaceProxyAction();

        public CreateOrReplaceProxyAction() {
            super(NAME, CreateOrReplaceProxyRequest::new, StandardResponse::new);
        }

        public static class CreateOrReplaceProxyRequest
        extends Action.Request {
            public static final String FIELD_ID = "id";
            public static final String FIELD_NAME = "name";
            public static final String FIELD_URI = "uri";
            private final String id;
            private final String name;
            private final String uri;

            public CreateOrReplaceProxyRequest(Action.UnparsedMessage message) throws ConfigValidationException {
                DocNode docNode = message.requiredDocNode();
                this.id = docNode.getAsString(FIELD_ID);
                this.name = docNode.getAsString(FIELD_NAME);
                this.uri = docNode.getAsString(FIELD_URI);
            }

            public CreateOrReplaceProxyRequest(String id, UnparsedDocument<?> message) throws DocumentParseException {
                DocNode docNode = message.parseAsDocNode();
                this.id = id;
                this.name = docNode.getAsString(FIELD_NAME);
                this.uri = docNode.getAsString(FIELD_URI);
            }

            public Object toBasicObject() {
                return ImmutableMap.of((Object)FIELD_ID, (Object)this.id, (Object)FIELD_NAME, (Object)this.name, (Object)FIELD_URI, (Object)this.uri);
            }

            public String getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public String getUri() {
                return this.uri;
            }
        }

        public static class CreateOrUpdateProxyHandler
        extends Action.Handler<CreateOrReplaceProxyRequest, StandardResponse> {
            private final ProxyCrudService proxyCrudService;
            private final NodeClient client;

            @Inject
            public CreateOrUpdateProxyHandler(Action.HandlerDependencies handlerDependencies, NodeClient client, Signals signals) {
                super((Action)INSTANCE, handlerDependencies);
                PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
                ProxyRepository proxyRepository = new ProxyRepository(signals.getSignalsSettings(), privilegedConfigClient);
                this.client = client;
                this.proxyCrudService = new ProxyCrudService(proxyRepository);
            }

            protected CompletableFuture<StandardResponse> doExecute(CreateOrReplaceProxyRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        StandardResponse response = this.proxyCrudService.createOrReplace(request);
                        log.debug("Proxy with id '{}' stored in index.", (Object)request.getId());
                        TransportProxyUpdatedAction.ProxyUpdatedActionType.send((Client)this.client, request.getId(), "create-or-update").actionGet();
                        log.debug("Notification related to proxy '{}' update send.", (Object)request.getId());
                        return response;
                    }
                    catch (ConfigValidationException e) {
                        log.debug("Cannot create or replace proxy", (Throwable)e);
                        return new StandardResponse(400).error(e);
                    }
                    catch (Exception e) {
                        log.error("Cannot create or replace proxy", (Throwable)e);
                        return new StandardResponse(500).error("Cannot create or replace proxy. " + e.getMessage());
                    }
                });
            }
        }
    }

    public static class DeleteProxyAction
    extends Action<StandardRequests.IdRequest, StandardResponse> {
        private static final Logger log = LogManager.getLogger(DeleteProxyAction.class);
        public static final String NAME = "cluster:admin:searchguard:signals:proxies/delete";
        public static final DeleteProxyAction INSTANCE = new DeleteProxyAction();

        private DeleteProxyAction() {
            super(NAME, StandardRequests.IdRequest::new, StandardResponse::new);
        }

        public static class DeleteProxyHandler
        extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
            private final ProxyCrudService proxyCrudService;
            private final NodeClient client;

            @Inject
            public DeleteProxyHandler(Action.HandlerDependencies handlerDependencies, NodeClient client, Signals signals) {
                super((Action)INSTANCE, handlerDependencies);
                PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
                ProxyRepository proxyRepository = new ProxyRepository(signals.getSignalsSettings(), privilegedConfigClient);
                this.proxyCrudService = new ProxyCrudService(proxyRepository);
                this.client = client;
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        StandardResponse response = this.proxyCrudService.delete(request.getId());
                        log.debug("Proxy '{}' deleted", (Object)request.getId());
                        TransportProxyUpdatedAction.ProxyUpdatedActionType.send((Client)this.client, request.getId(), "delete").actionGet();
                        log.debug("Notification related to proxy '{}' deletion send.", (Object)request.getId());
                        return response;
                    }
                    catch (Exception e) {
                        log.warn("Cannot delete proxy '{}' data", (Object)request.getId(), (Object)e);
                        return new StandardResponse(500).error("Cannot delete proxy data. " + e.getMessage());
                    }
                });
            }
        }
    }

    public static class FindAllProxiesAction
    extends Action<StandardRequests.EmptyRequest, StandardResponse> {
        private static final Logger log = LogManager.getLogger(FindAllProxiesAction.class);
        public static final String NAME = "cluster:admin:searchguard:signals:proxies/findall";
        public static final FindAllProxiesAction INSTANCE = new FindAllProxiesAction();

        private FindAllProxiesAction() {
            super(NAME, StandardRequests.EmptyRequest::new, StandardResponse::new);
        }

        public static class FindAllProxiesHandler
        extends Action.Handler<StandardRequests.EmptyRequest, StandardResponse> {
            private final ProxyCrudService proxyCrudService;

            @Inject
            public FindAllProxiesHandler(Action.HandlerDependencies handlerDependencies, NodeClient client, Signals signals) {
                super((Action)INSTANCE, handlerDependencies);
                PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
                ProxyRepository proxyRepository = new ProxyRepository(signals.getSignalsSettings(), privilegedConfigClient);
                this.proxyCrudService = new ProxyCrudService(proxyRepository);
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.EmptyRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        return this.proxyCrudService.findAll();
                    }
                    catch (Exception e) {
                        log.warn("Cannot load proxies data", (Throwable)e);
                        return new StandardResponse(500).error("Cannot load proxies data. " + e.getMessage());
                    }
                });
            }
        }
    }

    public static class FindOneProxyAction
    extends Action<StandardRequests.IdRequest, StandardResponse> {
        private static final Logger log = LogManager.getLogger(FindOneProxyAction.class);
        public static final String NAME = "cluster:admin:searchguard:signals:proxies/findone";
        public static final FindOneProxyAction INSTANCE = new FindOneProxyAction();

        private FindOneProxyAction() {
            super(NAME, StandardRequests.IdRequest::new, StandardResponse::new);
        }

        public static class FindOneProxyHandler
        extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
            private final ProxyCrudService proxyCrudService;

            @Inject
            public FindOneProxyHandler(Action.HandlerDependencies handlerDependencies, NodeClient client, Signals signals) {
                super((Action)INSTANCE, handlerDependencies);
                PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
                ProxyRepository proxyRepository = new ProxyRepository(signals.getSignalsSettings(), privilegedConfigClient);
                this.proxyCrudService = new ProxyCrudService(proxyRepository);
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        return this.proxyCrudService.findOne(request.getId());
                    }
                    catch (NoSuchProxyException e) {
                        log.debug("Proxy '{}' not found", (Object)request.getId(), (Object)e);
                        return new StandardResponse(404).error(e.getMessage());
                    }
                    catch (Exception e) {
                        log.warn("Cannot load proxy '{}' data", (Object)request.getId(), (Object)e);
                        return new StandardResponse(500).error("Cannot load proxy data. " + e.getMessage());
                    }
                });
            }
        }
    }
}

