/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.WatchBuilder;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.common.throttle.ThrottlePeriodParser;
import com.floragunn.signals.watch.common.throttle.ValidatingThrottlePeriodParser;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.util.concurrent.ExecutionException;
import net.jcip.annotations.NotThreadSafe;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

@NotThreadSafe
public class SignalsIntegrationTestTenantActiveByDefaultFalse {
    private static final Logger log = LogManager.getLogger(SignalsIntegrationTestTenantActiveByDefaultFalse.class);
    private static ScriptService scriptService;
    private static ThrottlePeriodParser throttlePeriodParser;
    private static TrustManagerRegistry trustManagerRegistry;
    private static HttpProxyHostRegistry httpProxyHostRegistry;
    @ClassRule
    public static LocalCluster.Embedded cluster;

    @BeforeClass
    public static void setupTestData() {
        Client client = cluster.getInternalNodeClient();
        client.index(new IndexRequest("testsource").source(XContentType.JSON, new Object[]{"key1", "val1", "key2", "val2"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "x", "b", "y"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy"})).actionGet();
    }

    @BeforeClass
    public static void setupDependencies() {
        scriptService = (ScriptService)cluster.getInjectable(ScriptService.class);
        throttlePeriodParser = new ValidatingThrottlePeriodParser(((Signals)cluster.getInjectable(Signals.class)).getSignalsSettings());
        trustManagerRegistry = ((Signals)cluster.getInjectable(Signals.class)).getTruststoreRegistry();
        httpProxyHostRegistry = ((Signals)cluster.getInjectable(Signals.class)).getHttpProxyHostRegistry();
    }

    @Test
    public void testPutWatch() throws Exception {
        String tenant = "_main";
        String watchId = "put_test";
        String watchPath = "/_signals/watch/" + tenant + "/" + watchId;
        try (GenericRestClient restClient = cluster.getRestClient("uhura", "uhura", new Header[0]).trackResources();){
            Client client = cluster.getInternalNodeClient();
            client.admin().indices().create(new CreateIndexRequest("testsink_put_watch")).actionGet();
            Watch watch = new WatchBuilder(watchId).atMsInterval(100L).search("testsource").query("{\"match_all\" : {} }").as("testsearch").put("{\"bla\": {\"blub\": 42}}").as("teststatic").then().index("testsink_put_watch").name("testsink").build();
            GenericRestClient.HttpResponse response = restClient.putJson(watchPath, watch.toJson(), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = restClient.get(watchPath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            WatchInitializationService initService = new WatchInitializationService(null, scriptService, trustManagerRegistry, httpProxyHostRegistry, throttlePeriodParser, ValidationLevel.STRICT);
            watch = Watch.parseFromElasticDocument((WatchInitializationService)initService, (String)"test", (String)"put_test", (String)response.getBody(), (long)-1L);
            Thread.sleep(2000L);
            Assert.assertEquals((long)0L, (long)this.getCountOfDocuments(client, "testsink_put_watch"));
            response = restClient.putJson("/_signals/tenant/" + tenant + "/_active", "", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            this.awaitMinCountOfDocuments(client, "testsink_put_watch", 1L);
            response = restClient.delete("/_signals/tenant/" + tenant + "/_active", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Thread.sleep(500L);
            long countNow = this.getCountOfDocuments(client, "testsink_put_watch");
            Thread.sleep(1000L);
            Assert.assertEquals((long)countNow, (long)this.getCountOfDocuments(client, "testsink_put_watch"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCountOfDocuments(Client client, String index) throws InterruptedException, ExecutionException {
        SearchRequest request = new SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        request.source(searchSourceBuilder);
        SearchResponse response = (SearchResponse)client.search(request).get();
        try {
            long l = response.getHits().getTotalHits().value();
            return l;
        }
        finally {
            response.decRef();
        }
    }

    private long awaitMinCountOfDocuments(Client client, String index, long minCount) throws Exception {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            Thread.sleep(10L);
            long count = this.getCountOfDocuments(client, index);
            if (count < minCount) continue;
            log.info("Found " + count + " documents in " + index + " after " + (System.currentTimeMillis() - start) + " ms");
            return count;
        }
        Assert.fail((String)("Did not find " + minCount + " documents in " + index + " after " + (System.currentTimeMillis() - start) + " ms"));
        return 0L;
    }

    static {
        cluster = new LocalCluster.Builder().sslEnabled().resources("sg_config/signals").nodeSettings(new Object[]{"signals.enabled", true, "signals.index_names.log", "signals_main_log", "signals.enterprise.enabled", false, "signals.all_tenants_active_by_default", false}).enableModule(SignalsModule.class).waitForComponents(new String[]{"signals"}).embedded().build();
    }
}

