/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificatesParser {
    private static final Logger log = LogManager.getLogger(CertificatesParser.class);

    public static Collection<? extends Certificate> parseCertificates(String pem) throws ConfigValidationException {
        CertificateFactory fact;
        if (pem == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.US_ASCII));
        try {
            fact = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            log.error("Could not initialize X.509", (Throwable)e);
            throw new ConfigValidationException(new ValidationError(null, "Could not initialize X.509").cause((Throwable)e));
        }
        try {
            return fact.generateCertificates(inputStream);
        }
        catch (CertificateException e) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)pem, (Object)"PEM File").message("Invalid PEM certificate. " + e.getMessage()).cause((Throwable)e));
        }
    }

    public static KeyStore toTruststore(String trustCertificatesAliasPrefix, Collection<? extends Certificate> certificates) throws ConfigValidationException {
        KeyStore keyStore;
        if (certificates == null) {
            return null;
        }
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
        }
        catch (Exception e) {
            log.error("Could not initialize JKS KeyStore", (Throwable)e);
            throw new RuntimeException("Could not create JKS KeyStore", e);
        }
        int i = 0;
        for (Certificate certificate : certificates) {
            try {
                keyStore.setCertificateEntry(trustCertificatesAliasPrefix + "_" + i, certificate);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Cannot add certificates to JKS keystore", e);
            }
            ++i;
        }
        return keyStore;
    }
}

