/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.signals.Signals;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;

public class SignalsUnavailableException
extends Exception {
    private static final long serialVersionUID = 4191418376980084744L;
    private final String nodeId;
    private final Signals.InitializationState state;

    public SignalsUnavailableException(String message, String nodeId, Signals.InitializationState state, Throwable cause) {
        super(message, cause);
        this.nodeId = nodeId;
        this.state = state;
    }

    public SignalsUnavailableException(String message, String nodeId, Signals.InitializationState state) {
        super(message);
        this.nodeId = nodeId;
        this.state = state;
    }

    public SignalsUnavailableException(Throwable cause, String nodeId, Signals.InitializationState state) {
        super(cause);
        this.nodeId = nodeId;
        this.state = state;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Signals.InitializationState getState() {
        return this.state;
    }

    public RestStatus getRestStatus() {
        return this.state == Signals.InitializationState.INITIALIZING ? RestStatus.SERVICE_UNAVAILABLE : RestStatus.INTERNAL_SERVER_ERROR;
    }

    public ElasticsearchException toElasticsearchException() {
        return new ElasticsearchStatusException(this.getLongMessage(), this.getRestStatus(), (Throwable)this, new Object[0]);
    }

    private String getLongMessage() {
        if (this.getCause() != null && this.getCause().getMessage() != null) {
            return this.getMessage() + "\n" + this.getCause().getMessage();
        }
        return this.getMessage();
    }
}

