/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.proxy.wiremock.WireMockRequestHeaderAddingFilter;
import com.floragunn.signals.MockWebserviceProvider;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.accounts.AccountRegistry;
import com.floragunn.signals.execution.CheckExecutionException;
import com.floragunn.signals.execution.ExecutionEnvironment;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.WatchBuilder;
import com.floragunn.signals.watch.action.invokers.ActionInvocationType;
import com.floragunn.signals.watch.checks.Calc;
import com.floragunn.signals.watch.checks.Condition;
import com.floragunn.signals.watch.checks.HttpInput;
import com.floragunn.signals.watch.checks.SearchInput;
import com.floragunn.signals.watch.common.HttpClientConfig;
import com.floragunn.signals.watch.common.HttpProxyConfig;
import com.floragunn.signals.watch.common.HttpRequestConfig;
import com.floragunn.signals.watch.common.TlsConfig;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.common.throttle.ThrottlePeriodParser;
import com.floragunn.signals.watch.common.throttle.ValidatingThrottlePeriodParser;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.result.Status;
import com.floragunn.signals.watch.result.WatchLog;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import java.net.Socket;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.X509ExtendedTrustManager;
import net.jcip.annotations.NotThreadSafe;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@NotThreadSafe
@RunWith(value=MockitoJUnitRunner.class)
public class CheckTest {
    private static final Logger log = LogManager.getLogger(CheckTest.class);
    public static final String TRUSTSTORE_ID = "my-truststore-id-001";
    private static NamedXContentRegistry xContentRegistry;
    private static ScriptService scriptService;
    private static ClusterService clusterService;
    private static FeatureService featureService;
    private static ThrottlePeriodParser throttlePeriodParser;
    private static TestCertificates testCertificates;
    private static final WireMockRequestHeaderAddingFilter REQUEST_HEADER_ADDING_FILTER;
    @ClassRule
    public static WireMockClassRule wireMockProxy;
    @ClassRule
    public static LocalCluster.Embedded anotherCluster;
    @ClassRule
    public static LocalCluster.Embedded cluster;
    @Mock
    private AccountRegistry accountRegistry;
    @Mock
    private TrustManagerRegistry trustManagerRegistry;
    @Mock
    private HttpProxyHostRegistry httpProxyHostRegistry;
    @Mock
    private X509ExtendedTrustManager trustManager;
    private final WatchInitializationService watchInitializationService;

    public CheckTest() {
        this.watchInitializationService = new WatchInitializationService(this.accountRegistry, scriptService, this.trustManagerRegistry, this.httpProxyHostRegistry, throttlePeriodParser, ValidationLevel.STRICT);
    }

    @BeforeClass
    public static void setupTestData() {
        Client client = cluster.getInternalNodeClient();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "x", "b", "y", "date", "1985/01/01"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy", "date", CheckTest.getYesterday()})).actionGet();
        Client anotherClient = anotherCluster.getInternalNodeClient();
        anotherClient.index(((IndexRequest)new IndexRequest("ccs_testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "x", "b", "y", "date", "1985/01/01"})).actionGet();
        anotherClient.index(((IndexRequest)new IndexRequest("ccs_testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy", "date", CheckTest.getYesterday()})).actionGet();
    }

    @BeforeClass
    public static void setupDependencies() throws Exception {
        xContentRegistry = (NamedXContentRegistry)cluster.getInjectable(NamedXContentRegistry.class);
        scriptService = (ScriptService)cluster.getInjectable(ScriptService.class);
        throttlePeriodParser = new ValidatingThrottlePeriodParser(((Signals)cluster.getInjectable(Signals.class)).getSignalsSettings());
        clusterService = (ClusterService)cluster.getInjectable(ClusterService.class);
        featureService = (FeatureService)cluster.getInjectable(FeatureService.class);
    }

    @Before
    public void resetMock() {
        Mockito.reset((Object[])new Object[]{this.accountRegistry, this.trustManagerRegistry, this.trustManager, this.httpProxyHostRegistry});
    }

    @Test
    public void searchTest() throws Exception {
        SearchInput searchInput = new SearchInput("test", "test", "testsource", "{\"query\": {\"term\" : {\"a\": \"x\"} }}");
        searchInput.compileScripts(this.watchInitializationService);
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put(new NestedValueMap.Path(new String[]{"x", "hits", "total"}), (Object)7);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        boolean result = searchInput.execute(ctx);
        Assert.assertTrue((boolean)result);
        List searchResult = (List)runtimeData.get(new NestedValueMap.Path(new String[]{"test", "hits", "hits"}));
        Assert.assertEquals((long)1L, (long)searchResult.size());
        Assert.assertEquals((Object)"x", ((Map)((Map)searchResult.get(0)).get("_source")).get("a"));
    }

    @Test
    public void searchWithTemplateTest() throws Exception {
        SearchInput searchInput = new SearchInput("test", "test", "testsource", "{\"query\": {\"term\" : {\"a\": \"{{data.match}}\"} }}");
        searchInput.compileScripts(this.watchInitializationService);
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put(new NestedValueMap.Path(new String[]{"match"}), (Object)"xx");
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        boolean result = searchInput.execute(ctx);
        Assert.assertTrue((boolean)result);
        List searchResult = (List)runtimeData.get(new NestedValueMap.Path(new String[]{"test", "hits", "hits"}));
        Assert.assertEquals((long)1L, (long)searchResult.size());
        Assert.assertEquals((Object)"yy", ((Map)((Map)searchResult.get(0)).get("_source")).get("b"));
    }

    @Test
    @Ignore(value="TODO why is this ignored?")
    public void searchWithScheduleDateTest() throws Exception {
        SearchInput searchInput = new SearchInput("test", "test", "testsource", "{\"query\": {\"range\" : {\"date\": {\"gte\": \"{{trigger.scheduled_time}}||-1M\", \"lt\": \"{{trigger.scheduled_time}}\", \"format\": \"strict_date_time\"} } }}");
        searchInput.compileScripts(this.watchInitializationService);
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put(new NestedValueMap.Path(new String[]{"match"}), (Object)"xx");
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        boolean result = searchInput.execute(ctx);
        Assert.assertTrue((boolean)result);
        List searchResult = (List)runtimeData.get(new NestedValueMap.Path(new String[]{"test", "hits", "hits"}));
        Assert.assertEquals((long)1L, (long)searchResult.size());
        Assert.assertEquals((Object)"yy", ((Map)((Map)searchResult.get(0)).get("_source")).get("b"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void searchWithTemplateMappingTest() throws Exception {
        String tenant = "_main";
        String watchId1 = "search_with_template_mapping_1";
        String watchPath1 = "/_signals/watch/" + tenant + "/" + watchId1;
        String watchId2 = "search_with_template_mapping_2";
        String watchPath2 = "/_signals/watch/" + tenant + "/" + watchId2;
        try (GenericRestClient restClient = cluster.getRestClient("uhura", "uhura", new Header[0]);){
            try {
                Watch watch = new WatchBuilder("put_test").cronTrigger("* * * * * ?").search("testsource").query("{\"match_all\" : {} }").size(1).as("testsearch").then().index("testsink_" + watchId1).name("testsink").build();
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath1, (ToXContentObject)watch);
                Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
                response = restClient.get(watchPath1, new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                watch = new WatchBuilder("put_test").cronTrigger("* * * * * ?").put("{\"size\": 1}").as("constants").search("testsource").query("{\"match_all\" : {} }").attr("size", "{{data.constants.size}}").as("testsearch").then().index("testsink_" + watchId2).name("testsink").build();
                response = restClient.putJson(watchPath2, (ToXContentObject)watch);
                Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
                response = restClient.get(watchPath2, new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            }
            finally {
                restClient.delete(watchPath1, new Header[0]);
                restClient.delete(watchPath2, new Header[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void searchScheduledTest() throws Exception {
        String tenant = "_main";
        String watchId = "search_scheduled_test";
        String watchPath = "/_signals/watch/" + tenant + "/" + watchId;
        try (GenericRestClient restClient = cluster.getRestClient("uhura", "uhura", new Header[0]);){
            try {
                Client client = cluster.getInternalNodeClient();
                Watch watch = new WatchBuilder(watchId).atMsInterval(300L).unthrottled().search("my_remote:ccs_testsource").query("{\"match_all\" : {} }").as("testsearch").build();
                GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
                Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
                response = restClient.get(watchPath, new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                watch = Watch.parseFromElasticDocument((WatchInitializationService)this.watchInitializationService, (String)"test", (String)"put_test", (String)response.getBody(), (long)-1L);
                WatchLog watchLog = this.awaitWatchLog(client, tenant, watchId);
                Assert.assertEquals((String)watchLog.toString(), (Object)Status.Code.NO_ACTION, (Object)watchLog.getStatus().getCode());
            }
            finally {
                restClient.delete(watchPath, new Header[0]);
            }
        }
    }

    @Test
    public void httpInputTest() throws Exception {
        try (MockWebserviceProvider webserviceProvider = new MockWebserviceProvider("/service");){
            webserviceProvider.setResponseBody("{\"foo\": \"bar\", \"x\": 55}");
            webserviceProvider.setResponseContentType("text/json");
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webserviceProvider.getUri()), null, null, null, null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            HttpInput httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(null, null, null, null));
            NestedValueMap runtimeData = new NestedValueMap();
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            boolean result = httpInput.execute(ctx);
            Assert.assertTrue((boolean)result);
            Map inputResult = (Map)runtimeData.get((Object)"test");
            Assert.assertEquals((Object)"bar", inputResult.get("foo"));
            Assert.assertEquals((Object)55, inputResult.get("x"));
        }
    }

    @Test
    public void httpInputShouldSupportTrustStoreTest() throws Exception {
        try (MockWebserviceProvider webserviceProvider = new MockWebserviceProvider("/tls_service", true, false);){
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager));
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webserviceProvider.getUri()), null, null, null, null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(TRUSTSTORE_ID);
            tlsConfig.init();
            HttpInput httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(null, null, tlsConfig, null));
            NestedValueMap runtimeData = new NestedValueMap();
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            boolean result = httpInput.execute(ctx);
            Assert.assertTrue((boolean)result);
            ((X509ExtendedTrustManager)Mockito.verify((Object)this.trustManager)).checkServerTrusted((X509Certificate[])ArgumentMatchers.any(X509Certificate[].class), ArgumentMatchers.anyString(), (Socket)ArgumentMatchers.any(Socket.class));
        }
    }

    @Test
    public void httpInputTestContentTypeHasCharset() throws Exception {
        try (MockWebserviceProvider webserviceProvider = new MockWebserviceProvider("/service");){
            webserviceProvider.setResponseBody("{\"foo\": \"bar\", \"x\": 55}");
            webserviceProvider.setResponseContentType("text/json; charset=utf-8");
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webserviceProvider.getUri()), null, null, null, null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            HttpInput httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(null, null, null, null));
            NestedValueMap runtimeData = new NestedValueMap();
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            boolean result = httpInput.execute(ctx);
            Assert.assertTrue((boolean)result);
            Map inputResult = (Map)runtimeData.get((Object)"test");
            Assert.assertEquals((Object)"bar", inputResult.get("foo"));
            Assert.assertEquals((Object)55, inputResult.get("x"));
        }
    }

    @Test
    public void httpInputTextTest() throws Exception {
        try (MockWebserviceProvider webserviceProvider = new MockWebserviceProvider("/service");){
            String text = "{\"foo\": \"bar\", \"x\": 55}";
            webserviceProvider.setResponseBody(text);
            webserviceProvider.setResponseContentType("text/plain");
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webserviceProvider.getUri()), null, null, null, null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            HttpInput httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(null, null, null, null));
            NestedValueMap runtimeData = new NestedValueMap();
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            boolean result = httpInput.execute(ctx);
            Assert.assertTrue((boolean)result);
            Assert.assertEquals((Object)text, (Object)runtimeData.get((Object)"test"));
        }
    }

    @Test
    public void httpInputProxyTest() throws Exception {
        try (MockWebserviceProvider webserviceProvider = new MockWebserviceProvider("/service");){
            webserviceProvider.setResponseBody("{\"foo\": \"bar\", \"x\": 55}");
            webserviceProvider.setResponseContentType("text/json");
            webserviceProvider.acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader());
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webserviceProvider.getUri()), null, null, null, null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            HttpInput httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(null, null, null, null));
            NestedValueMap runtimeData = new NestedValueMap();
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            try {
                httpInput.execute(ctx);
                Assert.fail();
            }
            catch (CheckExecutionException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains(String.format("We are only accepting requests with the '%s' header set to '%s'", REQUEST_HEADER_ADDING_FILTER.getHeader().getName(), REQUEST_HEADER_ADDING_FILTER.getHeader().getValue())));
            }
            HttpProxyConfig httpProxyConfig = HttpProxyConfig.create((ValidatingDocNode)new ValidatingDocNode(DocNode.of((String)"proxy", (Object)("http://127.0.0.8:" + wireMockProxy.port())), new ValidationErrors()), (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
            httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(null, null, null, httpProxyConfig));
            boolean result = httpInput.execute(ctx);
            Assert.assertTrue((boolean)result);
            Map inputResult = (Map)runtimeData.get((Object)"test");
            Assert.assertEquals((Object)"bar", inputResult.get("foo"));
            Assert.assertEquals((Object)55, inputResult.get("x"));
        }
    }

    @Test
    public void httpInput_proxyConfigLoadedFromConfigurationTest() throws Exception {
        try (MockWebserviceProvider webserviceProvider = new MockWebserviceProvider("/service");){
            String uploadedProxyId = "my-proxy-1";
            webserviceProvider.setResponseBody("{\"foo\": \"bar\", \"x\": 55}");
            webserviceProvider.setResponseContentType("text/json");
            webserviceProvider.acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader());
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webserviceProvider.getUri()), null, null, null, null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            HttpInput httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(null, null, null, null));
            NestedValueMap runtimeData = new NestedValueMap();
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            try {
                httpInput.execute(ctx);
                Assert.fail();
            }
            catch (CheckExecutionException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains(String.format("We are only accepting requests with the '%s' header set to '%s'", REQUEST_HEADER_ADDING_FILTER.getHeader().getName(), REQUEST_HEADER_ADDING_FILTER.getHeader().getValue())));
            }
            Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(uploadedProxyId)).thenReturn(Optional.of(HttpHost.create((String)("http://127.0.0.8:" + wireMockProxy.port()))));
            HttpProxyConfig httpProxyConfig = HttpProxyConfig.create((ValidatingDocNode)new ValidatingDocNode(DocNode.of((String)"proxy", (Object)uploadedProxyId), new ValidationErrors()), (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
            httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(null, null, null, httpProxyConfig));
            boolean result = httpInput.execute(ctx);
            Assert.assertTrue((boolean)result);
            Map inputResult = (Map)runtimeData.get((Object)"test");
            Assert.assertEquals((Object)"bar", inputResult.get("foo"));
            Assert.assertEquals((Object)55, inputResult.get("x"));
        }
    }

    @Test(expected=CheckExecutionException.class)
    public void httpWrongContentTypeTest() throws Exception {
        try (MockWebserviceProvider webserviceProvider = new MockWebserviceProvider("/service");){
            String text = "{\"foo\": \"bar\", \"x\": 55}";
            webserviceProvider.setResponseBody(text);
            webserviceProvider.setResponseContentType("application/vnd.floragunnmegapearls");
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webserviceProvider.getUri()), null, null, null, null, null, null, "application/x-yaml");
            httpRequestConfig.compileScripts(this.watchInitializationService);
            HttpInput httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(null, null, null, null));
            NestedValueMap runtimeData = new NestedValueMap();
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            httpInput.execute(ctx);
            Assert.fail();
        }
    }

    @Test
    public void httpInputTimeoutTest() throws Exception {
        try (MockWebserviceProvider webserviceProvider = new MockWebserviceProvider("/service");){
            webserviceProvider.setResponseBody("{\"foo\": \"bar\", \"x\": 55}");
            webserviceProvider.setResponseContentType("text/json");
            webserviceProvider.setResponseDelayMs(3330L);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webserviceProvider.getUri()), null, null, null, null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            HttpInput httpInput = new HttpInput("test", "test", httpRequestConfig, new HttpClientConfig(Integer.valueOf(1), Integer.valueOf(1), null, null));
            NestedValueMap runtimeData = new NestedValueMap();
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            httpInput.execute(ctx);
            Assert.fail();
        }
        catch (CheckExecutionException e) {
            Assert.assertTrue((String)e.toString(), (boolean)e.getCause().toString().contains("Read timed out"));
        }
    }

    @Test
    public void testConditionTrue() throws Exception {
        Condition scriptCondition = new Condition(null, "data.x.hits.total > 5", "painless", Collections.emptyMap());
        scriptCondition.compileScripts(this.watchInitializationService);
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put(new NestedValueMap.Path(new String[]{"x", "hits", "total"}), (Object)7);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        boolean result = scriptCondition.execute(ctx);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testConditionFalse() throws Exception {
        Condition scriptCondition = new Condition(null, "data.x.hits.total > 510", "painless", Collections.emptyMap());
        scriptCondition.compileScripts(this.watchInitializationService);
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put(new NestedValueMap.Path(new String[]{"x", "hits", "total"}), (Object)7);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        boolean result = scriptCondition.execute(ctx);
        Assert.assertFalse((boolean)result);
    }

    @Test(expected=CheckExecutionException.class)
    public void testInvalidCondition() throws Exception {
        Condition scriptCondition = new Condition(null, "data.x.hits.hits.length > data.constants.threshold", "painless", Collections.emptyMap());
        scriptCondition.compileScripts(this.watchInitializationService);
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put(new NestedValueMap.Path(new String[]{"x", "hits", "total"}), (Object)7);
        runtimeData.put(new NestedValueMap.Path(new String[]{"constants", "threshold"}), (Object)5);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        scriptCondition.execute(ctx);
        Assert.fail();
    }

    @Test
    public void testCalc() throws Exception {
        Calc calc = new Calc(null, "data.x.y = 5", "painless", Collections.emptyMap());
        calc.compileScripts(this.watchInitializationService);
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put(new NestedValueMap.Path(new String[]{"x", "hits", "total"}), (Object)7);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        boolean result = calc.execute(ctx);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)5, (Object)runtimeData.get(new NestedValueMap.Path(new String[]{"x", "y"})));
    }

    private static String getYesterday() {
        LocalDate now = LocalDate.now().minus(1L, ChronoUnit.DAYS);
        return now.format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WatchLog awaitWatchLog(Client client, String tenantName, String watchName) throws Exception {
        try {
            long start = System.currentTimeMillis();
            Throwable indexNotFoundException = null;
            for (int i = 0; i < 1000; ++i) {
                Thread.sleep(10L);
                try {
                    WatchLog watchLog = this.getMostRecentWatchLog(client, tenantName, watchName);
                    if (watchLog != null) {
                        log.info("Found " + String.valueOf(watchLog) + " for " + watchName + " after " + (System.currentTimeMillis() - start) + " ms");
                        return watchLog;
                    }
                    indexNotFoundException = null;
                    continue;
                }
                catch (SearchPhaseExecutionException | IndexNotFoundException e) {
                    indexNotFoundException = e;
                }
            }
            if (indexNotFoundException != null) {
                Assert.fail((String)("Did not find watch log index for " + watchName + " after " + (System.currentTimeMillis() - start) + " ms: " + String.valueOf(indexNotFoundException)));
            } else {
                SearchResponse searchResponse = (SearchResponse)client.search(new SearchRequest(new String[]{".signals_log_*"}).source(new SearchSourceBuilder().sort("execution_end", SortOrder.DESC).query((QueryBuilder)new MatchAllQueryBuilder()))).actionGet();
                try {
                    log.info("Did not find watch log for " + watchName + " after " + (System.currentTimeMillis() - start) + " ms\n\n" + String.valueOf(searchResponse.getHits()));
                }
                finally {
                    searchResponse.decRef();
                }
                Assert.fail((String)("Did not find watch log for " + watchName + " after " + (System.currentTimeMillis() - start) + " ms"));
            }
            return null;
        }
        catch (Exception e) {
            log.error("Exception in awaitWatchLog for " + watchName + ")", (Throwable)e);
            throw new RuntimeException("Exception in awaitWatchLog for " + watchName + ")", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WatchLog getMostRecentWatchLog(Client client, String tenantName, String watchName) {
        try {
            SearchResponse searchResponse = (SearchResponse)client.search(new SearchRequest(new String[]{".signals_log_*"}).source(new SearchSourceBuilder().size(1).sort("execution_end", SortOrder.DESC).query((QueryBuilder)new MatchQueryBuilder("watch_id", (Object)watchName)))).actionGet();
            try {
                if (searchResponse.getHits().getHits().length == 0) {
                    WatchLog watchLog = null;
                    return watchLog;
                }
                SearchHit searchHit = searchResponse.getHits().getHits()[0];
                WatchLog watchLog = WatchLog.parse((String)searchHit.getId(), (String)searchHit.getSourceAsString());
                return watchLog;
            }
            finally {
                searchResponse.decRef();
            }
        }
        catch (SearchPhaseExecutionException | IndexNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in getMostRecenWatchLog(" + tenantName + ", " + watchName + ")", e);
        }
    }

    private WatchExecutionContext buildWatchExecutionContext(NestedValueMap runtimeData) {
        return new WatchExecutionContext(cluster.getInternalNodeClient(), scriptService, xContentRegistry, this.accountRegistry, ExecutionEnvironment.SCHEDULED, ActionInvocationType.ALERT, new WatchExecutionContextData(runtimeData), this.trustManagerRegistry, clusterService, featureService);
    }

    static {
        testCertificates = TestCertificates.builder().ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard").addNodes(new String[]{"CN=node-0.example.com,OU=SearchGuard,O=SearchGuard"}).addClients(new String[]{"CN=client-0.example.com,OU=SearchGuard,O=SearchGuard"}).addAdminClients(new String[]{"CN=admin-0.example.com,OU=SearchGuard,O=SearchGuard"}).build();
        REQUEST_HEADER_ADDING_FILTER = new WireMockRequestHeaderAddingFilter("Proxy", "wire-mock");
        wireMockProxy = new WireMockClassRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.8").enableBrowserProxying(true).proxyPassThrough(true).dynamicPort().extensions(new Extension[]{REQUEST_HEADER_ADDING_FILTER}));
        anotherCluster = new LocalCluster.Builder().singleNode().sslEnabled(testCertificates).resources("sg_config/signals").nodeSettings(new Object[]{"signals.enabled", false, "searchguard.enterprise_modules_enabled", false}).enableModule(SignalsModule.class).embedded().build();
        cluster = new LocalCluster.Builder().singleNode().sslEnabled(testCertificates).resources("sg_config/signals").nodeSettings(new Object[]{"signals.enabled", true, "searchguard.enterprise_modules_enabled", false}).remote("my_remote", (LocalCluster)anotherCluster).enableModule(SignalsModule.class).waitForComponents(new String[]{"signals"}).embedded().build();
    }
}

