/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.execution.ExecutionEnvironment;
import com.floragunn.signals.execution.SimulationMode;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.script.types.SignalsObjectFunctionScript;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.action.invokers.ActionInvocationType;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

@NotThreadSafe
public class ScriptingTest {
    private static NamedXContentRegistry xContentRegistry;
    private static ScriptService scriptService;
    private static WatchInitializationService watchInitService;
    private static SignalsModule signalsModule;
    @ClassRule
    public static LocalCluster.Embedded cluster;

    @BeforeClass
    public static void setupDependencies() {
        xContentRegistry = (NamedXContentRegistry)cluster.getInjectable(NamedXContentRegistry.class);
        scriptService = (ScriptService)cluster.getInjectable(ScriptService.class);
        watchInitService = new WatchInitializationService(null, scriptService, (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class), (HttpProxyHostRegistry)Mockito.mock(HttpProxyHostRegistry.class), null, ValidationLevel.STRICT);
        signalsModule = (SignalsModule)cluster.getInjectable(SignalsModule.class);
    }

    @Test
    public void signalsScriptContextsShouldHaveUnlimitedCompilationRate() {
        List signalsScriptContexts = signalsModule.getContexts();
        int noOfScriptCompilationsPerContext = 1000;
        long minExpectedNoOfCompilations = (long)signalsScriptContexts.size() * (long)noOfScriptCompilationsPerContext;
        for (ScriptContext scriptContext : signalsScriptContexts) {
            for (int i = 0; i < noOfScriptCompilationsPerContext; ++i) {
                scriptService.compile(new Script(ScriptType.INLINE, "painless", "params." + scriptContext.name + i, Collections.emptyMap()), scriptContext);
            }
        }
        MatcherAssert.assertThat((Object)scriptService.cacheStats().getGeneralStats().getCompilations(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(minExpectedNoOfCompilations)));
    }

    @Test
    public void testPropertyAccessForTriggeredTime() {
        ValidationErrors validationErrors = new ValidationErrors();
        SignalsObjectFunctionScript.Factory factory = (SignalsObjectFunctionScript.Factory)watchInitService.compile("test", "trigger.triggered_time", "painless", SignalsObjectFunctionScript.CONTEXT, validationErrors);
        Assert.assertFalse((String)validationErrors.toString(), (boolean)validationErrors.hasErrors());
        WatchExecutionContextData watchExecutionContextData = new WatchExecutionContextData(new NestedValueMap(), new WatchExecutionContextData.WatchInfo("test_id", "test_tenant"), new WatchExecutionContextData.TriggerInfo(new Date(1234L), new Date(4567L), new Date(), new Date()), null);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(watchExecutionContextData);
        SignalsObjectFunctionScript script = factory.newInstance(new HashMap(), ctx);
        Object result = script.execute();
        Assert.assertEquals((Object)watchExecutionContextData.getTriggerInfo().getTriggeredTime(), (Object)result);
    }

    @Test
    public void testPropertyAccessForWatchId() {
        ValidationErrors validationErrors = new ValidationErrors();
        SignalsObjectFunctionScript.Factory factory = (SignalsObjectFunctionScript.Factory)watchInitService.compile("test", "watch.id", "painless", SignalsObjectFunctionScript.CONTEXT, validationErrors);
        Assert.assertFalse((String)validationErrors.toString(), (boolean)validationErrors.hasErrors());
        WatchExecutionContextData watchExecutionContextData = new WatchExecutionContextData(new NestedValueMap(), new WatchExecutionContextData.WatchInfo("test_id", "test_tenant"), new WatchExecutionContextData.TriggerInfo(new Date(1234L), new Date(4567L), new Date(), new Date()), null);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(watchExecutionContextData);
        SignalsObjectFunctionScript script = factory.newInstance(new HashMap(), ctx);
        Object result = script.execute();
        Assert.assertEquals((Object)watchExecutionContextData.getWatch().getId(), (Object)result);
    }

    private WatchExecutionContext buildWatchExecutionContext(WatchExecutionContextData watchExecutionContextData) {
        return new WatchExecutionContext(null, scriptService, xContentRegistry, null, ExecutionEnvironment.TEST, ActionInvocationType.ALERT, watchExecutionContextData, null, SimulationMode.SIMULATE_ACTIONS, null, null, null, null, (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class), (ClusterService)Mockito.mock(ClusterService.class), (FeatureService)Mockito.mock(FeatureService.class));
    }

    static {
        cluster = new LocalCluster.Builder().singleNode().sslEnabled().resources("sg_config/signals").nodeSettings(new Object[]{"signals.enabled", true, "signals.index_names.log", "signals_main_log", "searchguard.enterprise_modules_enabled", false}).nodeSettings(new Object[]{"script.max_compilations_rate", "1/1m"}).enableModule(SignalsModule.class).waitForComponents(new String[]{"signals"}).embedded().build();
    }
}

