/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.actions.summary.PredefinedWatches;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.awaitility.Awaitility;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class LoadOperatorSummaryActionTest {
    private static final Logger log = LogManager.getLogger(LoadOperatorSummaryActionTest.class);
    public static final TestSgConfig.Role ROLE_SIGNAL_ADMIN = new TestSgConfig.Role("signals_admin").withTenantPermission(new String[]{"cluster:admin:searchguard:tenant:signals:*"}).on(new String[]{"SGS_GLOBAL_TENANT"});
    public static final TestSgConfig.User USER_ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS, ROLE_SIGNAL_ADMIN});
    public static final String INDEX_NAME_WATCHED_1 = "watched-source-index-01";
    public static final String INDEX_NAME_WATCHED_2 = "watched-source-index-02";
    public static final String INDEX_NAME_WATCHED_3 = "watched-source-index-03";
    public static final String INDEX_NAME_WATCHED_4 = "watched-source-index-04";
    public static final String INDEX_NAME_WATCHED_5 = "watched-source-index-05";
    public static final String INDEX_NAME_WATCHED_6 = "watched-source-index-06";
    public static final String INDEX_NAME_WATCHED_7 = "watched-source-index-07";
    public static final String INDEX_NAME_WATCHED_8 = "watched-source-index-08";
    public static final String INDEX_NAME_WATCHED_9 = "watched-source-index-09";
    public static final String INDEX_ALARMS = "alarms";
    public static final String INDEX_SIGNALS_WATCHES_STATE = ".signals_watches_state";
    public static final String EMPTY_JSON_BODY = DocNode.EMPTY.toString();
    public static final String TRIGGER_CRON_DISTANT_FUTURE = "0 0 12 31 12 ? 2075";
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().enableModule(SignalsModule.class).user(USER_ADMIN).embedded().build();

    @BeforeClass
    public static void createTestData() {
        Client client = cluster.getInternalNodeClient();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_1).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 1, "temperature", 0.0, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_1).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 1, "temperature", 0.1, " humidity", 0.1})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_1).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 1, "temperature", 4.3, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_2).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 2, "temperature", 0.0, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_2).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 2, "temperature", 0.1, " humidity", 0.1})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_2).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 2, "temperature", 0.1, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_3).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 3, "temperature", 0.0, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_3).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 3, "temperature", 0.1, " humidity", 0.1})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_3).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 3, "temperature", 13.3, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_4).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 4, "temperature", 36.5, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_5).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 5, "temperature", 7.25, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_6).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 6, "temperature", 7.35, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_7).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 7, "temperature", 7.45, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_8).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 8, "temperature", 7.55, " humidity", 0.0})).actionGet();
        client.index(((IndexRequest)new IndexRequest(INDEX_NAME_WATCHED_9).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"source_id", 8, "temperature", 25.55, " humidity", 0.0})).actionGet();
        client.admin().indices().create(new CreateIndexRequest(INDEX_ALARMS)).actionGet();
    }

    @After
    public void deleteWatchStateAndAlarms() {
        Client client = cluster.getPrivilegedInternalNodeClient();
        LoadOperatorSummaryActionTest.deleteDocumentsFromIndex(client, INDEX_SIGNALS_WATCHES_STATE);
        LoadOperatorSummaryActionTest.deleteDocumentsFromIndex(client, INDEX_ALARMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteDocumentsFromIndex(Client client, String indexName) {
        SearchResponse searchResponse = (SearchResponse)client.search(new SearchRequest(new String[]{indexName})).actionGet();
        try {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                String documentId = hit.getId();
                client.delete(((DeleteRequest)new DeleteRequest(indexName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(documentId)).actionGet();
                log.debug("Deleted document '{}' from index '{}'. Document: '{}'.", (Object)documentId, (Object)indexName, (Object)hit.getSourceAsString());
            }
        }
        finally {
            searchResponse.decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGetActionSummaryWithInfoLevel() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temperature-alerts-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.countWatchStatusWithAvailableStatusCode(INDEX_SIGNALS_WATCHES_STATE) > 0L);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temperature-alerts-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].active", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity", (Object)"info"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0]", (String)"description"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level", (Object)"info"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)4.3, (double)1.0E-5)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.threshold", Double.class, (Matcher)Matchers.closeTo((double)3.0, (double)1.0E-5)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches[0].actions", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.createAlarm.check_result", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].actions.createAlarm.status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"triggered"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"checked"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"execution"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.status_details"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.ack_by"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.ack_on"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIncludeWatchActivityStatus() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temperature-alerts-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.countWatchStatusWithAvailableStatusCode(INDEX_SIGNALS_WATCHES_STATE) > 0L);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temperature-alerts-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].active", (Object)true));
            response = restClient.delete("/_signals/watch/_main/temperature-alerts-2/_active", new Header[0]);
            log.info("Watch deactive response status code '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temperature-alerts-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].active", (Object)false));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGetActionSummaryWithErrorLevel() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temperature-alerts-1", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.15, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 0L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 1);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temperature-alerts-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity", (Object)"error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0]", (String)"description"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level", (Object)"error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)13.3, (double)1.0E-5)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.threshold", Double.class, (Matcher)Matchers.closeTo((double)10.0, (double)1.0E-5)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches[0].actions", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.createAlarm.check_result", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].actions.createAlarm.status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"triggered"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"checked"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"execution"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.status_details"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGetActionSummaryWithoutSeverity() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatch("high-temp-alerts", INDEX_NAME_WATCHED_2, INDEX_ALARMS, 0.05);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 0L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 1);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"high-temp-alerts"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0]", (String)"description"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches[0].actions", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.createAlarm.check_result", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].actions.createAlarm.status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"triggered"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"checked"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"execution"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.status_details"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLoadSummaryOfMultipleWatch() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatch("high-temp-alerts", INDEX_NAME_WATCHED_2, INDEX_ALARMS, 0.05);
        predefinedWatches.defineTemperatureSeverityWatch("temperature-alerts", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.15, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 0L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 2);
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary of multiple watches response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temperature-alerts"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity", (Object)"error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0]", (String)"severity"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level", (Object)"error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)13.3, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.threshold", Double.class, (Matcher)Matchers.closeTo((double)10.0, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"triggered"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions.createAlarm", (String)"checked"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.createAlarm.check_result", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].actions.createAlarm.status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.status_details"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"high-temp-alerts"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[1]", (String)"severity"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[1].actions.createAlarm", (String)"triggered"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[1].actions.createAlarm", (String)"checked"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].actions.createAlarm.check_result", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[1].actions.createAlarm.error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].actions.createAlarm.status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[1].actions.createAlarm.status_details"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLoadSummaryOfWatchWithMultipleActions() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatchWitDoubleActions("double-alerts", INDEX_NAME_WATCHED_2, INDEX_ALARMS, 0.05);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 0L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 1);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", "{}", new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches[0].actions", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions", (String)"create_alarmOne"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions", (String)"create_alarmTwo"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByNumericSeverityDesc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 2L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 3);
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"temp-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity_details.level_numeric", (Object)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].watch_id", (Object)"temp-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].severity_details.level_numeric", (Object)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByNumericSeverityAsc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 2L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 2);
            String sorting = "+severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"temp-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity_details.level_numeric", (Object)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].severity_details.level_numeric", (Object)4));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByStringSeverityAsc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1.1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 5);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=+severity", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)5));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity", (Object)"critical"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"temp-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity", (Object)"error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].watch_id", (Object[])new String[]{"temp-1.1", "temp-1"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].severity", (Object)"info"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[3].watch_id", (Object[])new String[]{"temp-1.1", "temp-1"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].severity", (Object)"info"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[4].watch_id", (Object)"temp-4"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[4].severity", (Object)"warning"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByStringSeverityDesc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1.1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 5);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=-severity", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)5));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-4"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity", (Object)"warning"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].watch_id", (Object[])new String[]{"temp-1.1", "temp-1"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity", (Object)"info"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].watch_id", (Object[])new String[]{"temp-1.1", "temp-1"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].severity", (Object)"info"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].watch_id", (Object)"temp-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].severity", (Object)"error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[4].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[4].severity", (Object)"critical"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReportErrorWhenSortingOnIncorrectField() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 0L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 1);
            String fieldName = "incorrect-field";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=+incorrect-field", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)400));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containSubstring((String)"error.message", (String)"Cannot sort by unknown field"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containSubstring((String)"error.message", (String)"incorrect-field"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotTriggerActionDueToTooLowSeverity() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForFirstActionNonEmptyStatus(restClient);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"critical-severity-action"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity", (Object)"error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0]", (String)"description"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level", (Object)"error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)13.3, (double)1.0E-5)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.threshold", Double.class, (Matcher)Matchers.closeTo((double)10.0, (double)1.0E-5)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches[0].actions", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.createAlarm.check_result", (Object)false));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.createAlarm.status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.createAlarm.status_details", (Object)"No action because current severity is lower than severity configured for action: error"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByStatusCodeAsc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-1", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=+status_code", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].watch_id", (Object[])new String[]{"temp-1", "temp-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].watch_id", (Object[])new String[]{"temp-1", "temp-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].watch_id", (Object[])new String[]{"critical-severity-action-1", "critical-severity-action-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[3].watch_id", (Object[])new String[]{"critical-severity-action-1", "critical-severity-action-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].status_code", (Object)"NO_ACTION"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByStatusCodeDesc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-1", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=-status_code", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].watch_id", (Object[])new String[]{"critical-severity-action-1", "critical-severity-action-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].watch_id", (Object[])new String[]{"critical-severity-action-1", "critical-severity-action-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].watch_id", (Object[])new String[]{"temp-1", "temp-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].status_code", (Object[])new Serializable[]{String.class, "ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[3].watch_id", (Object[])new String[]{"temp-1", "temp-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[3].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByMultipleFieldsDesc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_6, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_7, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-5", INDEX_NAME_WATCHED_8, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 5);
            String sortingExpression = "-severity_details.level_numeric,-severity_details.current_value";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sortingExpression, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)5));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)36.5, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"temp-5"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[1].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)7.55, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].watch_id", (Object)"temp-4"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[2].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)7.45, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[3].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)7.35, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[4].watch_id", (Object)"temp-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[4].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[4].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)7.25, (double)0.001)));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByFirstFieldDescAndSecondAsc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_6, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_7, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-5", INDEX_NAME_WATCHED_8, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 5);
            String sortingExpression = "-severity_details.level_numeric,+severity_details.current_value";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sortingExpression, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)5));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)36.5, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"temp-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[1].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)7.25, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[2].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)7.35, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].watch_id", (Object)"temp-4"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[3].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)7.45, (double)0.001)));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[4].watch_id", (Object)"temp-5"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[4].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[4].severity_details.current_value", Double.class, (Matcher)Matchers.closeTo((double)7.55, (double)0.001)));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByInternalActionStatusDesc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatchWitDoubleActionsAndVariousSeverity("watch-id-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25);
        predefinedWatches.defineSimpleTemperatureWatchWitDoubleActionsAndVariousSeverity("watch-id-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 2);
            String sortingExpression = "-actions.create_alarmOne.status_code";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sortingExpression, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"watch-id-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.create_alarmOne.status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.create_alarmTwo.status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"watch-id-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].actions.create_alarmOne.status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].actions.create_alarmTwo.status_code", (Object)"NO_ACTION"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByInternalActionStatusAsc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatchWitDoubleActionsAndVariousSeverity("watch-id-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25);
        predefinedWatches.defineSimpleTemperatureWatchWitDoubleActionsAndVariousSeverity("watch-id-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 2);
            String sortingExpression = "+actions.create_alarmOne.status_code";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sortingExpression, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"watch-id-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].actions.create_alarmOne.status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.create_alarmTwo.status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"watch-id-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].actions.create_alarmOne.status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].actions.create_alarmTwo.status_code", (Object)"NO_ACTION"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByActionCheckedTimeAsc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatch("watch-id-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25);
        predefinedWatches.defineSimpleTemperatureWatch("watch-id-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineSimpleTemperatureWatch("watch-id-3", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 3);
            String sortingExpression = "+actions.createAlarm.checked";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sortingExpression, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)3));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByActionTriggeredTimeDesc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatch("watch-id-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25);
        predefinedWatches.defineSimpleTemperatureWatch("watch-id-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineSimpleTemperatureWatch("watch-id-3", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 3);
            String sortingExpression = "-actions.createAlarm.triggered";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sortingExpression, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)3));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSortByActionExecutionTimeAsc() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatch("watch-id-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25);
        predefinedWatches.defineSimpleTemperatureWatch("watch-id-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineSimpleTemperatureWatch("watch-id-3", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 3);
            String sortingExpression = "+actions.createAlarm.execution";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sortingExpression, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)3));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByStatusCode() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-1", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"status_codes", Collections.singletonList("NO_ACTION")).toJsonString();
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=+status_code", requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].watch_id", (Object[])new String[]{"critical-severity-action-1", "critical-severity-action-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].watch_id", (Object[])new String[]{"critical-severity-action-1", "critical-severity-action-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].status_code", (Object)"NO_ACTION"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByStatusCodeWhichDoesNotOccursInStatuses() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-1", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"status_codes", Collections.singletonList("notUsedStatus")).toJsonString();
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=+status_code", requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)0));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByMultipleStatusCodesStatusCodeWhichDoesNotOccursInStatuses() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-1", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureWatchWithActionOnCriticalSeverity("critical-severity-action-2", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25);
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"status_codes", Arrays.asList("NO_ACTION", "ACTION_THROTTLED", "ACTION_EXECUTED")).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].watch_id", String.class, (Matcher)Matchers.startsWith((String)"critical-severity-action")));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[1].watch_id", String.class, (Matcher)Matchers.startsWith((String)"critical-severity-action")));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[2].watch_id", String.class, (Matcher)Matchers.startsWith((String)"temp-")));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[3].watch_id", String.class, (Matcher)Matchers.startsWith((String)"temp-")));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[3].status_code", (Object[])new String[]{"ACTION_EXECUTED", "ACTION_THROTTLED"}));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldApplyDefaultSortingByNumericSeverityLevel() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("level-info", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("level-warning-1", INDEX_NAME_WATCHED_7, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("level-warning-2", INDEX_NAME_WATCHED_8, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("level-critical", INDEX_NAME_WATCHED_9, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"status_codes", Arrays.asList("ACTION_THROTTLED", "ACTION_EXECUTED")).toJsonString();
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"level-critical"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].watch_id", (Object[])new String[]{"level-warning-1", "level-warning-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].watch_id", (Object[])new String[]{"level-warning-1", "level-warning-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].severity_details.level_numeric", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].watch_id", (Object)"level-info"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].severity_details.level_numeric", (Object)1));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByWatchIdOne() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("one-and-two", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"watch_id", (Object)"one").toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"one-and-two"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"one"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByWatchIdThree() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("one-and-two", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"watch_id", (Object)"three").toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"three"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotFindAnyWatchDuringFilteringById() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("one-and-two", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"watch_id", (Object)"no-such-watch-id").toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)0));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByCriticalSeverity() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"severities", Collections.singletonList("critical")).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-4"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity", (Object)"critical"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByInfoOrErrorSeverity() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"severities", Arrays.asList("error", "info")).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity", (Object)"error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].watch_id", (Object[])new String[]{"temp-1", "temp-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity", (Object)"info"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].watch_id", (Object[])new String[]{"temp-1", "temp-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].severity", (Object)"info"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByWarningSeverity() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"severities", Collections.singletonList("warning")).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)0));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByEqualNumeric4SeverityLeve() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"level_numeric_equal_to", (Object)4).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-4"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)4));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByEqualNumeric3SeverityLeve() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"level_numeric_equal_to", (Object)3).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)3));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByGreaterNumericSeverity1Leve() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"level_numeric_greater_than", (Object)1).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-4"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity_details.level_numeric", (Object)3));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByGreaterNumericSeverity2Leve() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 2);
            String requestBody = DocNode.of((String)"level_numeric_greater_than", (Object)2).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-4"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"temp-3"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity_details.level_numeric", (Object)3));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByGreaterNumericSeverity3Leve() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"level_numeric_greater_than", (Object)3).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"temp-4"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)4));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByLessNumericSeverity3Leve() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"level_numeric_less_than", (Object)3).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].watch_id", (Object[])new String[]{"temp-1", "temp-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].watch_id", (Object[])new String[]{"temp-1", "temp-2"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity_details.level_numeric", (Object)1));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByLessNumericSeverity4Leve() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"level_numeric_less_than", (Object)4).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].watch_id", (Object[])new String[]{"temp-3"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].severity_details.level_numeric", (Object)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].severity_details.level_numeric", (Object)1));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.anyOf((Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].watch_id", (Object[])new String[]{"temp-1"}), (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[1].watch_id", (Object[])new String[]{"temp-2"})));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.anyOf((Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].watch_id", (Object[])new String[]{"temp-1"}), (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[2].watch_id", (Object[])new String[]{"temp-2"})));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByNumericSeverityLeveBetweenGivenValues() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"level_numeric_greater_than", (Object)2, (String)"level_numeric_less_than", (Object)4).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsAnyValues((String)"data.watches[0].watch_id", (Object[])new String[]{"temp-3"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].severity_details.level_numeric", (Object)3));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDetectIncorrectRangeCriteria() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("temp-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-2", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("temp-4", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 3L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"level_numeric_greater_than", (Object)2, (String)"level_numeric_less_than", (Object)4).with("level_numeric_equal_to", (Object)1).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)400));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containSubstring((String)"error.message", (String)"Incorrect search criteria"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sortingByNonExistingFieldShouldNotCauseException() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatch("high-temp-alerts", INDEX_NAME_WATCHED_2, INDEX_ALARMS, 0.05);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.getCountOfDocuments(INDEX_ALARMS) > 0L);
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 1);
            String sorting = "actions.not-existing-action.triggered";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"high-temp-alerts"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    @Test
    public void sortingByNonExistingFieldShouldNotCauseExceptionNoWatches() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            this.deleteWatchStateAndAlarms();
            String sorting = "actions.not-existing-action.triggered";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByActionsNames() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "actionOne");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "actionTwo");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "actionThree");
        predefinedWatches.defineTemperatureSeverityWatch("four", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "actionFour");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"actions", Arrays.asList("actionOne", "actionTwo")).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"two"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"one"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterOutAllWatchesByActionsNames() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "actionOne");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "actionTwo");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "actionThree");
        predefinedWatches.defineTemperatureSeverityWatch("four", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "actionFour");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.of((String)"actions", Arrays.asList("actionFive")).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)0));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByActionTimeRanges() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "actionOne");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "actionTwo");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "actionThree");
        predefinedWatches.defineTemperatureSeverityWatch("four", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "actionFour");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.wrap((Object)ImmutableMap.of((Object)"actions.actionFour.triggeredAfter", (Object)Instant.now().minus(1L, ChronoUnit.DAYS), (Object)"actions.actionFour.checkedAfter", (Object)Instant.now().minus(1L, ChronoUnit.DAYS), (Object)"actions.actionFour.executionAfter", (Object)Instant.now().minus(1L, ChronoUnit.DAYS), (Object)"actions.actionFour.triggeredBefore", (Object)Instant.now().plus(1L, ChronoUnit.DAYS), (Object)"actions.actionFour.checkedBefore", (Object)Instant.now().plus(1L, ChronoUnit.DAYS))).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"four"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterOutAllWatchesByActionTimeRanges() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "actionOne");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "actionTwo");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "actionThree");
        predefinedWatches.defineTemperatureSeverityWatch("four", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "actionFour");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.wrap((Object)ImmutableMap.of((Object)"actions.actionFour.triggeredAfter", (Object)Instant.now().plus(1L, ChronoUnit.DAYS), (Object)"actions.actionFour.checkedAfter", (Object)Instant.now().plus(1L, ChronoUnit.DAYS), (Object)"actions.actionFour.executionAfter", (Object)Instant.now().plus(1L, ChronoUnit.DAYS), (Object)"actions.actionFour.triggeredBefore", (Object)Instant.now().minus(1L, ChronoUnit.DAYS), (Object)"actions.actionFour.checkedBefore", (Object)Instant.now().minus(1L, ChronoUnit.DAYS))).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)0));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByProperties() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "actionOne");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "actionTwo");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "actionThree");
        predefinedWatches.defineTemperatureSeverityWatch("four", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "actionFour");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.wrap((Object)ImmutableMap.of((Object)"actions.actionOne.statusCode", (Object)"ACTION_THROTTLED", (Object)"actions.actionOne.checkResult", (Object)true)).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"one"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.actionOne.status_code", (Object)"ACTION_THROTTLED"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.actionOne.check_result", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterByVariousCommonFieldsAndValues() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 50.0, "action");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.1, "action");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "anotherAction");
        predefinedWatches.defineTemperatureSeverityWatch("four", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "anotherAction");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.wrap((Object)ImmutableMap.of((Object)"actions", Arrays.asList("action"), (Object)"actions.action.checkResult", (Object)false)).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"one"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].status_code", (Object)"NO_ACTION"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterOutAllWatchesByProperties() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("one", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "actionOne");
        predefinedWatches.defineTemperatureSeverityWatch("two", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.25, "actionTwo");
        predefinedWatches.defineTemperatureSeverityWatch("three", INDEX_NAME_WATCHED_4, INDEX_ALARMS, 0.25, "actionThree");
        predefinedWatches.defineTemperatureSeverityWatch("four", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "actionFour");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 4);
            String requestBody = DocNode.wrap((Object)ImmutableMap.of((Object)"actions.actionOne.statusCode", (Object)"ACTION_THROTTLED", (Object)"actions.actionOne.checkResult", (Object)false)).toJsonString();
            String sorting = "-severity_details.level_numeric";
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?sorting=" + sorting, requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)0));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFindWatchByIdPrefix() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("watch_with_very_long_name", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.countWatchStatusWithAvailableStatusCode(INDEX_SIGNALS_WATCHES_STATE) > 0L);
            DocNode requestBody = DocNode.of((String)"watch_id", (Object)"watch_with_very");
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", (Map)requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"watch_with_very_long_name"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotFindWatchByIdPrefix() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("watch_with_very_long_name", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.countWatchStatusWithAvailableStatusCode(INDEX_SIGNALS_WATCHES_STATE) > 0L);
            DocNode requestBody = DocNode.of((String)"watch_id", (Object)"nosuchprefix");
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", (Map)requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)0));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDetectNeverExecutedWatch() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatchWithCronTrigger("watch_executed_in_distant_future", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "my_alarm", TRIGGER_CRON_DISTANT_FUTURE);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.watchHasEmptyLastStatus("_main/watch_executed_in_distant_future"));
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"watch_executed_in_distant_future"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"never_executed_watch_with_severity"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].tenant", (Object)"_main"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].status_code"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].severity"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].description"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].severity_details"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIncludeNeverExecutedWatchesWithSeverityWhenFilterIsEmpty() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("watch_with_very_long_name", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatchWithCronTrigger("watch_executed_in_distant_future", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "my_alarm", TRIGGER_CRON_DISTANT_FUTURE);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.countWatchStatusWithAvailableStatusCode(INDEX_SIGNALS_WATCHES_STATE) > 0L);
            Awaitility.await().until(() -> predefinedWatches.watchHasEmptyLastStatus("_main/watch_executed_in_distant_future"));
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"watch_executed_in_distant_future"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"never_executed_watch_with_severity"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].tenant", (Object)"_main"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].status_code"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].severity"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].description"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].severity_details"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"watch_with_very_long_name"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIncludeNeverExecutedWatchesWithSeverityAndApplyFilter() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("watch_with_very_long_name", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatchWithCronTrigger("watch_executed_in_distant_future", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "my_alarm", TRIGGER_CRON_DISTANT_FUTURE);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.countWatchStatusWithAvailableStatusCode(INDEX_SIGNALS_WATCHES_STATE) > 0L);
            Awaitility.await().until(() -> predefinedWatches.watchHasEmptyLastStatus("_main/watch_executed_in_distant_future"));
            DocNode requestBody = DocNode.of((String)"watch_id", (Object)"watch_with");
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", (Map)requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"watch_with_very_long_name"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDetectErrorsDuringWatchExecution() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineErrorWatch("error_in_condition_definition", INDEX_NAME_WATCHED_1, 0.25, "my_alarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForFirstActionNonEmptyStatus(restClient);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"error_in_condition_definition"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].tenant", (Object)"_main"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].status_code", (Object)"EXECUTION_FAILED"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"failed_watch"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].severity"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].description", (Object)"Error while executing Condition null: Script Execution Error"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].severity_details"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIncludeWatchesWithExecutionFailuresAndNeverExecutedWatchesWhenFilterIsEmpty() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("my_unique_name", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("another_name", INDEX_NAME_WATCHED_9, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineErrorWatch("error_in_condition_definition", INDEX_NAME_WATCHED_1, 0.25, "my_alarm");
        predefinedWatches.defineTemperatureSeverityWatchWithCronTrigger("watch_executed_in_distant_future", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "my_alarm", TRIGGER_CRON_DISTANT_FUTURE);
        predefinedWatches.defineTemperatureWithoutSeverities("my_watch_without_severities_are_always_ignored", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.countWatchStatusWithAvailableStatusCode(INDEX_SIGNALS_WATCHES_STATE) > 3L);
            Awaitility.await().until(() -> predefinedWatches.watchHasEmptyLastStatus("_main/watch_executed_in_distant_future"));
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)4));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"error_in_condition_definition"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"failed_watch"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].tenant", (Object)"_main"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].watch_id", (Object)"watch_executed_in_distant_future"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[1].reason", (Object)"never_executed_watch_with_severity"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].watch_id", (Object)"another_name"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[2].reason", (Object)"match_filter"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].watch_id", (Object)"my_unique_name"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[3].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIncludeWatchesWithExecutionFailuresAndNeverExecutedWatchesAndApplyFilter() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("my_unique_name", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineTemperatureSeverityWatch("another_name", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        predefinedWatches.defineErrorWatch("error_in_condition_definition", INDEX_NAME_WATCHED_1, 0.25, "my_alarm");
        predefinedWatches.defineTemperatureSeverityWatchWithCronTrigger("watch_executed_in_distant_future", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "my_alarm", TRIGGER_CRON_DISTANT_FUTURE);
        predefinedWatches.defineTemperatureWithoutSeverities("my_watch_without_severities_are_always_ignored", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            Awaitility.await().until(() -> predefinedWatches.countWatchStatusWithAvailableStatusCode(INDEX_SIGNALS_WATCHES_STATE) > 3L);
            Awaitility.await().until(() -> predefinedWatches.watchHasEmptyLastStatus("_main/watch_executed_in_distant_future"));
            DocNode requestBody = DocNode.of((String)"watch_id", (Object)"my_");
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", (Map)requestBody, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"my_unique_name"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].reason", (Object)"match_filter"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIncludeOnlyActionsDefinedInWatch() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("many_actions_watch", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "action-01", "action-02", "action-03");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForFirstActionNonEmptyStatus(restClient);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions", (String)"action-01"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions", (String)"action-02"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions", (String)"action-03"));
            predefinedWatches.defineTemperatureSeverityWatch("many_actions_watch", INDEX_NAME_WATCHED_5, INDEX_ALARMS, 0.25, "action-02", "action-04");
            LoadOperatorSummaryActionTest.waitForWatchWithAction(predefinedWatches, "action-04");
            response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Second watch summary response '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions", (String)"action-01")));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions", (String)"action-02"));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions", (String)"action-03")));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"data.watches[0].actions", (String)"action-04"));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIncludeDataRelatedToWatchAck() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineTemperatureSeverityWatch("level-critical", INDEX_NAME_WATCHED_9, INDEX_ALARMS, 0.25, "createAlarm");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchWithAction(predefinedWatches, "createAlarm");
            GenericRestClient.HttpResponse ackResponse = restClient.put("/_signals/watch/_main/level-critical/_ack");
            log.info("Watch ack response status code '{}' and body '{}'.", (Object)ackResponse.getStatusCode(), (Object)ackResponse.getBody());
            MatcherAssert.assertThat((Object)ackResponse.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            LoadOperatorSummaryActionTest.waitForWatchAckByUser(predefinedWatches, "createAlarm");
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].watch_id", (Object)"level-critical"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.watches[0].actions.createAlarm.ack_by", (Object)USER_ADMIN.getName()));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.fieldIsNull((String)"data.watches[0].actions.createAlarm.ack_on")));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReturnTwoOnlyWatches() throws Exception {
        PredefinedWatches predefinedWatches = new PredefinedWatches(cluster, USER_ADMIN, "_main");
        predefinedWatches.defineSimpleTemperatureWatch("watch-1", INDEX_NAME_WATCHED_1, INDEX_ALARMS, 0.05);
        predefinedWatches.defineSimpleTemperatureWatch("watch-2", INDEX_NAME_WATCHED_2, INDEX_ALARMS, 0.05);
        predefinedWatches.defineSimpleTemperatureWatch("watch-3", INDEX_NAME_WATCHED_3, INDEX_ALARMS, 0.05);
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            LoadOperatorSummaryActionTest.waitForWatchStatuses(predefinedWatches, 3);
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary?size=2", EMPTY_JSON_BODY, new Header[0]);
            log.info("Watch summary response body '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.watches", (int)2));
        }
        finally {
            predefinedWatches.deleteWatches();
        }
    }

    private static void waitForFirstActionNonEmptyStatus(GenericRestClient restClient) {
        Awaitility.await().ignoreException(AssertionError.class).until(() -> {
            GenericRestClient.HttpResponse response = restClient.postJson("/_signals/watch/_main/summary", "{}", new Header[0]);
            log.info("Waiting for status code of the first action state, body '{}'.", (Object)response.getBody());
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"data.watches[0].status_code", String.class, (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString())));
            return true;
        });
    }

    private static void waitForWatchStatuses(PredefinedWatches predefinedWatches, int expectedNumberOfWatchStatuses) {
        Awaitility.await().pollDelay(500L, TimeUnit.MILLISECONDS).until(() -> predefinedWatches.countWatchStatusWithAvailableStatusCode(INDEX_SIGNALS_WATCHES_STATE) >= (long)expectedNumberOfWatchStatuses);
    }

    private static void waitForWatchAckByUser(PredefinedWatches predefinedWatches, String actionName) {
        Awaitility.await().pollDelay(500L, TimeUnit.MILLISECONDS).until(() -> predefinedWatches.countWatchByAckStatus(INDEX_SIGNALS_WATCHES_STATE, actionName) > 0L);
    }

    private static void waitForWatchWithAction(PredefinedWatches predefinedWatches, String actionName) {
        Awaitility.await().pollDelay(500L, TimeUnit.MILLISECONDS).until(() -> predefinedWatches.countWatchByActionName(INDEX_SIGNALS_WATCHES_STATE, actionName) > 0L);
    }
}

