/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.signals.actions.summary.LoadOperatorSummaryData;
import com.floragunn.signals.actions.summary.WatchActionNames;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class LoadOperatorSummaryDataTests {
    public static final Instant NOW = Instant.parse("2024-06-01T12:00:00Z");

    private static Map<String, Object> extractActionsFromWatchNumber(LoadOperatorSummaryData filtered, int index) {
        Map obj = filtered.toBasicObject();
        List<Map<String, Object>> watches = LoadOperatorSummaryDataTests.extractWatchesMap(obj);
        return (Map)watches.get(index).get("actions");
    }

    private static List<Map<String, Object>> extractWatchesMap(Map<String, Object> obj) {
        return (List)obj.get("watches");
    }

    private LoadOperatorSummaryData.ActionSummary actionSummary() {
        return new LoadOperatorSummaryData.ActionSummary(NOW, NOW, Boolean.valueOf(true), NOW, "err", "200", "ok", null, null);
    }

    private LoadOperatorSummaryData.WatchSummary watchSummary(String id, Map<String, LoadOperatorSummaryData.ActionSummary> actions) {
        return new LoadOperatorSummaryData.WatchSummary(id, "status", "sev", "desc", null, actions, "reason", null);
    }

    @Test
    public void shouldFilterActionsByAllowedNames() {
        HashMap<String, LoadOperatorSummaryData.ActionSummary> actions = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
        actions.put("existing_action", this.actionSummary());
        actions.put("deleted_action", this.actionSummary());
        LoadOperatorSummaryData.WatchSummary watchSummary = this.watchSummary("tenant1/watch1", actions);
        LoadOperatorSummaryData summaryData = new LoadOperatorSummaryData(List.of(watchSummary));
        WatchActionNames watchActionNames = new WatchActionNames("tenant1/watch1", List.of("existing_action"), null);
        LoadOperatorSummaryData filteredSummaryData = summaryData.filterActions(List.of(watchActionNames));
        Map<String, Object> actionsMap = LoadOperatorSummaryDataTests.extractActionsFromWatchNumber(filteredSummaryData, 0);
        MatcherAssert.assertThat(actionsMap, (Matcher)Matchers.aMapWithSize((int)1));
        MatcherAssert.assertThat(actionsMap.keySet(), (Matcher)Matchers.contains((Object[])new String[]{"existing_action"}));
    }

    @Test
    public void shouldRemoveAllActionsIfWatchDoesNotContainsAnyAction() {
        HashMap<String, LoadOperatorSummaryData.ActionSummary> actions = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
        actions.put("existing_action", this.actionSummary());
        actions.put("deleted_action", this.actionSummary());
        LoadOperatorSummaryData.WatchSummary watchSummary = this.watchSummary("tenant1/watch1", actions);
        LoadOperatorSummaryData summaryData = new LoadOperatorSummaryData(List.of(watchSummary));
        WatchActionNames watchActionNames = new WatchActionNames("tenant1/watch1", List.of(), null);
        LoadOperatorSummaryData filteredSummaryData = summaryData.filterActions(List.of(watchActionNames));
        Map<String, Object> actionsMap = LoadOperatorSummaryDataTests.extractActionsFromWatchNumber(filteredSummaryData, 0);
        MatcherAssert.assertThat(actionsMap, (Matcher)Matchers.aMapWithSize((int)0));
    }

    @Test
    public void shouldFilterActionsByMultipleAllowedNames() {
        HashMap<String, LoadOperatorSummaryData.ActionSummary> actions = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
        actions.put("existing_action_1", this.actionSummary());
        actions.put("existing_action_2", this.actionSummary());
        actions.put("existing_action_3", this.actionSummary());
        actions.put("deleted_action_1", this.actionSummary());
        actions.put("deleted_action_2", this.actionSummary());
        actions.put("deleted_action_3", this.actionSummary());
        LoadOperatorSummaryData.WatchSummary watchSummary_1 = this.watchSummary("tenant1/watch1", new HashMap<String, LoadOperatorSummaryData.ActionSummary>(actions));
        LoadOperatorSummaryData.WatchSummary watchSummary_2 = this.watchSummary("tenant1/watch2", new HashMap<String, LoadOperatorSummaryData.ActionSummary>(actions));
        LoadOperatorSummaryData summaryData = new LoadOperatorSummaryData(List.of(watchSummary_1, watchSummary_2));
        WatchActionNames watchActionNames_1 = new WatchActionNames("tenant1/watch1", List.of("existing_action_1"), null);
        WatchActionNames watchActionNames_2 = new WatchActionNames("tenant1/watch2", List.of("existing_action_2", "existing_action_3"), null);
        LoadOperatorSummaryData filteredSummaryData = summaryData.filterActions(List.of(watchActionNames_1, watchActionNames_2));
        Map<String, Object> actionsMap = LoadOperatorSummaryDataTests.extractActionsFromWatchNumber(filteredSummaryData, 0);
        MatcherAssert.assertThat(actionsMap, (Matcher)Matchers.aMapWithSize((int)1));
        MatcherAssert.assertThat(actionsMap.keySet(), (Matcher)Matchers.contains((Object[])new String[]{"existing_action_1"}));
        actionsMap = LoadOperatorSummaryDataTests.extractActionsFromWatchNumber(filteredSummaryData, 1);
        MatcherAssert.assertThat(actionsMap, (Matcher)Matchers.aMapWithSize((int)2));
        MatcherAssert.assertThat(actionsMap.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"existing_action_2", "existing_action_3"}));
    }

    @Test
    public void shouldReturnSameDataIfAllowedNamesListIsEmpty() {
        HashMap<String, LoadOperatorSummaryData.ActionSummary> actions = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
        actions.put("action_1", this.actionSummary());
        LoadOperatorSummaryData.WatchSummary ws = this.watchSummary("tenant/watch", actions);
        LoadOperatorSummaryData data = new LoadOperatorSummaryData(List.of(ws));
        LoadOperatorSummaryData filteredSummaryData = data.filterActions(Collections.emptyList());
        Map<String, Object> actionsMap = LoadOperatorSummaryDataTests.extractActionsFromWatchNumber(filteredSummaryData, 0);
        MatcherAssert.assertThat(actionsMap.keySet(), (Matcher)Matchers.contains((Object[])new String[]{"action_1"}));
    }

    @Test
    public void shouldHandleWatchWithNoMatchingActionNames() {
        HashMap<String, LoadOperatorSummaryData.ActionSummary> actions = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
        actions.put("action_1", this.actionSummary());
        LoadOperatorSummaryData.WatchSummary watchSummary = this.watchSummary("tenant/watch", actions);
        LoadOperatorSummaryData summaryData = new LoadOperatorSummaryData(List.of(watchSummary));
        WatchActionNames watchActionNames = new WatchActionNames("tenant/watch", List.of(), null);
        LoadOperatorSummaryData filteredSummaryData = summaryData.filterActions(List.of(watchActionNames));
        Map<String, Object> actionsMap = LoadOperatorSummaryDataTests.extractActionsFromWatchNumber(filteredSummaryData, 0);
        MatcherAssert.assertThat(actionsMap.keySet(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotFailIfWatchIdNotInAllowedList() {
        HashMap<String, LoadOperatorSummaryData.ActionSummary> actions = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
        actions.put("action_1", this.actionSummary());
        LoadOperatorSummaryData.WatchSummary watchSummary = this.watchSummary("tenant/watch", actions);
        LoadOperatorSummaryData data = new LoadOperatorSummaryData(List.of(watchSummary));
        WatchActionNames watchActionNames = new WatchActionNames("tenant/other_watch", List.of("another_action"), null);
        LoadOperatorSummaryData filteredSummaryData = data.filterActions(List.of(watchActionNames));
        Map<String, Object> actionsMap = LoadOperatorSummaryDataTests.extractActionsFromWatchNumber(filteredSummaryData, 0);
        MatcherAssert.assertThat(actionsMap.keySet(), (Matcher)Matchers.contains((Object[])new String[]{"action_1"}));
    }

    @Test
    public void shouldCombineUniqueWatchSummaries() {
        HashMap<String, LoadOperatorSummaryData.ActionSummary> actions1 = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
        actions1.put("action_1", this.actionSummary());
        HashMap<String, LoadOperatorSummaryData.ActionSummary> actions2 = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
        actions2.put("action_2", this.actionSummary());
        LoadOperatorSummaryData.WatchSummary watchSummary_1 = this.watchSummary("tenant/watch_1", actions1);
        LoadOperatorSummaryData.WatchSummary watchSummary_2 = this.watchSummary("tenant/watch_2", actions2);
        LoadOperatorSummaryData summaryData_1 = new LoadOperatorSummaryData(List.of(watchSummary_1));
        LoadOperatorSummaryData summaryData_2 = new LoadOperatorSummaryData(List.of(watchSummary_1, watchSummary_2));
        LoadOperatorSummaryData combined = summaryData_1.with(summaryData_2);
        DocNode watches = DocNode.wrap((Object)combined.toBasicObject());
        MatcherAssert.assertThat((Object)watches.getAsNode("watches").size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)watches, (Matcher)DocNodeMatchers.containsValue((String)"watches[0].watch_id", (Object)"watch_1"));
        MatcherAssert.assertThat((Object)watches, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"watches[0].actions", (int)1));
        MatcherAssert.assertThat((Object)watches, (Matcher)DocNodeMatchers.containsValue((String)"watches[0].actions.action_1.check_result", (Object)true));
        MatcherAssert.assertThat((Object)watches, (Matcher)DocNodeMatchers.containsValue((String)"watches[1].watch_id", (Object)"watch_2"));
        MatcherAssert.assertThat((Object)watches, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"watches[1].actions", (int)1));
        MatcherAssert.assertThat((Object)watches, (Matcher)DocNodeMatchers.containsValue((String)"watches[1].actions.action_2.check_result", (Object)true));
    }

    @Test
    public void shouldNotAddDuplicatesWhenCombining() {
        LoadOperatorSummaryData.WatchSummary watchSummary = this.watchSummary("tenant/watch", Map.of());
        LoadOperatorSummaryData summaryData_1 = new LoadOperatorSummaryData(List.of(watchSummary));
        LoadOperatorSummaryData summaryData_2 = new LoadOperatorSummaryData(List.of(watchSummary));
        LoadOperatorSummaryData combined = summaryData_1.with(summaryData_2);
        Map obj = combined.toBasicObject();
        List<Map<String, Object>> watches = LoadOperatorSummaryDataTests.extractWatchesMap(obj);
        MatcherAssert.assertThat(watches, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void shouldCombineMultipleWatches() {
        LoadOperatorSummaryData.WatchSummary watchSummary_1 = this.watchSummary("tenant/watch_1", Map.of());
        LoadOperatorSummaryData.WatchSummary watchSummary_2 = this.watchSummary("tenant/watch_2", Map.of());
        LoadOperatorSummaryData.WatchSummary watchSummary_3 = this.watchSummary("tenant/watch_3", Map.of());
        LoadOperatorSummaryData.WatchSummary watchSummary_4 = this.watchSummary("tenant/watch_4", Map.of());
        LoadOperatorSummaryData.WatchSummary watchSummary_5 = this.watchSummary("tenant/watch_5", Map.of());
        LoadOperatorSummaryData.WatchSummary watchSummary_6 = this.watchSummary("tenant/watch_6", Map.of());
        LoadOperatorSummaryData summaryData_1 = new LoadOperatorSummaryData(List.of(watchSummary_1, watchSummary_2, watchSummary_3, watchSummary_4));
        LoadOperatorSummaryData summaryData_2 = new LoadOperatorSummaryData(List.of(watchSummary_2, watchSummary_3, watchSummary_4, watchSummary_5, watchSummary_6));
        LoadOperatorSummaryData combined = summaryData_1.with(summaryData_2);
        Map obj = combined.toBasicObject();
        List<Map<String, Object>> watches = LoadOperatorSummaryDataTests.extractWatchesMap(obj);
        MatcherAssert.assertThat(watches, (Matcher)Matchers.hasSize((int)6));
        List<String> watchIds = watches.stream().map(map -> map.get("watch_id")).map(String.class::cast).toList();
        MatcherAssert.assertThat(watchIds, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"watch_1", "watch_2", "watch_3", "watch_4", "watch_5", "watch_6"}));
    }
}

