/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.proxy.rest;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.JvmEmbeddedEsCluster;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.proxy.service.ProxyCrudService;
import com.floragunn.signals.proxy.service.persistence.ProxyRepository;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.WatchBuilder;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ProxyApiTest {
    private static final TestSgConfig.User ADMIN_USER = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS.withTenantPermission(new String[]{"cluster:admin:searchguard:tenant:signals:*"}).on(new String[]{"SGS_GLOBAL_TENANT"})});
    private static final String SIGNALS_PROXIES_INDEX_NAME = ".signals_proxies";
    private static List<HttpProxyHostRegistry> nodesHttpProxyHostRegistries;
    @ClassRule
    public static LocalCluster.Embedded cluster;

    @BeforeClass
    public static void setup() {
        HttpProxyHostRegistry masterNodeRegistry = null;
        ArrayList<HttpProxyHostRegistry> dataNodesRegistries = new ArrayList<HttpProxyHostRegistry>();
        for (JvmEmbeddedEsCluster.Node node : cluster.nodes()) {
            Signals signals = (Signals)node.getInjectable(Signals.class);
            MatcherAssert.assertThat((Object)signals, (Matcher)Matchers.notNullValue());
            if (node.esNode().isMasterEligible()) {
                masterNodeRegistry = signals.getHttpProxyHostRegistry();
                continue;
            }
            dataNodesRegistries.add(signals.getHttpProxyHostRegistry());
        }
        MatcherAssert.assertThat(masterNodeRegistry, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(dataNodesRegistries, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(dataNodesRegistries, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.notNullValue(), Matchers.notNullValue()}));
        nodesHttpProxyHostRegistries = ImmutableList.of((Object)masterNodeRegistry).with(dataNodesRegistries);
    }

    @After
    public void removeProxies() {
        Client client = cluster.getPrivilegedInternalNodeClient();
        BulkByScrollResponse deleteResponse = (BulkByScrollResponse)client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{SIGNALS_PROXIES_INDEX_NAME}).setRefresh(true)).setQuery((QueryBuilder)QueryBuilders.matchAllQuery())).actionGet();
        MatcherAssert.assertThat((Object)deleteResponse.getBulkFailures(), (Matcher)Matchers.hasSize((int)0));
        nodesHttpProxyHostRegistries.forEach(HttpProxyHostRegistry::reloadAll);
    }

    @Test
    public void putProxyConfig_shouldSaveNewConfigProxy() throws Exception {
        try (GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            String proxyId = "save-proxy";
            String proxyName = "save-proxy";
            String proxyUri = "http://localhost:8080";
            DocNode proxy = DocNode.of((String)"uri", (Object)proxyUri, (String)"name", (Object)proxyName);
            this.saveProxyWithProxyApi(proxyId, proxy);
            GenericRestClient.HttpResponse getResponse = adminCertClient.get("/.signals_proxies/_doc/" + proxyId, new Header[0]);
            MatcherAssert.assertThat((String)getResponse.getBody(), (Object)getResponse.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode getResponseBody = getResponse.getBodyAsDocNode();
            MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.found", (Object)true));
            MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$._id", (Object)proxyId));
            MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$._source.name", (Object)proxyName));
            MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$._source.uri", (Object)proxyUri));
        }
    }

    @Test
    public void putProxyConfig_shouldUpdateExistingProxyConfig() throws Exception {
        try (GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            String proxyId = "update-proxy";
            String proxyName = "update-proxy";
            String proxyUri = "http://localhost:8080";
            DocNode proxy = DocNode.of((String)"uri", (Object)proxyUri, (String)"name", (Object)proxyName);
            this.saveProxyWithProxyApi(proxyId, proxy);
            String updatedProxyUri = proxyUri.concat("123");
            String updatedName = "new-name";
            proxy = proxy.with("uri", (Object)updatedProxyUri).with("name", (Object)updatedName);
            this.saveProxyWithProxyApi(proxyId, proxy);
            GenericRestClient.HttpResponse getResponse = adminCertClient.get("/.signals_proxies/_doc/" + proxyId, new Header[0]);
            MatcherAssert.assertThat((String)getResponse.getBody(), (Object)getResponse.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode getResponseBody = getResponse.getBodyAsDocNode();
            MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.found", (Object)true));
            MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$._id", (Object)proxyId));
            MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$._source.name", (Object)updatedName));
            MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$._source.uri", (Object)updatedProxyUri));
        }
    }

    @Test
    public void putProxyConfig_shouldNotSaveProxyConfig_whenProxyIdContainsNotAllowedValue() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            List<String> invalidIds = Arrays.asList("default", "NoNE", "http://127.0.0.1:123", "hTTps://127.0.0.1:343");
            for (String proxyId : invalidIds) {
                DocNode proxy = DocNode.of((String)"uri", (Object)"127.0.0.1:3333", (String)"name", (Object)"invalid-proxy");
                GenericRestClient.HttpResponse response = client.putJson("/_signals/proxies/" + URLEncoder.encode(proxyId, "UTF-8"), (Document)proxy);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.id[0].error", (Object)"Invalid value"));
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.id[0].value", (Object)proxyId));
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.id[0].expected", (Object)"String not equal to any of: (default, none) and not starting with any of: (http:, https:)"));
            }
        }
    }

    @Test
    public void putProxyConfig_shouldNotSaveProxyConfig_whenAnyOfRequiredAttributesIsMissing() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            String proxyId = "save-proxy";
            String proxyName = "";
            String proxyUri = "";
            DocNode proxy = DocNode.of((String)"uri", (Object)proxyUri, (String)"name", (Object)proxyName);
            GenericRestClient.HttpResponse response = client.putJson("/_signals/proxies/" + proxyId, (Document)proxy);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].error", (Object)"Invalid value"));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].value", (Object)proxyUri));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].expected", (Object)"Valid URI"));
            proxyName = null;
            proxyUri = null;
            proxy = DocNode.of((String)"uri", (Object)proxyUri, (String)"name", (Object)proxyName);
            response = client.putJson("/_signals/proxies/" + proxyId, (Document)proxy);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].error", (Object)"Invalid value"));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsNullValue((String)"$.error.details.uri[0].value"));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].expected", (Object)"Valid URI"));
            try (GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
                GenericRestClient.HttpResponse getResponse = adminCertClient.get("/.signals_proxies/_doc/" + proxyId, new Header[0]);
                MatcherAssert.assertThat((String)getResponse.getBody(), (Object)getResponse.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            }
        }
    }

    @Test
    public void putProxyConfig_shouldNotUpdateProxyConfig_whenAnyOfRequiredAttributesIsMissing() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            String proxyId = "update-proxy";
            String initialProxyName = "name";
            String initialProxyUri = "http://localhost:9000";
            DocNode proxy = DocNode.of((String)"uri", (Object)initialProxyUri, (String)"name", (Object)initialProxyName);
            GenericRestClient.HttpResponse response = client.putJson("/_signals/proxies/" + proxyId, (Document)proxy);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            String updatedProxyName = "";
            String updatedProxyUri = "";
            proxy = proxy.with("uri", (Object)updatedProxyUri).with("name", (Object)updatedProxyName);
            response = client.putJson("/_signals/proxies/" + proxyId, (Document)proxy);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].error", (Object)"Invalid value"));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].value", (Object)updatedProxyUri));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].expected", (Object)"Valid URI"));
            updatedProxyName = null;
            updatedProxyUri = null;
            proxy = DocNode.of((String)"uri", (Object)updatedProxyUri).with("name", (Object)updatedProxyName);
            response = client.putJson("/_signals/proxies/" + proxyId, (Document)proxy);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].error", (Object)"Invalid value"));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsNullValue((String)"$.error.details.uri[0].value"));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.uri[0].expected", (Object)"Valid URI"));
            try (GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
                GenericRestClient.HttpResponse getResponse = adminCertClient.get("/.signals_proxies/_doc/" + proxyId, new Header[0]);
                MatcherAssert.assertThat((String)getResponse.getBody(), (Object)getResponse.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                DocNode getResponseBody = getResponse.getBodyAsDocNode();
                MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.found", (Object)true));
                MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$._id", (Object)proxyId));
                MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$._source.name", (Object)initialProxyName));
                MatcherAssert.assertThat((String)getResponseBody.toJsonString(), (Object)getResponseBody, (Matcher)DocNodeMatchers.containsValue((String)"$._source.uri", (Object)initialProxyUri));
            }
        }
    }

    @Test
    public void getProxyConfigById_shouldReturnProxyConfig() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            String firstProxyId = "save-proxy-1";
            DocNode firstProxy = DocNode.of((String)"uri", (Object)"http://localhost:1", (String)"name", (Object)"name-1");
            String secondProxyId = "save-proxy-2";
            DocNode secondProxy = DocNode.of((String)"uri", (Object)"http://localhost:2", (String)"name", (Object)"name-2");
            this.saveProxyWithProxyApi(firstProxyId, firstProxy);
            this.saveProxyWithProxyApi(secondProxyId, secondProxy);
            GenericRestClient.HttpResponse response = client.get("/_signals/proxies/" + firstProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode proxyFromResponse = response.getBodyAsDocNode();
            MatcherAssert.assertThat((String)proxyFromResponse.toJsonString(), (Object)proxyFromResponse, (Matcher)DocNodeMatchers.containsValue((String)"$.data.id", (Object)firstProxyId));
            MatcherAssert.assertThat((String)proxyFromResponse.toJsonString(), (Object)proxyFromResponse, (Matcher)DocNodeMatchers.containsValue((String)"$.data.name", (Object)firstProxy.get("name")));
            MatcherAssert.assertThat((String)proxyFromResponse.toJsonString(), (Object)proxyFromResponse, (Matcher)DocNodeMatchers.containsValue((String)"$.data.uri", (Object)firstProxy.get("uri")));
            response = client.get("/_signals/proxies/" + secondProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            proxyFromResponse = response.getBodyAsDocNode();
            MatcherAssert.assertThat((String)proxyFromResponse.toJsonString(), (Object)proxyFromResponse, (Matcher)DocNodeMatchers.containsValue((String)"$.data.id", (Object)secondProxyId));
            MatcherAssert.assertThat((String)proxyFromResponse.toJsonString(), (Object)proxyFromResponse, (Matcher)DocNodeMatchers.containsValue((String)"$.data.name", (Object)secondProxy.get("name")));
            MatcherAssert.assertThat((String)proxyFromResponse.toJsonString(), (Object)proxyFromResponse, (Matcher)DocNodeMatchers.containsValue((String)"$.data.uri", (Object)secondProxy.get("uri")));
        }
    }

    @Test
    public void getProxyConfig_shouldNotReturnProxyConfig_proxyWithGivenIdDoesNotExist() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            String proxyId = "fake";
            GenericRestClient.HttpResponse response = client.get("/_signals/proxies/" + proxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            String errorMessage = "Proxy with id '" + proxyId + "' not found.";
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.message", (Object)errorMessage));
        }
    }

    @Test
    public void deleteProxyConfig_shouldDeleteExistingProxyConfig() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            String firstProxyId = "save-proxy-1";
            DocNode firstProxy = DocNode.of((String)"uri", (Object)"http://localhost:1", (String)"name", (Object)"name-11");
            String secondProxyId = "save-proxy-2";
            DocNode secondProxy = DocNode.of((String)"uri", (Object)"http://localhost:2", (String)"name", (Object)"name-22");
            this.saveProxyWithProxyApi(firstProxyId, firstProxy);
            this.saveProxyWithProxyApi(secondProxyId, secondProxy);
            GenericRestClient.HttpResponse response = client.get("/_signals/proxies/" + firstProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = client.get("/_signals/proxies/" + secondProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = client.delete("/_signals/proxies/" + firstProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = client.get("/_signals/proxies/" + firstProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            response = client.get("/_signals/proxies/" + secondProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    @Test
    public void deleteProxyConfig_shouldNotDeleteProxyConfig_proxyWithGivenIdIsUsedByWatch() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            String lowerCaseProxyId = "proxy-1".toLowerCase();
            String upperCaseProxyId = "proxy-1".toUpperCase();
            DocNode proxy = DocNode.of((String)"uri", (Object)"http://localhost:1");
            String watchPath = "/_signals/watch/_main/webhook_with_proxy";
            this.saveProxyWithProxyApi(lowerCaseProxyId, proxy);
            this.saveProxyWithProxyApi(upperCaseProxyId, proxy);
            Watch watch = new WatchBuilder("test_with_stored_proxy").cronTrigger("0 0 */1 * * ?").then().postWebhook("http://localhost:3233").proxy(lowerCaseProxyId).name("webhook").build();
            GenericRestClient.HttpResponse response = client.putJson(watchPath, watch.toJson(), new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            response = client.delete("/_signals/proxies/" + lowerCaseProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.message", (Object)"The proxy is still in use"));
            response = client.delete("/_signals/proxies/" + upperCaseProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = client.delete(watchPath, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = client.delete("/_signals/proxies/" + lowerCaseProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    @Test
    public void deleteProxyConfig_shouldNotDeleteProxyConfig_proxyWithGivenIdDoesNotExist() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            String proxyId = "fake";
            GenericRestClient.HttpResponse response = client.delete("/_signals/proxies/" + proxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
        }
    }

    @Test
    public void findAllProxiesConfigs_shouldReturnAllExistingProxies() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_signals/proxies/", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.data", (int)0));
            List<DocNode> proxies = this.saveRandomProxies(256);
            response = client.get("/_signals/proxies/", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode responseBody = response.getBodyAsDocNode();
            MatcherAssert.assertThat((String)response.getBody(), (Object)responseBody, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.data", (int)proxies.size()));
            MatcherAssert.assertThat((String)response.getBody(), (Object)responseBody.getAsListOfNodes("data"), (Matcher)Matchers.contains((Object[])proxies.toArray()));
        }
    }

    @Test
    public void findAllProxiesConfigs_shouldReturnAllExistingProxies_sortedByStoreTimeDesc() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            Instant now = Instant.now();
            String firstProxyId = "proxy-1";
            DocNode firstProxy = DocNode.of((String)"uri", (Object)"http://localhost:1", (String)"name", (Object)"proxy-1", (String)"store_time", (Object)now.minusSeconds(100L));
            String secondProxyId = "proxy-2";
            DocNode secondProxy = DocNode.of((String)"uri", (Object)"http://localhost:2", (String)"name", (Object)"proxy-2", (String)"store_time", (Object)now);
            String thirdProxyId = "proxy-3";
            DocNode thirdProxy = DocNode.of((String)"uri", (Object)"http://localhost:3", (String)"name", (Object)"proxy-3", (String)"store_time", (Object)now.plusSeconds(100L));
            this.saveProxy(firstProxyId, firstProxy);
            this.saveProxy(secondProxyId, secondProxy);
            this.saveProxy(thirdProxyId, thirdProxy);
            GenericRestClient.HttpResponse response = client.get("/_signals/proxies/", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.data", (int)3));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data[0].id", (Object)thirdProxyId));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data[1].id", (Object)secondProxyId));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data[2].id", (Object)firstProxyId));
        }
    }

    @Test
    public void httpProxyHostRegistry_shouldBeNotifiedAboutProxyCreationUpdateAndDeletion() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            Optional secondProxyHost;
            Optional firstProxyHost;
            String firstProxyId = "proxy-1";
            DocNode firstProxy = DocNode.of((String)"uri", (Object)"http://localhost:1", (String)"name", (Object)"proxy-1");
            String secondProxyId = "proxy-2";
            DocNode secondProxy = DocNode.of((String)"uri", (Object)"http://localhost:2", (String)"name", (Object)"proxy-2");
            for (HttpProxyHostRegistry httpProxyHostRegistry : nodesHttpProxyHostRegistries) {
                firstProxyHost = httpProxyHostRegistry.findHttpProxyHost(firstProxyId);
                secondProxyHost = httpProxyHostRegistry.findHttpProxyHost(secondProxyId);
                MatcherAssert.assertThat((Object)firstProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)false));
                MatcherAssert.assertThat((Object)secondProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)false));
            }
            this.saveProxyWithProxyApi(firstProxyId, firstProxy);
            this.saveProxyWithProxyApi(secondProxyId, secondProxy);
            for (HttpProxyHostRegistry httpProxyHostRegistry : nodesHttpProxyHostRegistries) {
                firstProxyHost = httpProxyHostRegistry.findHttpProxyHost(firstProxyId);
                secondProxyHost = httpProxyHostRegistry.findHttpProxyHost(secondProxyId);
                MatcherAssert.assertThat((Object)firstProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)true));
                MatcherAssert.assertThat((Object)secondProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)true));
                MatcherAssert.assertThat((Object)((HttpHost)firstProxyHost.get()).toURI(), (Matcher)Matchers.equalTo((Object)firstProxy.getAsString("uri")));
                MatcherAssert.assertThat((Object)((HttpHost)secondProxyHost.get()).toURI(), (Matcher)Matchers.equalTo((Object)secondProxy.getAsString("uri")));
            }
            secondProxy = secondProxy.with("uri", (Object)"http://new-uri:123");
            this.saveProxyWithProxyApi(secondProxyId, secondProxy);
            for (HttpProxyHostRegistry httpProxyHostRegistry : nodesHttpProxyHostRegistries) {
                firstProxyHost = httpProxyHostRegistry.findHttpProxyHost(firstProxyId);
                secondProxyHost = httpProxyHostRegistry.findHttpProxyHost(secondProxyId);
                MatcherAssert.assertThat((Object)firstProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)true));
                MatcherAssert.assertThat((Object)secondProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)true));
                MatcherAssert.assertThat((Object)((HttpHost)firstProxyHost.get()).toURI(), (Matcher)Matchers.equalTo((Object)firstProxy.getAsString("uri")));
                MatcherAssert.assertThat((Object)((HttpHost)secondProxyHost.get()).toURI(), (Matcher)Matchers.equalTo((Object)secondProxy.getAsString("uri")));
            }
            GenericRestClient.HttpResponse response = client.delete("/_signals/proxies/" + firstProxyId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            for (HttpProxyHostRegistry httpProxyHostRegistry : nodesHttpProxyHostRegistries) {
                firstProxyHost = httpProxyHostRegistry.findHttpProxyHost(firstProxyId);
                secondProxyHost = httpProxyHostRegistry.findHttpProxyHost(secondProxyId);
                MatcherAssert.assertThat((Object)firstProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)false));
                MatcherAssert.assertThat((Object)secondProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)true));
            }
        }
    }

    @Test
    public void httpProxyHostRegistry_shouldLoadAllProxiesOnStartup() throws Exception {
        String firstProxyId = "proxy-1";
        DocNode firstProxy = DocNode.of((String)"uri", (Object)"http://localhost:1", (String)"name", (Object)"proxy-1");
        String secondProxyId = "proxy-2";
        DocNode secondProxy = DocNode.of((String)"uri", (Object)"http://localhost:2", (String)"name", (Object)"proxy-2");
        this.saveProxyWithProxyApi(firstProxyId, firstProxy);
        this.saveProxyWithProxyApi(secondProxyId, secondProxy);
        PrivilegedConfigClient client = PrivilegedConfigClient.adapt((Client)cluster.getInternalNodeClient());
        Signals signals = (Signals)cluster.getInjectable(Signals.class);
        MatcherAssert.assertThat((Object)signals, (Matcher)Matchers.notNullValue());
        ProxyCrudService proxyCrudService = new ProxyCrudService(new ProxyRepository(signals.getSignalsSettings(), client));
        HttpProxyHostRegistry httpProxyHostRegistry = new HttpProxyHostRegistry(proxyCrudService);
        httpProxyHostRegistry.reloadAll();
        Optional firstProxyHost = httpProxyHostRegistry.findHttpProxyHost(firstProxyId);
        Optional secondProxyHost = httpProxyHostRegistry.findHttpProxyHost(secondProxyId);
        MatcherAssert.assertThat((Object)firstProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)secondProxyHost.isPresent(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotAccessProxiesIndexDirectly() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);
             GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            String firstProxyId = "proxy-1";
            DocNode firstProxy = DocNode.of((String)"uri", (Object)"http://localhost:1", (String)"name", (Object)"proxy-1");
            String secondProxyId = "proxy-2";
            DocNode secondProxy = DocNode.of((String)"uri", (Object)"http://localhost:2", (String)"name", (Object)"proxy-2");
            this.saveProxyWithProxyApi(firstProxyId, firstProxy);
            this.saveProxyWithProxyApi(secondProxyId, secondProxy);
            GenericRestClient.HttpResponse response = client.get("/_signals/proxies", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data", (int)2));
            response = client.get("/.signals_proxies/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
            response = adminCertClient.get("/.signals_proxies/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"hits.total.value", (Object)2));
        }
    }

    private void saveProxyWithProxyApi(String proxyId, DocNode proxy) throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.putJson("/_signals/proxies/" + proxyId, (Document)proxy);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    private List<DocNode> saveRandomProxies(int noOfProxiesToSave) {
        BulkRequest bulkRequest = new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ArrayList<DocNode> proxies = new ArrayList<DocNode>();
        IntStream.range(0, noOfProxiesToSave).forEach(proxyNo -> {
            String id = "proxy-" + proxyNo;
            String name = "name-" + proxyNo;
            DocNode proxy = DocNode.of((String)"uri", (Object)("http://localhost:" + proxyNo), (String)"name", (Object)name, (String)"store_time", (Object)Instant.now().minusSeconds(proxyNo));
            bulkRequest.add(new IndexRequest(SIGNALS_PROXIES_INDEX_NAME).id(id).source((Map)proxy));
            proxies.add(proxy.with("id", (Object)id).without(new String[]{"store_time"}));
        });
        Client client = cluster.getInternalNodeClient();
        BulkResponse bulkResponse = (BulkResponse)client.bulk(bulkRequest).actionGet();
        MatcherAssert.assertThat((Object)bulkResponse.hasFailures(), (Matcher)Matchers.equalTo((Object)false));
        return proxies;
    }

    private void saveProxy(String id, DocNode proxy) {
        Client client = cluster.getInternalNodeClient();
        IndexRequest indexRequest = ((IndexRequest)new IndexRequest(SIGNALS_PROXIES_INDEX_NAME).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(id).source((Map)proxy);
        DocWriteResponse response = (DocWriteResponse)client.index(indexRequest).actionGet();
        MatcherAssert.assertThat((Object)response.getResult(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)DocWriteResponse.Result.CREATED), (Matcher)Matchers.equalTo((Object)DocWriteResponse.Result.UPDATED)));
    }

    static {
        cluster = new LocalCluster.Builder().clusterConfiguration(ClusterConfiguration.DEFAULT).sslEnabled().user(ADMIN_USER).enableModule(SignalsModule.class).nodeSettings(new Object[]{"signals.enabled", true}).waitForComponents(new String[]{"signals"}).embedded().build();
    }
}

