/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.rest;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class TruststoreLoader {
    private static final Logger log = LogManager.getLogger(TruststoreLoader.class);
    public static final String PEM_THREE_CERTIFICATES = "certs/threeCerts.pem";
    public static final String PEM_TWO_CERTIFICATES = "certs/twoCerts.pem";
    public static final String PEM_ONE_CERTIFICATES = "certs/oneCert.pem";
    public static final String CERT_1_ISSUER = "CN=root.ca.number-0.com,OU=SearchGuard,O=index-0";
    public static final String CERT_1_SUBJECT = "CN=root.ca.number-0.com,OU=SearchGuard,O=index-0";
    public static final String CERT_2_ISSUER = "CN=root.ca.number-1.com,OU=SearchGuard,O=index-1";
    public static final String CERT_2_SUBJECT = "CN=root.ca.number-1.com,OU=SearchGuard,O=index-1";
    public static final String CERT_3_ISSUER = "CN=root.ca.number-2.com,OU=SearchGuard,O=index-2";
    public static final String CERT_3_SUBJECT = "CN=root.ca.number-2.com,OU=SearchGuard,O=index-2";
    public static final String CERT_4_ISSUER = "CN=root.ca.number-0.com,OU=SearchGuard,O=index-0";
    public static final String CERT_4_SUBJECT = "CN=root.ca.number-0.com,OU=SearchGuard,O=index-0";
    public static final String NAME_TRUST_STORE = "my PKI";

    public static String loadCertificates(String resourcePath) {
        String string;
        block8: {
            InputStream inputStream = TruststoreLoader.class.getClassLoader().getResourceAsStream(resourcePath);
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot load resource " + resourcePath, e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String storeTruststore(GenericRestClient client, String truststoreId, String certificatePath) throws Exception {
        return TruststoreLoader.storeTruststore(client, truststoreId, certificatePath, NAME_TRUST_STORE);
    }

    public static String storeTruststore(GenericRestClient client, String truststoreId, String certificatePath, String nameOfTruststore) throws Exception {
        String pem = TruststoreLoader.loadCertificates(certificatePath);
        return TruststoreLoader.storeTruststoreInPemFormat(client, truststoreId, nameOfTruststore, pem);
    }

    public static String storeTruststoreInPemFormat(GenericRestClient client, String truststoreId, String nameOfTruststore, String pem) throws Exception {
        String requestBodyString = DocNode.of((String)"name", (Object)nameOfTruststore, (String)"pem", (Object)pem).toJsonString();
        GenericRestClient.HttpResponse response = client.putJson("/_signals/truststores/" + truststoreId, requestBodyString, new Header[0]);
        log.info("Trust store '{}' upload response contain status code '{}' and body '{}'.", (Object)truststoreId, (Object)response.getStatusCode(), (Object)response.getBody());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        return pem;
    }

    public static int deleteTruststoreById(GenericRestClient client, String truststoreId) throws Exception {
        GenericRestClient.HttpResponse response = client.delete("/_signals/truststores/" + truststoreId, new Header[0]);
        return response.getStatusCode();
    }
}

