/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.support;

import com.floragunn.codova.validation.errors.ValidationError;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.script.ScriptException;

public class ScriptExecutionError
extends ValidationError {
    private String context;

    public ScriptExecutionError(String attribute, ScriptException scriptException) {
        super(attribute, ScriptExecutionError.getMessage(scriptException));
        this.cause(scriptException);
        if (scriptException.getScriptStack() != null && scriptException.getScriptStack().size() > 0) {
            this.context = Strings.join((Iterable)scriptException.getScriptStack(), (char)'\n');
        }
    }

    public Map<String, Object> toBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("error", this.getMessage());
        if (this.context != null) {
            result.put("context", this.context);
        }
        return result;
    }

    private static String getMessage(ScriptException scriptException) {
        if ("runtime error".equals(scriptException.getMessage())) {
            if (scriptException.getCause() != null) {
                return ScriptExecutionError.constructMessage(scriptException.getCause());
            }
            return "Runtime Error";
        }
        return ScriptExecutionError.constructMessage(scriptException);
    }

    private static String constructMessage(Throwable throwable) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            String message = throwable.getMessage();
            if (message == null) {
                message = throwable.toString();
            }
            if (result.indexOf(message) == -1) {
                if (result.length() != 0) {
                    result.append(":\n");
                }
                result.append(message);
            }
            if (throwable.getCause() == throwable || throwable.getCause() == null) break;
            throwable = throwable.getCause();
        }
        return result.toString();
    }
}

