/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.service;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.signals.truststore.rest.CertificateRepresentation;
import com.floragunn.signals.truststore.rest.CreateOrReplaceTruststoreAction;
import com.floragunn.signals.truststore.rest.TruststoreLoader;
import com.floragunn.signals.truststore.service.CertificateParser;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CertificateParserTest {
    @Mock
    private UnparsedDocument<?> unparsedDocument;

    @Test
    public void shouldParseSingleCertificate() throws ConfigValidationException {
        CertificateParser certificateParser = new CertificateParser();
        String certificateInPemFormat = TruststoreLoader.loadCertificates("certs/oneCert.pem");
        ImmutableList certificateRepresentations = certificateParser.parse(Collections.singletonList(certificateInPemFormat));
        MatcherAssert.assertThat((Object)certificateRepresentations, (Matcher)Matchers.hasSize((int)1));
        CertificateRepresentation certificate = (CertificateRepresentation)certificateRepresentations.get(0);
        MatcherAssert.assertThat((Object)certificate.getPem(), (Matcher)Matchers.equalTo((Object)certificateInPemFormat));
        MatcherAssert.assertThat((Object)certificate.getSerialNumber(), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)certificate.getIssuer(), (Matcher)Matchers.equalTo((Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
        MatcherAssert.assertThat((Object)certificate.getSubject(), (Matcher)Matchers.equalTo((Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
        Instant notBefore = ZonedDateTime.of(LocalDateTime.of(2023, 5, 18, 15, 43, 30), ZoneOffset.UTC).toInstant();
        MatcherAssert.assertThat((Object)certificate.getNotBefore(), (Matcher)Matchers.equalTo((Object)notBefore));
        Instant notAfter = ZonedDateTime.of(LocalDateTime.of(2023, 6, 17, 15, 43, 30), ZoneOffset.UTC).toInstant();
        MatcherAssert.assertThat((Object)certificate.getNotAfter(), (Matcher)Matchers.equalTo((Object)notAfter));
    }

    @Test
    public void shouldParseMultipleCertificates() throws ConfigValidationException {
        String certificateInPemFormat = TruststoreLoader.loadCertificates("certs/twoCerts.pem");
        DocNode docNode = DocNode.of((String)"name", (Object)"name", (String)"pem", (Object)certificateInPemFormat);
        Mockito.when((Object)this.unparsedDocument.parseAsDocNode()).thenReturn((Object)docNode);
        CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest uploadCertificatesRequest = new CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest("cert-id-1", this.unparsedDocument);
        List splitCertificates = uploadCertificatesRequest.getCertificates();
        CertificateParser certificateParser = new CertificateParser();
        ImmutableList certificateRepresentations = certificateParser.parse((Collection)splitCertificates);
        MatcherAssert.assertThat((Object)certificateRepresentations, (Matcher)Matchers.hasSize((int)2));
        CertificateRepresentation certificate = (CertificateRepresentation)certificateRepresentations.get(0);
        MatcherAssert.assertThat((Object)certificate.getPem(), (Matcher)Matchers.equalTo((Object)((String)splitCertificates.get(0))));
        MatcherAssert.assertThat((Object)certificate.getSerialNumber(), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)certificate.getIssuer(), (Matcher)Matchers.equalTo((Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
        MatcherAssert.assertThat((Object)certificate.getSubject(), (Matcher)Matchers.equalTo((Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
        Instant notBefore = ZonedDateTime.of(LocalDateTime.of(2023, 5, 18, 15, 43, 30), ZoneOffset.UTC).toInstant();
        MatcherAssert.assertThat((Object)certificate.getNotBefore(), (Matcher)Matchers.equalTo((Object)notBefore));
        Instant notAfter = ZonedDateTime.of(LocalDateTime.of(2023, 6, 17, 15, 43, 30), ZoneOffset.UTC).toInstant();
        MatcherAssert.assertThat((Object)certificate.getNotAfter(), (Matcher)Matchers.equalTo((Object)notAfter));
    }

    @Test(expected=ConfigValidationException.class)
    public void shouldNotParseCertificate() throws ConfigValidationException {
        CertificateParser certificateParser = new CertificateParser();
        String pem = "-----BEGIN CERTIFICATE-----iaminvalidcertificate-----END CERTIFICATE-----";
        List<String> splitCertificates = Collections.singletonList(pem);
        certificateParser.parse(splitCertificates);
    }
}

