/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.service;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificate;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.signals.CertificatesParser;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.truststore.rest.TruststoreLoader;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.truststore.service.TruststoreCrudService;
import com.floragunn.signals.truststore.service.persistence.TruststoreRepository;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.search.SearchHit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class TrustManagerRegistryTest {
    private static final TestSgConfig.User USER_ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS});
    public static final String TRUSTSTORE_ID_1 = "truststore-id-one";
    public static final String TRUSTSTORE_ID_2 = "truststore-id-two";
    public static final String TRUSTSTORE_ID_3 = "truststore-id-three";
    public static final String TEST_CERTIFICATE_ALGORITHM = "SHA256withRSA";
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().clusterConfiguration(ClusterConfiguration.DEFAULT).sslEnabled().enableModule(SignalsModule.class).nodeSettings(new Object[]{"signals.enabled", true}).user(USER_ADMIN).embedded().build();
    private TrustManagerRegistry trustManagerRegistryMaster;
    private TrustManagerRegistry trustManagerRegistryDataOne;
    private TrustManagerRegistry trustManagerRegistryDataTwo;

    @Before
    public void retrieveServicesFromEachNode() {
        this.trustManagerRegistryMaster = ((Signals)cluster.getInjectable(Signals.class)).getTruststoreRegistry();
        List trustManagers = cluster.nodes().stream().filter(node -> !node.esNode().isMasterEligible()).map(node -> (Signals)node.getInjectable(Signals.class)).map(Signals::getTruststoreRegistry).collect(Collectors.toList());
        MatcherAssert.assertThat(trustManagers, (Matcher)Matchers.hasSize((int)2));
        this.trustManagerRegistryDataOne = (TrustManagerRegistry)trustManagers.get(0);
        this.trustManagerRegistryDataTwo = (TrustManagerRegistry)trustManagers.get(1);
        MatcherAssert.assertThat((Object)this.trustManagerRegistryMaster, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.trustManagerRegistryDataOne, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.trustManagerRegistryDataTwo, (Matcher)Matchers.notNullValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void clearData() throws Exception {
        Client client = cluster.getPrivilegedInternalNodeClient();
        SearchResponse searchResponse = (SearchResponse)client.search(new SearchRequest(new String[]{".signals_truststores"})).actionGet();
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                String id = hit.getId();
                TruststoreLoader.deleteTruststoreById(restClient, id);
            }
        }
        finally {
            searchResponse.decRef();
        }
    }

    @Test
    public void shouldNotFindTruststoreOnEachNodes() {
        Optional trustManagerMaster = this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1);
        Optional trustManagerOne = this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1);
        Optional trustManagerTwo = this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1);
        MatcherAssert.assertThat((Object)trustManagerMaster.isPresent(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)trustManagerOne.isPresent(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)trustManagerTwo.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldTrustCertificateOnEachNode() throws Exception {
        TestCertificates caOne = TestCertificates.builder().ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard").addClients(new String[]{"CN=client-0.example.com,OU=SearchGuard,O=SearchGuard"}).build();
        String rootCaPem = caOne.getCaCertificate().getCertificateString();
        TestCertificate clientCertificate = (TestCertificate)caOne.getClientsCertificates().get(0);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_1, "ca-cert", rootCaPem);
        }
        X509TrustManager trustManagerMaster = (X509TrustManager)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataOne = (X509TrustManager)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataTwo = (X509TrustManager)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1).get();
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertificate), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertificate), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertificate), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotTrustCertificateIfTrustAnchorWasNotUploadedOnEachNode() throws Exception {
        TestCertificates caOne = TestCertificates.builder().ca("CN=root.ca.one.com,OU=SearchGuard,O=SearchGuard").build();
        TestCertificates caTwo = TestCertificates.builder().ca("CN=root.ca.two.com,OU=SearchGuard,O=SearchGuard").addClients(new String[]{"CN=client-0.two.com,OU=SearchGuard,O=SearchGuard"}).build();
        String rootCaPem = caOne.getCaCertificate().getCertificateString();
        TestCertificate clientCertificate = (TestCertificate)caTwo.getClientsCertificates().get(0);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_1, "ca-cert", rootCaPem);
        }
        X509TrustManager trustManagerMaster = (X509TrustManager)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataOne = (X509TrustManager)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataTwo = (X509TrustManager)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1).get();
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertificate), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertificate), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertificate), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldTrustThreeCasOnEachNode() throws Exception {
        TestCertificates caOne = TestCertificates.builder().ca("CN=root.ca.one.com,OU=SearchGuard,O=One").addClients(new String[]{"CN=client-0.one.com,OU=SearchGuard,O=One"}).build();
        TestCertificates caTwo = TestCertificates.builder().ca("CN=root.ca.two.com,OU=SearchGuard,O=Two").addClients(new String[]{"CN=client-0.two.com,OU=SearchGuard,O=Two"}).build();
        TestCertificates caThree = TestCertificates.builder().ca("CN=root.ca.three.com,OU=SearchGuard,O=Three").addClients(new String[]{"CN=client-0.three.com,OU=SearchGuard,O=Three"}).build();
        String trustAnchorOne = caOne.getCaCertificate().getCertificateString();
        String trustAnchorTwo = caTwo.getCaCertificate().getCertificateString();
        String trustAnchorThree = caThree.getCaCertificate().getCertificateString();
        String caCertificates = trustAnchorOne + trustAnchorTwo + trustAnchorThree;
        TestCertificate clientCertOne = (TestCertificate)caOne.getClientsCertificates().get(0);
        TestCertificate clientCertTwo = (TestCertificate)caTwo.getClientsCertificates().get(0);
        TestCertificate clientCertThree = (TestCertificate)caThree.getClientsCertificates().get(0);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_1, "ca-cert", caCertificates);
        }
        X509TrustManager trustManagerMaster = (X509TrustManager)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataOne = (X509TrustManager)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataTwo = (X509TrustManager)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1).get();
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertTwo), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertTwo), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertTwo), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldStopTrustCaCertificateWhenCaIsExcludedFromTruststoreEachNode() throws Exception {
        TestCertificates caOne = TestCertificates.builder().ca("CN=root.ca.one.com,OU=SearchGuard,O=One").addClients(new String[]{"CN=client-0.one.com,OU=SearchGuard,O=One"}).build();
        TestCertificates caTwo = TestCertificates.builder().ca("CN=root.ca.two.com,OU=SearchGuard,O=Two").addClients(new String[]{"CN=client-0.two.com,OU=SearchGuard,O=Two"}).build();
        TestCertificates caThree = TestCertificates.builder().ca("CN=root.ca.three.com,OU=SearchGuard,O=Three").addClients(new String[]{"CN=client-0.three.com,OU=SearchGuard,O=Three"}).build();
        String trustAnchorOne = caOne.getCaCertificate().getCertificateString();
        String trustAnchorTwo = caTwo.getCaCertificate().getCertificateString();
        String trustAnchorThree = caThree.getCaCertificate().getCertificateString();
        String caCertificates = trustAnchorOne + trustAnchorTwo + trustAnchorThree;
        TestCertificate clientCertOne = (TestCertificate)caOne.getClientsCertificates().get(0);
        TestCertificate clientCertTwo = (TestCertificate)caTwo.getClientsCertificates().get(0);
        TestCertificate clientCertThree = (TestCertificate)caThree.getClientsCertificates().get(0);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_1, "ca-cert", caCertificates);
        }
        X509TrustManager trustManagerMaster = (X509TrustManager)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataOne = (X509TrustManager)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataTwo = (X509TrustManager)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1).get();
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertTwo), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertTwo), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertTwo), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
        caCertificates = trustAnchorOne + trustAnchorThree;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_1, "ca-cert", caCertificates);
        }
        trustManagerMaster = (X509TrustManager)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1).get();
        trustManagerDataOne = (X509TrustManager)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1).get();
        trustManagerDataTwo = (X509TrustManager)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1).get();
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertTwo), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertTwo), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertTwo), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotFindTrustManagerAfterTruststoreDeletionOnEachNodes() throws Exception {
        TestCertificates caOne = TestCertificates.builder().ca("CN=root.ca.one.com,OU=SearchGuard,O=One").addClients(new String[]{"CN=client-0.one.com,OU=SearchGuard,O=One"}).build();
        String trustAnchorOne = caOne.getCaCertificate().getCertificateString();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_1, "ca-cert", trustAnchorOne);
            MatcherAssert.assertThat((Object)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1).isPresent(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1).isPresent(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1).isPresent(), (Matcher)Matchers.equalTo((Object)true));
            TruststoreLoader.deleteTruststoreById(client, TRUSTSTORE_ID_1);
            MatcherAssert.assertThat((Object)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1).isPresent(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1).isPresent(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1).isPresent(), (Matcher)Matchers.equalTo((Object)false));
        }
    }

    @Test
    public void shouldCreateVariousTrustManagerForEachTruststore() throws Exception {
        TestCertificates caOne = TestCertificates.builder().ca("CN=root.ca.one.com,OU=SearchGuard,O=One").addClients(new String[]{"CN=client-0.one.com,OU=SearchGuard,O=One"}).build();
        TestCertificates caTwo = TestCertificates.builder().ca("CN=root.ca.two.com,OU=SearchGuard,O=Two").addClients(new String[]{"CN=client-0.two.com,OU=SearchGuard,O=Two"}).build();
        TestCertificates caThree = TestCertificates.builder().ca("CN=root.ca.three.com,OU=SearchGuard,O=Three").addClients(new String[]{"CN=client-0.three.com,OU=SearchGuard,O=Three"}).build();
        String trustAnchorOne = caOne.getCaCertificate().getCertificateString();
        String trustAnchorTwo = caTwo.getCaCertificate().getCertificateString();
        String trustAnchorThree = caThree.getCaCertificate().getCertificateString();
        TestCertificate clientCertOne = (TestCertificate)caOne.getClientsCertificates().get(0);
        TestCertificate clientCertTwo = (TestCertificate)caTwo.getClientsCertificates().get(0);
        TestCertificate clientCertThree = (TestCertificate)caThree.getClientsCertificates().get(0);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_1, "ca-cert-one", trustAnchorOne);
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_2, "ca-cert-two", trustAnchorTwo);
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_3, "ca-cert-three", trustAnchorThree);
        }
        X509TrustManager trustManagerMaster = (X509TrustManager)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataOne = (X509TrustManager)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataTwo = (X509TrustManager)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1).get();
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertTwo), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertTwo), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertTwo), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertThree), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertThree), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertThree), (Matcher)Matchers.equalTo((Object)false));
        trustManagerMaster = (X509TrustManager)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_2).get();
        trustManagerDataOne = (X509TrustManager)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_2).get();
        trustManagerDataTwo = (X509TrustManager)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_2).get();
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertOne), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertOne), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertOne), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertTwo), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertTwo), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertTwo), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertThree), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertThree), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertThree), (Matcher)Matchers.equalTo((Object)false));
        trustManagerMaster = (X509TrustManager)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_3).get();
        trustManagerDataOne = (X509TrustManager)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_3).get();
        trustManagerDataTwo = (X509TrustManager)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_3).get();
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertOne), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertOne), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertOne), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertTwo), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertTwo), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertTwo), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, clientCertThree), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldTrustTensOfCas() throws Exception {
        List cas = IntStream.range(0, 12).mapToObj(index -> TestCertificates.builder().ca(String.format("CN=root.ca.number-%d.com,OU=SearchGuard,O=index-%d", index, index)).addClients(new String[]{String.format("CN=client-0.number-%d.com,OU=SearchGuard,O=index-%d", index, index)}).build()).collect(Collectors.toList());
        String truststore = cas.stream().map(testCertificates -> testCertificates.getCaCertificate().getCertificateString()).collect(Collectors.joining());
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_1, "ca-certs", truststore);
        }
        X509TrustManager trustManagerMaster = (X509TrustManager)this.trustManagerRegistryMaster.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataOne = (X509TrustManager)this.trustManagerRegistryDataOne.findTrustManager(TRUSTSTORE_ID_1).get();
        X509TrustManager trustManagerDataTwo = (X509TrustManager)this.trustManagerRegistryDataTwo.findTrustManager(TRUSTSTORE_ID_1).get();
        cas.stream().map(testCertificates -> (TestCertificate)testCertificates.getClientsCertificates().get(0)).forEach(clientCert -> {
            MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerMaster, (TestCertificate)clientCert), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataOne, (TestCertificate)clientCert), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)this.isCertificateTrusted(trustManagerDataTwo, (TestCertificate)clientCert), (Matcher)Matchers.equalTo((Object)true));
        });
    }

    @Test
    public void shouldLoadCertificateOnStartUp() throws Exception {
        TestCertificates caOne = TestCertificates.builder().ca("CN=root.ca.one.com,OU=SearchGuard,O=One").addClients(new String[]{"CN=client-0.one.com,OU=SearchGuard,O=One"}).build();
        TestCertificate clientCertOne = (TestCertificate)caOne.getClientsCertificates().get(0);
        String trustAnchorOne = caOne.getCaCertificate().getCertificateString();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(client, TRUSTSTORE_ID_1, "ca-cert-one", trustAnchorOne);
        }
        client = PrivilegedConfigClient.adapt((Client)((Client)cluster.getInjectable(NodeClient.class)));
        Signals signals = (Signals)cluster.getInjectable(Signals.class);
        TruststoreCrudService truststoreCrudService = new TruststoreCrudService(new TruststoreRepository(signals.getSignalsSettings(), (PrivilegedConfigClient)client));
        TrustManagerRegistry trustManagerRegistry = new TrustManagerRegistry(truststoreCrudService);
        trustManagerRegistry.reloadAll();
        X509TrustManager x509TrustManager = (X509TrustManager)trustManagerRegistry.findTrustManager(TRUSTSTORE_ID_1).get();
        MatcherAssert.assertThat((Object)this.isCertificateTrusted(x509TrustManager, clientCertOne), (Matcher)Matchers.equalTo((Object)true));
    }

    private boolean isCertificateTrusted(X509TrustManager trustManager, TestCertificate certificates) {
        try {
            X509Certificate[] javaCertificate = this.toJavaCertificate(certificates);
            trustManager.checkClientTrusted(javaCertificate, TEST_CERTIFICATE_ALGORITHM);
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    private X509Certificate[] toJavaCertificate(TestCertificate testCertificate) {
        String pemCertificate = testCertificate.getCertificateString();
        try {
            return (X509Certificate[])CertificatesParser.parseCertificates((String)pemCertificate).stream().map(X509Certificate.class::cast).toArray(X509Certificate[]::new);
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException("Cannot parse test certificate", e);
        }
    }
}

