/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.signals.watch.common.RejectAllTrustManager;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RejectAllTrustManagerTest {
    public static final String AUTH_TYPE = "auth-type";
    @Mock
    private Socket socket;
    @Mock
    private SSLEngine engine;
    @Mock
    private X509Certificate certificate;
    private RejectAllTrustManager trustManager;

    @Before
    public void before() {
        this.trustManager = new RejectAllTrustManager("missing truststore id");
    }

    @Test
    public void shouldNotTrustServerCertificates() {
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkServerTrusted(new X509Certificate[]{this.certificate}, AUTH_TYPE), (Matcher[])new Matcher[]{Matchers.instanceOf(CertificateException.class)});
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkServerTrusted(new X509Certificate[1], AUTH_TYPE, this.socket), (Matcher[])new Matcher[]{Matchers.instanceOf(CertificateException.class)});
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkServerTrusted(new X509Certificate[1], AUTH_TYPE, this.engine), (Matcher[])new Matcher[]{Matchers.instanceOf(CertificateException.class)});
    }

    @Test
    public void shouldNotTrustClientCertificates() {
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkClientTrusted(new X509Certificate[]{this.certificate}, AUTH_TYPE), (Matcher[])new Matcher[]{Matchers.instanceOf(CertificateException.class)});
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkClientTrusted(new X509Certificate[1], AUTH_TYPE, this.socket), (Matcher[])new Matcher[]{Matchers.instanceOf(CertificateException.class)});
        ThrowableAssert.assertThatThrown(() -> this.trustManager.checkClientTrusted(new X509Certificate[1], AUTH_TYPE, this.engine), (Matcher[])new Matcher[]{Matchers.instanceOf(CertificateException.class)});
    }

    @Test
    public void shouldReturnEmptyAcceptedIssuer() {
        X509Certificate[] acceptedIssuers = this.trustManager.getAcceptedIssuers();
        MatcherAssert.assertThat((Object)acceptedIssuers, (Matcher)Matchers.arrayWithSize((int)0));
    }
}

