/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.signals.actions.summary.WatchActionNames;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;

class WatchRepository {
    private final String watchIndexName;
    private final PrivilegedConfigClient privilegedConfigClient;

    WatchRepository(String watchIndexName, PrivilegedConfigClient privilegedConfigClient) {
        this.watchIndexName = Objects.requireNonNull(watchIndexName);
        this.privilegedConfigClient = Objects.requireNonNull(privilegedConfigClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WatchActionNames> searchWatchIdsWithSeverityAndIdPrefix(String tenant, String namePrefix, int size) {
        Objects.requireNonNull(tenant, "tenant is required");
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.size(size);
        sourceBuilder.fetchSource(new String[]{"active", "actions.name"}, new String[0]);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)WatchRepository.tenantIs(tenant)).filter(WatchRepository.withNamePrefix(namePrefix)).filter((QueryBuilder)WatchRepository.severityLevelExistsQuery());
        sourceBuilder.query((QueryBuilder)boolQuery);
        SearchRequest request = new SearchRequest(new String[]{this.watchIndexName}).source(sourceBuilder);
        SearchResponse searchResponse = (SearchResponse)this.privilegedConfigClient.search(request).actionGet();
        try {
            List<WatchActionNames> list = Arrays.stream(searchResponse.getHits().getHits()).map(this::convertHitToWatchActionNames).toList();
            return list;
        }
        finally {
            searchResponse.decRef();
        }
    }

    private WatchActionNames convertHitToWatchActionNames(SearchHit hit) {
        String watchId = hit.getId();
        DocNode documentSources = DocNode.wrap((Object)hit.getSourceAsMap());
        ImmutableList actions = documentSources.getAsListOfNodes("actions");
        Boolean active = WatchRepository.isWatchActive(documentSources);
        if (actions == null || actions.isEmpty()) {
            return new WatchActionNames(watchId, (List<String>)ImmutableList.empty(), active);
        }
        List<String> actionNames = actions.stream().map(docNode -> docNode.getAsString("name")).filter(Objects::nonNull).toList();
        return new WatchActionNames(watchId, actionNames, active);
    }

    private static Boolean isWatchActive(DocNode documentSources) {
        try {
            Boolean active = documentSources.getBoolean("active");
            return active == null ? true : active;
        }
        catch (ConfigValidationException e) {
            return null;
        }
    }

    @NotNull
    private static AbstractQueryBuilder<?> withNamePrefix(String namePrefix) {
        if (namePrefix == null || namePrefix.isEmpty()) {
            return QueryBuilders.matchAllQuery();
        }
        return QueryBuilders.prefixQuery((String)"_name", (String)namePrefix.toLowerCase());
    }

    @NotNull
    private static TermQueryBuilder tenantIs(String tenant) {
        return QueryBuilders.termQuery((String)"_tenant", (String)tenant);
    }

    @NotNull
    private static ExistsQueryBuilder severityLevelExistsQuery() {
        return QueryBuilders.existsQuery((String)"severity.mapping.level");
    }
}

