/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.proxy.rest;

import com.floragunn.signals.Signals;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportProxyUpdatedAction
extends TransportNodesAction<ProxyUpdatedRequest, ProxyUpdatedResponse, NodeRequest, NodeResponse, Void> {
    private static final Logger log = LogManager.getLogger(TransportProxyUpdatedAction.class);
    private final HttpProxyHostRegistry httpProxyHostRegistry;

    @Inject
    public TransportProxyUpdatedAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Signals signals) {
        super("cluster:admin:searchguard:signals:proxies/update", clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
        this.httpProxyHostRegistry = Objects.requireNonNull(signals.getHttpProxyHostRegistry(), "Http proxy host registry is required");
    }

    protected ProxyUpdatedResponse newResponse(ProxyUpdatedRequest request, List<NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new ProxyUpdatedResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected NodeRequest newNodeRequest(ProxyUpdatedRequest request) {
        return new NodeRequest(request);
    }

    protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeResponse(in);
    }

    protected NodeResponse nodeOperation(NodeRequest request, Task task) {
        DiscoveryNode localNode = this.clusterService.localNode();
        log.info("Local node '{}' received notification about proxy update '{}'.", (Object)localNode.getName(), (Object)request);
        String proxyId = request.getProxyId();
        try {
            this.httpProxyHostRegistry.onProxyUpdate(proxyId, request.getOperationType());
            return new NodeResponse(localNode);
        }
        catch (Exception ex) {
            String message = "Cannot update proxy host for proxy '" + proxyId + "'. ";
            log.error(message, (Throwable)ex);
            return new NodeResponse(localNode, message + ex.getMessage());
        }
    }

    public static class ProxyUpdatedActionType
    extends ActionType<ProxyUpdatedResponse> {
        public static final String NAME = "cluster:admin:searchguard:signals:proxies/update";
        public static final ProxyUpdatedActionType INSTANCE = new ProxyUpdatedActionType();

        protected ProxyUpdatedActionType() {
            super(NAME);
        }

        public static ActionFuture<ProxyUpdatedResponse> send(Client client, String proxyId, String operationType) {
            Objects.requireNonNull(client, "Client is required to send action cluster:admin:searchguard:signals:proxies/update");
            return client.execute((ActionType)INSTANCE, (ActionRequest)new ProxyUpdatedRequest(proxyId, operationType));
        }
    }

    public static class ProxyUpdatedResponse
    extends BaseNodesResponse<NodeResponse> {
        public ProxyUpdatedResponse(StreamInput in) throws IOException {
            super(in);
        }

        public ProxyUpdatedResponse(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        private final String proxyId;
        private final String operationType;

        public NodeRequest(StreamInput streamInput) throws IOException {
            super(streamInput);
            this.proxyId = streamInput.readString();
            this.operationType = streamInput.readString();
        }

        public NodeRequest(ProxyUpdatedRequest request) {
            this.proxyId = request.getProxyId();
            this.operationType = request.getOperationType();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.proxyId);
            out.writeString(this.operationType);
        }

        public String getProxyId() {
            return this.proxyId;
        }

        public String getOperationType() {
            return this.operationType;
        }

        public String toString() {
            return "NodeRequest{proxyId=" + this.proxyId + ", operationType=" + this.operationType + "}";
        }
    }

    public static class ProxyUpdatedRequest
    extends BaseNodesRequest {
        private final String proxyId;
        private final String operationType;

        public ProxyUpdatedRequest(String proxyId, String operationType) {
            super(new String[0]);
            this.proxyId = Objects.requireNonNull(proxyId, "Proxy id is required");
            this.operationType = Objects.requireNonNull(operationType, "Operation type is required");
        }

        public String getProxyId() {
            return this.proxyId;
        }

        public String getOperationType() {
            return this.operationType;
        }

        public String toString() {
            return "ProxyUpdatedRequest{proxyId='" + this.proxyId + "', operationType='" + this.operationType + "'}";
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final boolean success;
        private final String message;

        protected NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.success = in.readBoolean();
            this.message = in.readOptionalString();
        }

        public NodeResponse(DiscoveryNode node) {
            super(node);
            this.success = true;
            this.message = null;
        }

        public NodeResponse(DiscoveryNode node, String errorMessage) {
            super(node);
            this.success = false;
            this.message = errorMessage;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.success);
            out.writeOptionalString(this.message);
        }
    }
}

