/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.proxy.service.persistence;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.client.SearchScroller;
import com.floragunn.signals.proxy.service.persistence.ProxyData;
import com.floragunn.signals.settings.SignalsSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentType;

public class ProxyRepository {
    private final SignalsSettings signalsSettings;
    private final PrivilegedConfigClient client;

    public ProxyRepository(SignalsSettings signalsSettings, PrivilegedConfigClient client) {
        this.signalsSettings = Objects.requireNonNull(signalsSettings, "signals settings is required");
        this.client = Objects.requireNonNull(client, "Node client is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProxyUsedByAnyWatch(String proxyId) {
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"actions.proxy.keyword", (String)proxyId)).should((QueryBuilder)QueryBuilders.termQuery((String)"checks.proxy.keyword", (String)proxyId)).should((QueryBuilder)QueryBuilders.queryStringQuery((String)proxyId).field("actions.attachments.*.proxy.keyword"))));
        SearchRequest searchWatchesRequest = new SearchRequest(new String[]{this.signalsSettings.getStaticSettings().getIndexNames().getWatches()}).source(searchSourceBuilder).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        SearchResponse searchResponse = (SearchResponse)this.client.search(searchWatchesRequest).actionGet();
        try {
            boolean bl = searchResponse.getHits().getTotalHits().value() > 0L;
            return bl;
        }
        finally {
            searchResponse.decRef();
        }
    }

    public DocWriteResponse createOrReplace(ProxyData proxyData) {
        Objects.requireNonNull(proxyData, "Proxy data is required");
        String proxyId = proxyData.getId();
        String json = proxyData.toJsonString();
        IndexRequest storeRequest = ((IndexRequest)new IndexRequest(".signals_proxies").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(proxyId).source(json, XContentType.JSON);
        return (DocWriteResponse)this.client.index(storeRequest).actionGet();
    }

    public Optional<ProxyData> findOneById(String proxyId) {
        Objects.requireNonNull(proxyId, "Proxy id is required");
        GetResponse getResponse = (GetResponse)this.client.get(new GetRequest(".signals_proxies").id(proxyId)).actionGet();
        try {
            return this.getResponseToProxyData(getResponse);
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException("Cannot parse proxy '" + proxyId + "' content stored in an index.", e);
        }
    }

    public Boolean deleteById(String proxyId) {
        Objects.requireNonNull(proxyId, "Proxy id is required");
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".signals_proxies").id(proxyId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        DeleteResponse deleteResponse = (DeleteResponse)this.client.delete(deleteRequest).actionGet();
        return deleteResponse.getResult() == DocWriteResponse.Result.DELETED;
    }

    public List<ProxyData> findAll() {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource().sort("store_time", SortOrder.DESC);
        TimeValue scrollTimeout = new TimeValue(1000L);
        SearchRequest searchRequest = new SearchRequest(new String[]{".signals_proxies"}).source(sourceBuilder);
        SearchScroller searchScroller = new SearchScroller((Client)this.client);
        ArrayList<ProxyData> results = new ArrayList<ProxyData>();
        searchScroller.scroll(searchRequest, scrollTimeout, searchHit -> {
            try {
                return this.searchHitToProxyData((SearchHit)searchHit);
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException("Cannot parse proxy '" + searchHit.getId() + "' content stored in an index.", e);
            }
        }, results::addAll);
        return results;
    }

    private ProxyData searchHitToProxyData(SearchHit searchHit) throws ConfigValidationException {
        return this.jsonToProxyData(searchHit.getId(), searchHit.getSourceAsString());
    }

    private Optional<ProxyData> getResponseToProxyData(GetResponse response) throws ConfigValidationException {
        return response.isExists() ? Optional.of(this.jsonToProxyData(response.getId(), response.getSourceAsString())) : Optional.empty();
    }

    private ProxyData jsonToProxyData(String proxyId, String json) throws ConfigValidationException {
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(json);
        return new ProxyData(proxyId, docNode);
    }
}

