/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.service.persistence;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableMap;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.common.time.DateFormatter;

public class CertificateData
implements Document<CertificateData> {
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);
    public static final String FIELD_SERIAL_NUMBER = "serial_number";
    public static final String FIELD_NOT_BEFORE = "not_before";
    public static final String FIELD_NOT_AFTER = "not_after";
    public static final String FIELD_ISSUER = "issuer";
    public static final String FIELD_SUBJECT = "subject";
    public static final String FIELD_PEM = "pem";
    private final String serialNumber;
    private final Instant notBefore;
    private final Instant notAfter;
    private final String issuer;
    private final String subject;
    private final String pem;

    public CertificateData(String serialNumber, Instant notBefore, Instant notAfter, String issuer, String subject, String pem) {
        this.serialNumber = serialNumber;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.issuer = issuer;
        this.subject = subject;
        this.pem = pem;
    }

    public static CertificateData parse(DocNode docNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode node = new ValidatingDocNode(docNode, validationErrors);
        CertificateData certificateData = new CertificateData(node.get(FIELD_SERIAL_NUMBER).asString(), (Instant)node.get(FIELD_NOT_BEFORE).byString(Instant::parse), (Instant)node.get(FIELD_NOT_AFTER).byString(Instant::parse), node.get(FIELD_ISSUER).asString(), node.get(FIELD_SUBJECT).asString(), node.get(FIELD_PEM).asString());
        validationErrors.throwExceptionForPresentErrors();
        return certificateData;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public Instant getNotBefore() {
        return this.notBefore;
    }

    public Instant getNotAfter() {
        return this.notAfter;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getPem() {
        return this.pem;
    }

    public ImmutableMap<String, Object> toBasicObject() {
        String notBeforeFormatted = this.notBefore != null ? DATE_FORMATTER.format((TemporalAccessor)this.notBefore) : null;
        String notAfterFormatted = this.notBefore != null ? DATE_FORMATTER.format((TemporalAccessor)this.notAfter) : null;
        return ImmutableMap.of((Object)FIELD_SERIAL_NUMBER, (Object)this.serialNumber, (Object)FIELD_NOT_BEFORE, (Object)notBeforeFormatted, (Object)FIELD_NOT_AFTER, (Object)notAfterFormatted, (Object)FIELD_ISSUER, (Object)this.issuer, (Object)FIELD_SUBJECT, (Object)this.subject).with((Object)FIELD_PEM, (Object)this.pem);
    }
}

