/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.codova.documents.DocNode;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class Ack
implements ToXContentObject {
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);
    private final Instant on;
    private final String by;

    public Ack(Instant on, String by) {
        this.on = on;
        this.by = by;
    }

    public Instant getOn() {
        return this.on;
    }

    public String getBy() {
        return this.by;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("on", DATE_FORMATTER.format((TemporalAccessor)this.on));
        if (this.by != null) {
            builder.field("by", this.by);
        }
        builder.endObject();
        return builder;
    }

    public static Ack create(DocNode jsonNode) {
        Instant on = null;
        String by = null;
        if (jsonNode.hasNonNull("on")) {
            on = Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("on")));
        }
        if (jsonNode.hasNonNull("by")) {
            by = jsonNode.getAsString("by");
        }
        return new Ack(on, by);
    }

    public String toString() {
        return "Ack [on=" + String.valueOf(this.on) + ", by=" + this.by + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.by == null ? 0 : this.by.hashCode());
        result = 31 * result + (this.on == null ? 0 : this.on.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ack other = (Ack)obj;
        if (this.by == null ? other.by != null : !this.by.equals(other.by)) {
            return false;
        }
        return !(this.on == null ? other.on != null : !this.on.equals(other.on));
    }
}

