/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.state;

import com.floragunn.signals.watch.state.WatchState;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WatchStateManager {
    private static final Logger log = LogManager.getLogger(WatchStateManager.class);
    private final Map<String, WatchState> watchIdToStateMap = new ConcurrentHashMap<String, WatchState>();
    private final String tenant;
    private final String node;

    public WatchStateManager(String tenant, String node) {
        this.tenant = tenant;
        this.node = node;
    }

    public Map<String, WatchState> reset(Map<String, WatchState> watchIdToStateMap, Set<String> additionalWatchIds) {
        if (log.isDebugEnabled()) {
            log.debug("WatchStateManager.reset(" + String.valueOf(watchIdToStateMap.keySet()) + ", " + String.valueOf(additionalWatchIds) + ")");
        }
        this.watchIdToStateMap.putAll(watchIdToStateMap);
        this.watchIdToStateMap.keySet().retainAll(watchIdToStateMap.keySet());
        return this.checkNodeChanges(watchIdToStateMap, additionalWatchIds);
    }

    public Map<String, WatchState> add(Map<String, WatchState> watchIdToStateMap, Set<String> additionalWatchIds) {
        if (log.isDebugEnabled()) {
            log.debug("WatchStateManager.add(" + String.valueOf(watchIdToStateMap.keySet()) + ", " + String.valueOf(additionalWatchIds) + ")");
        }
        this.watchIdToStateMap.putAll(watchIdToStateMap);
        return this.checkNodeChanges(watchIdToStateMap, additionalWatchIds);
    }

    public WatchState getWatchState(String watchId) {
        if (watchId == null) {
            throw new IllegalArgumentException("watchId is null");
        }
        WatchState watchState = this.watchIdToStateMap.computeIfAbsent(watchId, key -> new WatchState(this.tenant, this.node));
        return watchState;
    }

    public WatchState peekWatchState(String watchId) {
        if (watchId == null) {
            throw new IllegalArgumentException("watchId is null");
        }
        return this.watchIdToStateMap.get(watchId);
    }

    public void delete(String watchId) {
        if (log.isDebugEnabled()) {
            log.debug("WatchStateManager.delete(" + watchId + ")");
        }
        this.watchIdToStateMap.remove(watchId);
    }

    private Map<String, WatchState> checkNodeChanges(Map<String, WatchState> watchIdToStateMap, Set<String> additionalWatchIds) {
        HashMap<String, WatchState> dirtyStates = new HashMap<String, WatchState>();
        for (Map.Entry<String, WatchState> entry : watchIdToStateMap.entrySet()) {
            String id = entry.getKey();
            WatchState state = entry.getValue();
            if (state.getNode() == null) {
                state.setNode(this.node);
                dirtyStates.put(id, state);
                continue;
            }
            if (this.node.equals(state.getNode())) continue;
            state.setNode(this.node);
            state.setRefreshBeforeExecuting(true);
            dirtyStates.put(id, state);
        }
        for (String additionalWatchId : additionalWatchIds) {
            if (watchIdToStateMap.containsKey(additionalWatchId)) continue;
            WatchState state = this.watchIdToStateMap.computeIfAbsent(additionalWatchId, key -> new WatchState(this.tenant));
            if (state.getNode() == null) {
                state.setNode(this.node);
                dirtyStates.put(additionalWatchId, state);
                continue;
            }
            if (this.node.equals(state.getNode())) continue;
            state.setNode(this.node);
            state.setRefreshBeforeExecuting(true);
            dirtyStates.put(additionalWatchId, state);
        }
        return dirtyStates;
    }
}

