/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.get;

import com.floragunn.signals.watch.checks.StaticInput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class GetWatchResponse
extends ActionResponse
implements ToXContentObject {
    private String tenant;
    private String id;
    private boolean exists;
    private long version;
    private long seqNo;
    private long primaryTerm;
    private BytesReference source;

    public GetWatchResponse() {
    }

    public GetWatchResponse(String tenant, String id, boolean exists) {
        this(tenant, id, exists, -1L, -1L, -1L, null);
    }

    public GetWatchResponse(String tenant, String id, boolean exists, long version, long seqNo, long primaryTerm, BytesReference source) {
        this.tenant = tenant;
        this.id = id;
        this.exists = exists;
        this.version = version;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.source = source;
    }

    public GetWatchResponse(String tenant, GetResponse getResponse) {
        this.tenant = tenant;
        this.id = getResponse.getId();
        this.exists = getResponse.isExists();
        this.version = getResponse.getVersion();
        this.seqNo = getResponse.getSeqNo();
        this.primaryTerm = getResponse.getPrimaryTerm();
        this.source = getResponse.getSourceAsBytesRef();
    }

    public GetWatchResponse(StreamInput in) throws IOException {
        this.tenant = in.readOptionalString();
        this.id = in.readString();
        this.exists = in.readBoolean();
        this.version = in.readLong();
        this.seqNo = in.readLong();
        this.primaryTerm = in.readLong();
        this.source = in.readOptionalBytesReference();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.tenant);
        out.writeString(this.id);
        out.writeBoolean(this.exists);
        out.writeLong(this.version);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeOptionalBytesReference(this.source);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("_id", this.id);
        builder.field("_tenant", this.tenant);
        builder.field("found", this.exists);
        if (this.exists) {
            builder.field("_version", this.version);
            builder.field("_seq_no", this.seqNo);
            builder.field("_primary_term", this.primaryTerm);
            Tuple parsedSource = XContentHelper.convertToMap((BytesReference)this.source, (boolean)true, (XContentType)XContentType.JSON);
            LinkedHashMap<String, Object> source = new LinkedHashMap<String, Object>((Map)parsedSource.v2());
            StaticInput.unpatchForIndexMappingBugFix(source);
            builder.field("_source", source);
        }
        builder.endObject();
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public void setPrimaryTerm(long primaryTerm) {
        this.primaryTerm = primaryTerm;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source) {
        this.source = source;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }
}

