/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.signals.actions.summary.SortParser;
import java.util.List;
import org.elasticsearch.ElasticsearchStatusException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SortParserTest {
    @Test
    public void shouldHandleEmptySortingParam() {
        List sorting = SortParser.parseSortingExpression((String)"");
        MatcherAssert.assertThat((Object)sorting, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void shouldHandleNullSortingParam() {
        List sorting = SortParser.parseSortingExpression(null);
        MatcherAssert.assertThat((Object)sorting, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void shouldHandleBlankSortingParam() {
        List sorting = SortParser.parseSortingExpression((String)"   \t    ");
        MatcherAssert.assertThat((Object)sorting, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void shouldSortBySeverityByDefaultOrder() {
        List sorting = SortParser.parseSortingExpression((String)"severity");
        MatcherAssert.assertThat((Object)sorting, (Matcher)Matchers.hasSize((int)1));
        SortParser.SortByField field = (SortParser.SortByField)sorting.get(0);
        MatcherAssert.assertThat((Object)field.isAscending(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)field.getDocumentFieldName(), (Matcher)Matchers.equalTo((Object)"last_status.severity.keyword"));
    }

    @Test
    public void shouldSortBySeverityByAscOrder() {
        List sorting = SortParser.parseSortingExpression((String)"+severity");
        MatcherAssert.assertThat((Object)sorting, (Matcher)Matchers.hasSize((int)1));
        SortParser.SortByField field = (SortParser.SortByField)sorting.get(0);
        MatcherAssert.assertThat((Object)field.isAscending(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)field.getDocumentFieldName(), (Matcher)Matchers.equalTo((Object)"last_status.severity.keyword"));
    }

    @Test
    public void shouldSortBySeverityByDescOrder() {
        List sorting = SortParser.parseSortingExpression((String)"-severity");
        MatcherAssert.assertThat((Object)sorting, (Matcher)Matchers.hasSize((int)1));
        SortParser.SortByField field = (SortParser.SortByField)sorting.get(0);
        MatcherAssert.assertThat((Object)field.isAscending(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)field.getDocumentFieldName(), (Matcher)Matchers.equalTo((Object)"last_status.severity.keyword"));
    }

    @Test(expected=ElasticsearchStatusException.class)
    public void shouldReportExceptionOnSortingByUnknownField() {
        SortParser.parseSortingExpression((String)"unknown_field");
    }

    @Test(expected=ElasticsearchStatusException.class)
    public void shouldReportExceptionOnSortingByOnlyAscSortMarker() {
        SortParser.parseSortingExpression((String)"+");
    }

    @Test(expected=ElasticsearchStatusException.class)
    public void shouldReportExceptionOnSortingByOnlyDescSortMarker() {
        SortParser.parseSortingExpression((String)"-");
    }

    @Test
    public void shouldSortByMultipleFields() {
        List sorting = SortParser.parseSortingExpression((String)"-severity,+status_code,severity_details.level_numeric");
        MatcherAssert.assertThat((Object)sorting, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)((SortParser.SortByField)sorting.get(0)).isAscending(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)((SortParser.SortByField)sorting.get(0)).getDocumentFieldName(), (Matcher)Matchers.equalTo((Object)"last_status.severity.keyword"));
        MatcherAssert.assertThat((Object)((SortParser.SortByField)sorting.get(1)).isAscending(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((SortParser.SortByField)sorting.get(1)).getDocumentFieldName(), (Matcher)Matchers.equalTo((Object)"last_status.code.keyword"));
        MatcherAssert.assertThat((Object)((SortParser.SortByField)sorting.get(2)).isAscending(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((SortParser.SortByField)sorting.get(2)).getDocumentFieldName(), (Matcher)Matchers.equalTo((Object)"last_execution.severity.level_numeric"));
    }
}

