/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.execution;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.signals.execution.WatchExecutionContextData;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class WatchExecutionContextDataTest {
    private static final ZonedDateTime TRIGGERED = ZonedDateTime.now();
    private static final ZonedDateTime SCHEDULED = ZonedDateTime.now().minusMinutes(1L);
    private static final ZonedDateTime PREVIOUS = ZonedDateTime.now().minusMinutes(2L);
    private static final ZonedDateTime NEXT = ZonedDateTime.now().plusMinutes(1L);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_ZONED_DATE_TIME;

    @Test
    public void testToXContent() throws IOException, DocumentParseException {
        WatchExecutionContextData.TriggerInfo triggerInfo = new WatchExecutionContextData.TriggerInfo(TRIGGERED, SCHEDULED, PREVIOUS, NEXT);
        XContentBuilder xContent = triggerInfo.toXContent(XContentFactory.jsonBuilder(), null);
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(Strings.toString((XContentBuilder)xContent));
        MatcherAssert.assertThat((Object)TRIGGERED.format(FORMATTER), (Matcher)Matchers.equalTo((Object)docNode.get("triggered_time")));
        MatcherAssert.assertThat((Object)SCHEDULED.format(FORMATTER), (Matcher)Matchers.equalTo((Object)docNode.get("scheduled_time")));
        MatcherAssert.assertThat((Object)PREVIOUS.format(FORMATTER), (Matcher)Matchers.equalTo((Object)docNode.get("previous_scheduled_time")));
        MatcherAssert.assertThat((Object)NEXT.format(FORMATTER), (Matcher)Matchers.equalTo((Object)docNode.get("next_scheduled_time")));
    }

    @Test
    public void testToXContentWithNullValues() throws IOException, DocumentParseException {
        WatchExecutionContextData.TriggerInfo triggerInfo = new WatchExecutionContextData.TriggerInfo();
        XContentBuilder xContent = triggerInfo.toXContent(XContentFactory.jsonBuilder(), null);
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(Strings.toString((XContentBuilder)xContent));
        MatcherAssert.assertThat((Object)docNode.get("triggered_time"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)docNode.get("scheduled_time"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)docNode.get("previous_scheduled_time"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)docNode.get("next_scheduled_time"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testToXContentWithSomeValuesMissing() throws IOException, DocumentParseException {
        WatchExecutionContextData.TriggerInfo triggerInfo = new WatchExecutionContextData.TriggerInfo(TRIGGERED, null, PREVIOUS, null);
        XContentBuilder xContent = triggerInfo.toXContent(XContentFactory.jsonBuilder(), null);
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(Strings.toString((XContentBuilder)xContent));
        MatcherAssert.assertThat((Object)TRIGGERED.format(FORMATTER), (Matcher)Matchers.equalTo((Object)docNode.get("triggered_time")));
        MatcherAssert.assertThat((Object)PREVIOUS.format(FORMATTER), (Matcher)Matchers.equalTo((Object)docNode.get("previous_scheduled_time")));
        MatcherAssert.assertThat((Object)docNode.get("scheduled_time"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)docNode.get("next_scheduled_time"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

