/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.signals.actions.settings.get.GetSettingsAction;
import com.floragunn.signals.actions.settings.get.GetSettingsRequest;
import com.floragunn.signals.actions.settings.get.GetSettingsResponse;
import com.floragunn.signals.actions.settings.put.PutSettingsAction;
import com.floragunn.signals.actions.settings.put.PutSettingsRequest;
import com.floragunn.signals.actions.settings.put.PutSettingsResponse;
import com.floragunn.signals.api.SignalsBaseRestHandler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class SettingsApiAction
extends SignalsBaseRestHandler {
    public SettingsApiAction(Settings settings, RestController controller) {
        super(settings);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_signals/settings"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_signals/settings/{key}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_signals/settings/{key}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_signals/settings/{key}"));
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String key = request.param("key");
        switch (request.method()) {
            case GET: {
                return this.handleGet(key, request, (Client)client);
            }
            case PUT: {
                return this.handlePut(key, request, (Client)client);
            }
            case DELETE: {
                return this.handleDelete(key, request, (Client)client);
            }
        }
        throw new IllegalArgumentException(String.valueOf(request.method()) + " not supported");
    }

    protected BaseRestHandler.RestChannelConsumer handleGet(String key, RestRequest request, Client client) throws IOException {
        return channel -> client.execute((ActionType)GetSettingsAction.INSTANCE, (ActionRequest)new GetSettingsRequest(key, this.jsonRequested(request)), (ActionListener)new ActionListener<GetSettingsResponse>(){

            public void onResponse(GetSettingsResponse response) {
                if (response.getStatus() == GetSettingsResponse.Status.OK) {
                    channel.sendResponse(new RestResponse(RestStatus.OK, response.getContentType(), response.getResult()));
                } else {
                    SettingsApiAction.this.errorResponse(channel, RestStatus.NOT_FOUND, "Not found");
                }
            }

            public void onFailure(Exception e) {
                SettingsApiAction.this.errorResponse(channel, e);
            }
        });
    }

    protected BaseRestHandler.RestChannelConsumer handleDelete(String key, RestRequest request, Client client) throws IOException {
        return channel -> client.execute((ActionType)PutSettingsAction.INSTANCE, (ActionRequest)new PutSettingsRequest(key, null, false), (ActionListener)new ActionListener<PutSettingsResponse>(){

            public void onResponse(PutSettingsResponse response) {
                if (response.getResult() == DocWriteResponse.Result.CREATED || response.getResult() == DocWriteResponse.Result.UPDATED || response.getResult() == DocWriteResponse.Result.DELETED) {
                    channel.sendResponse(new RestResponse(response.getRestStatus(), SettingsApiAction.convertToJson(channel, (ToXContent)response, ToXContent.EMPTY_PARAMS)));
                } else {
                    SettingsApiAction.this.errorResponse(channel, response.getRestStatus(), response.getMessage(), response.getDetailJsonDocument());
                }
            }

            public void onFailure(Exception e) {
                SettingsApiAction.this.errorResponse(channel, e);
            }
        });
    }

    protected BaseRestHandler.RestChannelConsumer handlePut(String key, RestRequest request, Client client) throws IOException {
        String content = request.content().utf8ToString();
        boolean contentIsJson = request.getXContentType() == XContentType.JSON || request.getXContentType() == XContentType.VND_JSON;
        return channel -> client.execute((ActionType)PutSettingsAction.INSTANCE, (ActionRequest)new PutSettingsRequest(key, content, contentIsJson), (ActionListener)new ActionListener<PutSettingsResponse>(){

            public void onResponse(PutSettingsResponse response) {
                if (response.getResult() == DocWriteResponse.Result.CREATED || response.getResult() == DocWriteResponse.Result.UPDATED) {
                    channel.sendResponse(new RestResponse(response.getRestStatus(), SettingsApiAction.convertToJson(channel, (ToXContent)response, ToXContent.EMPTY_PARAMS)));
                } else {
                    SettingsApiAction.this.errorResponse(channel, response.getRestStatus(), response.getMessage(), response.getDetailJsonDocument());
                }
            }

            public void onFailure(Exception e) {
                SettingsApiAction.this.errorResponse(channel, e);
            }
        });
    }

    protected static XContentBuilder convertToJson(RestChannel channel, ToXContent toXContent, ToXContent.Params params) {
        try {
            XContentBuilder builder = channel.newBuilder();
            toXContent.toXContent(builder, params);
            return builder;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean jsonRequested(RestRequest request) {
        String[] array;
        String accept = request.header("Accept");
        if (accept == null) {
            return true;
        }
        for (String value : array = accept.split("\\s*,\\s*")) {
            if (!value.startsWith("text/plain")) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return "Settings Action";
    }
}

