/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.confconv.es;

import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.confconv.ConversionResult;

public class PainlessScriptConverter {
    private final String script;

    PainlessScriptConverter(String script) {
        this.script = script;
    }

    public ConversionResult<String> convertToSignals() {
        if (this.script == null) {
            return new ConversionResult<Object>(null);
        }
        ValidationErrors validationErrors = new ValidationErrors();
        String convertedScript = this.script;
        if (this.script.contains("ctx.payload.")) {
            convertedScript = convertedScript.replace("ctx.payload.", "data.");
        }
        if (this.script.contains("params.")) {
            validationErrors.add(new ValidationError(null, "params script attribute is not supported by Signals"));
        }
        if (this.script.contains("ctx.metadata.")) {
            convertedScript = convertedScript.replace("ctx.metadata.", "data.");
        }
        if (this.script.contains("ctx.trigger.")) {
            convertedScript = convertedScript.replace("ctx.trigger.", "trigger.");
        }
        return new ConversionResult<String>(convertedScript);
    }
}

