/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.checks;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.signals.execution.CheckExecutionException;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.watch.checks.AbstractInput;
import com.floragunn.signals.watch.common.HttpClient;
import com.floragunn.signals.watch.common.HttpClientConfig;
import com.floragunn.signals.watch.common.HttpRequestConfig;
import com.floragunn.signals.watch.common.HttpUtils;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class HttpInput
extends AbstractInput {
    private static final Logger log = LogManager.getLogger(HttpInput.class);
    private HttpClientConfig httpClientConfig;
    private HttpRequestConfig request;

    public HttpInput(String name, String target, HttpRequestConfig request, HttpClientConfig httpClientConfig) {
        super(name, target);
        this.request = request;
        this.httpClientConfig = httpClientConfig;
    }

    @Override
    public boolean execute(WatchExecutionContext ctx) throws CheckExecutionException {
        boolean bl;
        block16: {
            HttpClient httpClient = this.httpClientConfig.createHttpClient(ctx.getHttpProxyConfig());
            try {
                HttpUriRequest httpRequest = this.request.createHttpRequest(ctx);
                CloseableHttpResponse response = AccessController.doPrivileged(() -> httpClient.execute(httpRequest));
                if (log.isDebugEnabled()) {
                    log.debug("HTTP response for " + String.valueOf(this) + ": " + String.valueOf(response) + "\n" + String.valueOf(response));
                }
                if (response.getStatusLine().getStatusCode() >= 400) {
                    throw new CheckExecutionException(this, "HTTP input web service returned error: " + String.valueOf(response.getStatusLine()) + "\n" + HttpUtils.getEntityAsDebugString((HttpResponse)response));
                }
                this.request.checkHttpResponse((HttpRequest)httpRequest, (HttpResponse)response);
                Format docType = Format.peekByContentType((String)this.getContentType((HttpResponse)response));
                if (docType == null) {
                    try {
                        this.setResult(ctx, HttpUtils.getEntityAsString((HttpResponse)response));
                    }
                    catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                        throw new CheckExecutionException(this, "HTTP response contained content encoding" + response.getEntity().getContentEncoding().getValue(), e);
                    }
                    catch (IOException e) {
                        throw new CheckExecutionException(this, "Error while decoding HTTP response", e);
                    }
                } else {
                    this.setResult(ctx, DocReader.format((Format)docType).read(response.getEntity().getContent()));
                }
                bl = true;
                if (httpClient == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CheckExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CheckExecutionException(this, e.getMessage(), e);
                }
            }
            httpClient.close();
        }
        return bl;
    }

    private String getContentType(HttpResponse response) {
        Header header = response.getEntity().getContentType();
        if (header == null) {
            return null;
        }
        ContentType contentType = ContentType.parse((String)header.getValue());
        return contentType.getMimeType().toLowerCase();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", "http");
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.target != null) {
            builder.field("target", this.target);
        }
        builder.field("request");
        this.request.toXContent(builder, params);
        this.httpClientConfig.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    static HttpInput create(WatchInitializationService watchInitService, DocNode jsonObject) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonObject, validationErrors);
        vJsonNode.used(new String[]{"type"});
        String name = vJsonNode.get("name").asString();
        String target = vJsonNode.get("target").asString();
        HttpRequestConfig request = (HttpRequestConfig)vJsonNode.get("request").required().by(n -> HttpRequestConfig.create(watchInitService, n));
        HttpClientConfig httpClientConfig = null;
        try {
            httpClientConfig = HttpClientConfig.create(vJsonNode, watchInitService.getTrustManagerRegistry(), watchInitService.getHttpProxyHostRegistry(), watchInitService.getValidationLevel());
        }
        catch (ConfigValidationException e) {
            validationErrors.add(null, e);
        }
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        HttpInput result = new HttpInput(name, target, request, httpClientConfig);
        return result;
    }
}

