/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.fluent.collections.ImmutableSet;
import org.elasticsearch.common.Strings;

public class ProxyTypeProvider {
    public static final String DEFAULT_PROXY_KEYWORD = "default";
    public static final String NONE_PROXY_KEYWORD = "none";
    public static final ImmutableSet<String> INLINE_PROXY_PREFIXES = ImmutableSet.of((Object)"http:", (Object)"https:");

    public static Type determineTypeBasedOnValue(String value) {
        if (Strings.isNullOrEmpty((String)value) || DEFAULT_PROXY_KEYWORD.equalsIgnoreCase(value)) {
            return Type.USE_DEFAULT_PROXY;
        }
        if (NONE_PROXY_KEYWORD.equalsIgnoreCase(value)) {
            return Type.USE_NO_PROXY;
        }
        if (INLINE_PROXY_PREFIXES.stream().anyMatch(prefix -> value.toLowerCase().startsWith((String)prefix))) {
            return Type.USE_INLINE_PROXY;
        }
        return Type.USE_STORED_PROXY;
    }

    public static enum Type {
        USE_INLINE_PROXY,
        USE_STORED_PROXY,
        USE_DEFAULT_PROXY,
        USE_NO_PROXY;

    }
}

