/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.execute;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class ExecuteWatchResponse
extends ActionResponse
implements ToXContentObject {
    private String tenant;
    private String id;
    private Status status;
    private BytesReference result;

    public ExecuteWatchResponse() {
    }

    public ExecuteWatchResponse(String tenant, String id, Status status, BytesReference result) {
        this.tenant = tenant;
        this.id = id;
        this.status = status;
        this.result = result;
    }

    public ExecuteWatchResponse(StreamInput in) throws IOException {
        this.tenant = in.readOptionalString();
        this.id = in.readString();
        this.status = (Status)in.readEnum(Status.class);
        this.result = in.readOptionalBytesReference();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.tenant);
        out.writeString(this.id);
        out.writeEnum((Enum)this.status);
        out.writeOptionalBytesReference(this.result);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentHelper.writeRawField((String)"_source", (BytesReference)this.result, (XContentType)XContentType.JSON, (XContentBuilder)builder, (ToXContent.Params)params);
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public BytesReference getResult() {
        return this.result;
    }

    public void setResult(BytesReference result) {
        this.result = result;
    }

    public static enum Status {
        EXECUTED,
        ERROR_WHILE_EXECUTING,
        NOT_FOUND,
        TENANT_NOT_FOUND,
        INVALID_WATCH_DEFINITION,
        INVALID_INPUT,
        INVALID_GOTO;

    }
}

