/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.CertificateValidatorTest;
import com.floragunn.searchguard.ssl.DefaultSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.ExternalSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import com.floragunn.searchguard.ssl.TestPrincipalExtractor;
import com.floragunn.searchguard.ssl.test.AbstractSGUnitTest;
import com.floragunn.searchguard.ssl.test.SingleClusterTest;
import com.floragunn.searchguard.ssl.test.helper.file.FileHelper;
import com.floragunn.searchguard.ssl.test.helper.rest.RestHelper;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.ssl.util.SSLConfigConstants;
import com.floragunn.searchguard.ssl.util.config.GenericSSLConfig;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.NoHttpResponseException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.PluginAwareNode;
import org.elasticsearch.transport.Netty4Plugin;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SSLTest
extends SingleClusterTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testHttps() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").putList("searchguard.ssl.http.enabled_protocols", new String[]{"TLSv1.1", "TLSv1.2"}).putList("searchguard.ssl.http.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).putList("searchguard.ssl.transport.enabled_protocols", new String[]{"TLSv1.1", "TLSv1.2"}).putList("searchguard.ssl.transport.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        rh.keystore = "ssl/node-untspec5-keystore.p12";
        System.out.println(rh.executeSimpleRequest("_searchguard/sslinfo?pretty&show_dn=true"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty&show_dn=true").contains("EMAILADDRESS=unt@tst.com"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty&show_dn=true").contains("local_certificates_list"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty&show_dn=false").contains("local_certificates_list"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("local_certificates_list"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains("\"searchguard\""));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains("keystore_filepath"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty&show_server_certs=true").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testCipherAndProtocols() throws Exception {
        Security.setProperty("jdk.tls.disabledAlgorithms", "");
        System.out.println("Disabled algos: " + Security.getProperty("jdk.tls.disabledAlgorithms"));
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.http.enabled_ciphers", "SSL_RSA_EXPORT_WITH_RC4_40_MD5").put("searchguard.ssl.http.enabled_protocols", "SSLv3").put("client.type", "node").put("path.home", ".").build();
        try {
            String[] enabledCiphers = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createHTTPSSLEngine().getEnabledCipherSuites();
            String[] enabledProtocols = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createHTTPSSLEngine().getEnabledProtocols();
            Assert.assertEquals((long)1L, (long)enabledProtocols.length);
            Assert.assertEquals((Object)"SSLv3", (Object)enabledProtocols[0]);
            Assert.assertEquals((long)1L, (long)enabledCiphers.length);
            Assert.assertEquals((Object)"SSL_RSA_EXPORT_WITH_RC4_40_MD5", (Object)enabledCiphers[0]);
            settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enabled_ciphers", "SSL_RSA_EXPORT_WITH_RC4_40_MD5").put("searchguard.ssl.transport.enabled_protocols", "SSLv3").put("client.type", "node").put("path.home", ".").build();
            enabledCiphers = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createServerTransportSSLEngine().getEnabledCipherSuites();
            enabledProtocols = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createServerTransportSSLEngine().getEnabledProtocols();
            Assert.assertEquals((long)1L, (long)enabledProtocols.length);
            Assert.assertEquals((Object)"SSLv3", (Object)enabledProtocols[0]);
            Assert.assertEquals((long)1L, (long)enabledCiphers.length);
            Assert.assertEquals((Object)"SSL_RSA_EXPORT_WITH_RC4_40_MD5", (Object)enabledCiphers[0]);
            enabledCiphers = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createClientTransportSSLEngine(null, -1).getEnabledCipherSuites();
            enabledProtocols = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createClientTransportSSLEngine(null, -1).getEnabledProtocols();
            Assert.assertEquals((long)1L, (long)enabledProtocols.length);
            Assert.assertEquals((Object)"SSLv3", (Object)enabledProtocols[0]);
            Assert.assertEquals((long)1L, (long)enabledCiphers.length);
            Assert.assertEquals((Object)"SSL_RSA_EXPORT_WITH_RC4_40_MD5", (Object)enabledCiphers[0]);
        }
        catch (ElasticsearchSecurityException e) {
            System.out.println("EXPECTED " + ((Object)((Object)e)).getClass().getSimpleName() + " for " + System.getProperty("java.specification.version") + ": " + e.toString());
            e.printStackTrace();
            Assert.assertTrue((String)("Check if error contains 'no valid cipher suites' -> " + e.toString()), (e.toString().contains("no valid cipher suites") || e.toString().contains("failed to set cipher suite") || e.toString().contains("Unable to configure permitted SSL ciphers") || e.toString().contains("OPENSSL_internal:NO_CIPHER_MATCH") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHttpsOptionalAuth() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        System.out.println(rh.executeSimpleRequest("_searchguard/sslinfo?pretty"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains("\"searchguard\""));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testHttpsAndNodeSSL() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        System.out.println(rh.executeSimpleRequest("_searchguard/sslinfo?pretty"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    @Test
    public void testHttpsAndNodeSSLPem() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.crt.pem")).put("searchguard.ssl.transport.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.key.pem")).put("searchguard.ssl.transport.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.crt.pem")).put("searchguard.ssl.http.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.key.pem")).put("searchguard.ssl.http.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        System.out.println(rh.executeSimpleRequest("_searchguard/sslinfo?pretty"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testHttpsAndNodeSSLPemEnc() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pem/node-4.crt.pem")).put("searchguard.ssl.transport.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pem/node-4.key")).put("searchguard.ssl.transport.pemkey_password", "changeit").put("searchguard.ssl.transport.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pem/node-4.crt.pem")).put("searchguard.ssl.http.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pem/node-4.key")).put("searchguard.ssl.http.pemkey_password", "changeit").put("searchguard.ssl.http.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        System.out.println(rh.executeSimpleRequest("_searchguard/sslinfo?pretty"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testHttpsAndNodeSSLFailedCipher() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enabled_ciphers", "INVALID_CIPHER").build();
        try {
            this.setupSslOnlyMode(settings);
            Assert.fail();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.out.println("##1 " + e1.toString());
            Throwable e = ExceptionUtils.getRootCause((Throwable)e1);
            Assert.assertTrue((String)e.toString(), (boolean)e.toString().contains("no valid cipher"));
        }
    }

    @Test
    public void testHttpPlainFail() throws Exception {
        this.thrown.expect(NoHttpResponseException.class);
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "OPTIONAL").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = false;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = false;
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testHttpsNoEnforce() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "NONE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = false;
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testHttpsEnforceFail() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = false;
        try {
            rh.executeSimpleRequest("");
            Assert.fail();
        }
        catch (SocketException | SSLException e) {
            System.out.println("Expected SSLHandshakeException " + e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception " + e.toString()));
        }
    }

    @Test
    public void testHttpsV3Fail() throws Exception {
        this.thrown.expect(SSLHandshakeException.class);
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "NONE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = false;
        rh.enableHTTPClientSSLv3Only = true;
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
    }

    @Deprecated
    @Test
    public void testTransportClientSSL() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        this.setupSslOnlyMode(settings);
        this.log.debug("Elasticsearch started");
        Settings tcSettings = Settings.builder().put("cluster.name", this.clusterInfo.clustername).put(settings).build();
        try (AbstractSGUnitTest.TransportClientImpl tc = new AbstractSGUnitTest.TransportClientImpl(tcSettings, SSLTest.asCollection(SearchGuardSSLPlugin.class));){
            this.log.debug("TransportClient built, connect now to {}:{}", (Object)this.clusterInfo.nodeHost, (Object)this.clusterInfo.nodePort);
            tc.addTransportAddress(new TransportAddress(new InetSocketAddress(this.clusterInfo.nodeHost, this.clusterInfo.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
            this.log.debug("TransportClient connected");
            Assert.assertEquals((Object)"test", (Object)((IndexResponse)tc.index(((IndexRequest)new IndexRequest("test", "test").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"a\":5}", XContentType.JSON)).actionGet()).getIndex());
            this.log.debug("Index created");
            Assert.assertEquals((long)1L, (long)((SearchResponse)tc.search((SearchRequest)new SearchRequest((String[])new String[]{"test"})).actionGet()).getHits().getTotalHits().value);
            this.log.debug("Search done");
            Assert.assertEquals((long)3L, (long)((ClusterHealthResponse)tc.admin().cluster().health(new ClusterHealthRequest(new String[]{"test"})).actionGet()).getNumberOfNodes());
            this.log.debug("ClusterHealth done");
            Assert.assertEquals((long)3L, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
            this.log.debug("NodesInfoRequest asserted");
        }
    }

    @Deprecated
    @Test
    public void testTransportClientSSLExternalContext() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        this.setupSslOnlyMode(settings);
        this.log.debug("Elasticsearch started");
        Settings tcSettings = Settings.builder().put("cluster.name", this.clusterInfo.clustername).put("path.home", ".").put("searchguard.ssl.client.external_context_id", "abcx").build();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(this.getClass().getResourceAsStream("/truststore.jks"), "changeit".toCharArray());
        tmf.init(trustStore);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(this.getClass().getResourceAsStream("/node-0-keystore.jks"), "changeit".toCharArray());
        kmf.init(keyStore, "changeit".toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        ExternalSearchGuardKeyStore.registerExternalSslContext((String)"abcx", (SSLContext)sslContext);
        try (AbstractSGUnitTest.TransportClientImpl tc = new AbstractSGUnitTest.TransportClientImpl(tcSettings, SSLTest.asCollection(SearchGuardSSLPlugin.class));){
            this.log.debug("TransportClient built, connect now to {}:{}", (Object)this.clusterInfo.nodeHost, (Object)this.clusterInfo.nodePort);
            tc.addTransportAddress(new TransportAddress(new InetSocketAddress(this.clusterInfo.nodeHost, this.clusterInfo.nodePort)));
            this.log.debug("TransportClient connected");
            Assert.assertEquals((Object)"test", (Object)((IndexResponse)tc.index(((IndexRequest)new IndexRequest("test", "test").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"a\":5}", XContentType.JSON)).actionGet()).getIndex());
            this.log.debug("Index created");
            Assert.assertEquals((long)1L, (long)((SearchResponse)tc.search((SearchRequest)new SearchRequest((String[])new String[]{"test"})).actionGet()).getHits().getTotalHits().value);
            this.log.debug("Search done");
            Assert.assertEquals((long)3L, (long)((ClusterHealthResponse)tc.admin().cluster().health(new ClusterHealthRequest(new String[]{"test"})).actionGet()).getNumberOfNodes());
            this.log.debug("ClusterHealth done");
        }
    }

    @Test
    public void testNodeClientSSL() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.nonSslRestHelper();
        Settings tcSettings = Settings.builder().put("cluster.name", this.clusterInfo.clustername).put("path.home", ".").put("node.name", "client_node_" + new Random().nextInt()).put("node.data", false).put("node.master", false).put("node.ingest", false).put("discovery.initial_state_timeout", "8s").putList("discovery.zen.ping.unicast.hosts", new String[]{this.clusterInfo.nodeHost + ":" + this.clusterInfo.nodePort}).put(settings).build();
        try (Node node = new PluginAwareNode(false, tcSettings, Netty4Plugin.class, SearchGuardSSLPlugin.class).start();){
            ClusterHealthResponse res = (ClusterHealthResponse)node.client().admin().cluster().health(new ClusterHealthRequest().waitForNodes("4").timeout(TimeValue.timeValueSeconds((long)15L))).actionGet();
            Assert.assertFalse((boolean)res.isTimedOut());
            Assert.assertEquals((long)4L, (long)res.getNumberOfNodes());
            Assert.assertEquals((long)4L, (long)((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
        }
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    @Deprecated
    @Test
    public void testTransportClientSSLFail() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        this.setupSslOnlyMode(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", this.clusterInfo.clustername).put("path.home", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks").getParent()).put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore_fail.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        try (AbstractSGUnitTest.TransportClientImpl tc = new AbstractSGUnitTest.TransportClientImpl(tcSettings, SSLTest.asCollection(SearchGuardSSLPlugin.class));){
            tc.addTransportAddress(new TransportAddress(new InetSocketAddress(this.clusterInfo.nodeHost, this.clusterInfo.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
        }
    }

    @Test
    public void testAvailCiphers() throws Exception {
        SSLContext serverContext = SSLContext.getInstance("TLS");
        serverContext.init(null, null, null);
        SSLEngine engine = serverContext.createSSLEngine();
        ArrayList<String> jdkSupportedCiphers = new ArrayList<String>(Arrays.asList(engine.getSupportedCipherSuites()));
        jdkSupportedCiphers.retainAll(SSLConfigConstants.getSecureSSLCiphers((Settings)Settings.EMPTY, (boolean)false));
        engine.setEnabledCipherSuites(jdkSupportedCiphers.toArray(new String[0]));
        List<String> jdkEnabledCiphers = Arrays.asList(engine.getEnabledCipherSuites());
        System.out.println("JDK enabled ciphers: " + jdkEnabledCiphers);
        Assert.assertTrue((jdkEnabledCiphers.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUnmodifieableCipherProtocolConfig() throws Exception {
        SSLConfigConstants.getSecureSSLProtocols((Settings)Settings.EMPTY, (boolean)false)[0] = "bogus";
        Assert.assertEquals((Object)"TLSv1.3", (Object)SSLConfigConstants.getSecureSSLProtocols((Settings)Settings.EMPTY, (boolean)false)[0]);
        try {
            SSLConfigConstants.getSecureSSLCiphers((Settings)Settings.EMPTY, (boolean)false).set(0, "bogus");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Deprecated
    @Test
    public void testCustomPrincipalExtractor() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.transport.principal_extractor_class", "com.floragunn.searchguard.ssl.TestPrincipalExtractor").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        this.log.debug("Elasticsearch started");
        Settings tcSettings = Settings.builder().put("cluster.name", this.clusterInfo.clustername).put("path.home", ".").put(settings).build();
        try (AbstractSGUnitTest.TransportClientImpl tc = new AbstractSGUnitTest.TransportClientImpl(tcSettings, SSLTest.asCollection(SearchGuardSSLPlugin.class));){
            this.log.debug("TransportClient built, connect now to {}:{}", (Object)this.clusterInfo.nodeHost, (Object)this.clusterInfo.nodePort);
            tc.addTransportAddress(new TransportAddress(new InetSocketAddress(this.clusterInfo.nodeHost, this.clusterInfo.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
            this.log.debug("TransportClient connected");
            TestPrincipalExtractor.reset();
            Assert.assertEquals((Object)"test", (Object)((IndexResponse)tc.index(((IndexRequest)new IndexRequest("test", "test").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"a\":5}", XContentType.JSON)).actionGet()).getIndex());
            this.log.debug("Index created");
            Assert.assertEquals((long)1L, (long)((SearchResponse)tc.search((SearchRequest)new SearchRequest((String[])new String[]{"test"})).actionGet()).getHits().getTotalHits().value);
            this.log.debug("Search done");
            Assert.assertEquals((long)3L, (long)((ClusterHealthResponse)tc.admin().cluster().health(new ClusterHealthRequest(new String[]{"test"})).actionGet()).getNumberOfNodes());
            this.log.debug("ClusterHealth done");
            Assert.assertEquals((long)3L, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
            this.log.debug("NodesInfoRequest asserted");
        }
        rh.executeSimpleRequest("_searchguard/sslinfo?pretty");
        Assert.assertTrue((TestPrincipalExtractor.getHttpCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCRLPem() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.crt.pem")).put("searchguard.ssl.transport.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.key.pem")).put("searchguard.ssl.transport.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.crt.pem")).put("searchguard.ssl.http.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.key.pem")).put("searchguard.ssl.http.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/chain-ca.pem")).put("searchguard.ssl.http.crl.validate", true).put("searchguard.ssl.http.crl.validation_date", CertificateValidatorTest.CRL_DATE.getTime()).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
    }

    @Test
    public void testCRL() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.http.crl.validate", true).put("searchguard.ssl.http.crl.file_path", FileHelper.getAbsoluteFilePathFromClassPath("ssl/crl/revoked.crl")).put("searchguard.ssl.http.crl.validation_date", CertificateValidatorTest.CRL_DATE.getTime()).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
    }

    @Test
    public void testNodeClientSSLwithJavaTLSv13() throws Exception {
        Assume.assumeTrue((PlatformDependent.javaVersion() >= 11 ? 1 : 0) != 0);
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putList("searchguard.ssl.transport.enabled_protocols", new String[]{"TLSv1.3"}).putList("searchguard.ssl.transport.enabled_ciphers", new String[]{"TLS_AES_128_GCM_SHA256"}).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.nonSslRestHelper();
        Settings tcSettings = Settings.builder().put("cluster.name", this.clusterInfo.clustername).put("path.home", ".").put("node.name", "client_node_" + new Random().nextInt()).put("discovery.initial_state_timeout", "8s").putList("discovery.zen.ping.unicast.hosts", new String[]{this.clusterInfo.nodeHost + ":" + this.clusterInfo.nodePort}).put(settings).build();
        try (Node node = new PluginAwareNode(false, tcSettings, Netty4Plugin.class, SearchGuardSSLPlugin.class).start();){
            ClusterHealthResponse res = (ClusterHealthResponse)node.client().admin().cluster().health(new ClusterHealthRequest().waitForNodes("4").timeout(TimeValue.timeValueSeconds((long)5L))).actionGet();
            Assert.assertFalse((boolean)res.isTimedOut());
            Assert.assertEquals((long)4L, (long)res.getNumberOfNodes());
            Assert.assertEquals((long)4L, (long)((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
        }
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    @Test
    public void testTLSv1() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled_protocols", "TLSv1").put("searchguard.ssl.http.enabled", true).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\""));
    }

    @Test
    public void testHttpsAndNodeSSLKeyPass() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.keystore_keypassword", "changeit").put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.http.keystore_keypassword", "changeit").build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        System.out.println(rh.executeSimpleRequest("_searchguard/sslinfo?pretty"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    @Test(expected=IllegalStateException.class)
    public void testHttpsAndNodeSSLKeyPassFail() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.keystore_keypassword", "wrongpass").put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.http.keystore_keypassword", "wrongpass").build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
    }

    @Test
    public void testHttpsAndNodeSSLPCKS1() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pkcs1/node-0.crt.pem")).put("searchguard.ssl.transport.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pkcs1/node-0-pkcs1.key.pem")).put("searchguard.ssl.transport.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pkcs1/node-0.crt.pem")).put("searchguard.ssl.http.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pkcs1/node-0-pkcs1.key.pem")).put("searchguard.ssl.http.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        try {
            rh.enableHTTPClientSSL = true;
            rh.setSslConfig(new GenericSSLConfig.Builder().trustAll(true).build());
            System.out.println(rh.executeSimpleRequest("_searchguard/sslinfo?pretty"));
            Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
            Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        }
        finally {
            rh.setSslConfig(null);
        }
    }
}

