/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.test;

import com.floragunn.searchguard.ssl.test.AbstractSGUnitTest;
import com.floragunn.searchguard.ssl.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.ssl.test.helper.cluster.ClusterHelper;
import com.floragunn.searchguard.ssl.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.ssl.test.helper.rest.RestHelper;
import com.floragunn.searchguard.ssl.util.config.GenericSSLConfig;
import java.net.InetAddress;
import org.elasticsearch.common.settings.Settings;
import org.junit.After;

public abstract class SingleClusterTest
extends AbstractSGUnitTest {
    protected ClusterHelper clusterHelper = new ClusterHelper("utest_n" + num.incrementAndGet() + "_f" + System.getProperty("forkno") + "_t" + System.nanoTime());
    protected ClusterInfo clusterInfo;
    ClusterHelper remoteClusterHelper = null;

    protected void setup(Settings nodeOverride) throws Exception {
        this.setup(Settings.EMPTY, nodeOverride);
    }

    protected void setup(Settings nodeOverride, ClusterConfiguration clusterConfiguration) throws Exception {
        this.setup(Settings.EMPTY, nodeOverride, clusterConfiguration);
    }

    protected void setup() throws Exception {
        this.setup(Settings.EMPTY, Settings.EMPTY);
    }

    protected void setup(Settings initTransportClientSettings, Settings nodeOverride) throws Exception {
        this.setup(initTransportClientSettings, nodeOverride, ClusterConfiguration.DEFAULT);
    }

    protected void setup(Settings initTransportClientSettings, Settings nodeOverride, ClusterConfiguration clusterConfiguration) throws Exception {
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettings(nodeOverride), clusterConfiguration);
    }

    protected void setup(Settings initTransportClientSettings, Settings nodeOverride, boolean initSearchGuardIndex, ClusterConfiguration clusterConfiguration, int timeout, Integer nodes) throws Exception {
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettings(nodeOverride), clusterConfiguration, null, timeout, nodes);
    }

    protected void setupSslOnlyMode(Settings nodeOverride) throws Exception {
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettingsSslOnly(nodeOverride), ClusterConfiguration.DEFAULT);
    }

    protected void setupSslOnlyMode(Settings nodeOverride, ClusterConfiguration clusterConfiguration) throws Exception {
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettingsSslOnly(nodeOverride), clusterConfiguration);
    }

    protected RestHelper restHelper() {
        return new RestHelper(this.clusterInfo, this.getResourceFolder());
    }

    protected RestHelper restHelper(InetAddress bindAddress) {
        RestHelper result = new RestHelper(this.clusterInfo, this.getResourceFolder());
        result.setLocalAddress(bindAddress);
        return result;
    }

    protected RestHelper restHelper(GenericSSLConfig sslConfig) {
        RestHelper result = new RestHelper(this.clusterInfo, this.getResourceFolder());
        result.setSslConfig(sslConfig);
        return result;
    }

    protected RestHelper restHelper(int nodeIndex) {
        RestHelper result = new RestHelper(this.clusterInfo, this.getResourceFolder());
        result.setNodeIndex(nodeIndex);
        return result;
    }

    protected RestHelper restHelper(int nodeIndex, GenericSSLConfig sslConfig) {
        RestHelper result = new RestHelper(this.clusterInfo, this.getResourceFolder());
        result.setNodeIndex(nodeIndex);
        result.setSslConfig(sslConfig);
        return result;
    }

    protected RestHelper nonSslRestHelper() {
        return new RestHelper(this.clusterInfo, false, false, this.getResourceFolder());
    }

    protected RestHelper nonSslRestHelper(InetAddress bindAddress) {
        RestHelper result = new RestHelper(this.clusterInfo, false, false, this.getResourceFolder());
        result.setLocalAddress(bindAddress);
        return result;
    }

    @After
    public void tearDown() throws Exception {
        if (this.remoteClusterHelper != null) {
            this.remoteClusterHelper.stopCluster();
        }
        if (this.clusterInfo != null) {
            this.clusterHelper.stopCluster();
        }
    }
}

