/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.test.helper.cluster;

import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.join.ParentJoinPlugin;
import org.elasticsearch.percolator.PercolatorPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.reindex.ReindexPlugin;
import org.elasticsearch.script.mustache.MustachePlugin;
import org.elasticsearch.search.aggregations.matrix.MatrixAggregationPlugin;
import org.elasticsearch.transport.Netty4Plugin;

public enum ClusterConfiguration {
    DEFAULT(new NodeSettings(true, false), new NodeSettings(false, true), new NodeSettings(false, true)),
    SINGLENODE(new NodeSettings(true, true)),
    CLIENTNODE(new NodeSettings(true, false), new NodeSettings(false, true), new NodeSettings(false, true), new NodeSettings(false, false)),
    THREE_MASTERS(new NodeSettings(true, false), new NodeSettings(true, false), new NodeSettings(true, false), new NodeSettings(false, true), new NodeSettings(false, true));

    private List<NodeSettings> nodeSettings = new LinkedList<NodeSettings>();

    private ClusterConfiguration(NodeSettings ... settings) {
        this.nodeSettings.addAll(Arrays.asList(settings));
    }

    public List<NodeSettings> getNodeSettings() {
        return Collections.unmodifiableList(this.nodeSettings);
    }

    public List<NodeSettings> getMasterNodeSettings() {
        return Collections.unmodifiableList(this.nodeSettings.stream().filter(a -> a.masterNode).collect(Collectors.toList()));
    }

    public List<NodeSettings> getNonMasterNodeSettings() {
        return Collections.unmodifiableList(this.nodeSettings.stream().filter(a -> !a.masterNode).collect(Collectors.toList()));
    }

    public int getNodes() {
        return this.nodeSettings.size();
    }

    public int getMasterNodes() {
        return (int)this.nodeSettings.stream().filter(a -> a.masterNode).count();
    }

    public int getDataNodes() {
        return (int)this.nodeSettings.stream().filter(a -> a.dataNode).count();
    }

    public int getClientNodes() {
        return (int)this.nodeSettings.stream().filter(a -> !a.masterNode && !a.dataNode).count();
    }

    public static class NodeSettings {
        public boolean masterNode;
        public boolean dataNode;
        public List<Class<? extends Plugin>> plugins = Lists.newArrayList((Object[])new Class[]{Netty4Plugin.class, SearchGuardSSLPlugin.class, MatrixAggregationPlugin.class, MustachePlugin.class, ParentJoinPlugin.class, PercolatorPlugin.class, ReindexPlugin.class});

        public NodeSettings(boolean masterNode, boolean dataNode) {
            this.masterNode = masterNode;
            this.dataNode = dataNode;
            this.tryToIncludePainless();
        }

        public NodeSettings(boolean masterNode, boolean dataNode, List<Class<? extends Plugin>> additionalPlugins) {
            this(masterNode, dataNode);
            this.plugins.addAll(additionalPlugins);
        }

        public Class<? extends Plugin>[] getPlugins() {
            return this.plugins.toArray(new Class[0]);
        }

        public Class<? extends Plugin>[] getPlugins(List<Class<? extends Plugin>> additionalPlugins) {
            ArrayList<Class<? extends Plugin>> plugins = new ArrayList<Class<? extends Plugin>>(this.plugins);
            if (additionalPlugins != null) {
                plugins.addAll(additionalPlugins);
            }
            return plugins.toArray(new Class[0]);
        }

        private void tryToIncludePainless() {
            try {
                Class<?> painlessPlugin = Class.forName("org.elasticsearch.painless.PainlessPlugin");
                this.plugins.add(painlessPlugin);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

