/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.ssl.util.SSLCertificateHelper;
import com.floragunn.searchguard.ssl.util.SSLConfigConstants;
import com.floragunn.searchguard.support.PemKeyReader;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public class DefaultSearchGuardKeyStore
implements SearchGuardKeyStore {
    private static final String DEFAULT_STORE_TYPE = "JKS";
    private final Settings settings;
    private final Logger log = LogManager.getLogger(this.getClass());
    public final SslProvider sslHTTPProvider;
    public final SslProvider sslTransportServerProvider;
    public final SslProvider sslTransportClientProvider;
    private final boolean httpSSLEnabled;
    private final boolean transportSSLEnabled;
    private List<String> enabledHttpCiphersJDKProvider;
    private List<String> enabledTransportCiphersJDKProvider;
    private List<String> enabledHttpProtocolsJDKProvider;
    private List<String> enabledTransportProtocolsJDKProvider;
    private SslContext httpSslContext;
    private SslContext transportServerSslContext;
    private SslContext transportClientSslContext;
    private X509Certificate[] currentTransportCerts;
    private X509Certificate[] currentHttpCerts;
    private X509Certificate[] currentTransportTrustedCerts;
    private X509Certificate[] currentHttpTrustedCerts;
    private final Environment env;

    private void printJCEWarnings() {
        try {
            int aesMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (aesMaxKeyLength < 256) {
                this.log.info("AES-256 not supported, max key length for AES is " + aesMaxKeyLength + " bit. (This is not an issue, it just limits possible encryption strength. To enable AES 256, install 'Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files')");
            }
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("AES encryption not supported (SG 1). " + e);
        }
    }

    public DefaultSearchGuardKeyStore(Settings settings, Path configPath) {
        Environment _env;
        this.settings = settings;
        try {
            _env = new Environment(settings, configPath);
        }
        catch (IllegalStateException e) {
            _env = null;
        }
        this.env = _env;
        this.httpSSLEnabled = settings.getAsBoolean("searchguard.ssl.http.enabled", Boolean.valueOf(false));
        this.transportSSLEnabled = settings.getAsBoolean("searchguard.ssl.transport.enabled", Boolean.valueOf(true));
        this.sslHTTPProvider = this.httpSSLEnabled ? SslContext.defaultServerProvider() : (this.httpSSLEnabled ? SslProvider.JDK : null);
        if (this.transportSSLEnabled) {
            this.sslTransportClientProvider = SslContext.defaultClientProvider();
            this.sslTransportServerProvider = SslContext.defaultServerProvider();
        } else if (this.transportSSLEnabled) {
            this.sslTransportClientProvider = this.sslTransportServerProvider = SslProvider.JDK;
        } else {
            this.sslTransportServerProvider = null;
            this.sslTransportClientProvider = null;
        }
        this.initEnabledSSLCiphers();
        this.initSSLConfig();
        this.printJCEWarnings();
        this.log.info("TLS Transport Client Provider : {}", (Object)this.sslTransportClientProvider);
        this.log.info("TLS Transport Server Provider : {}", (Object)this.sslTransportServerProvider);
        this.log.info("TLS HTTP Provider             : {}", (Object)this.sslHTTPProvider);
        this.log.debug("sslTransportClientProvider:{} with ciphers {}", (Object)this.sslTransportClientProvider, this.getEnabledSSLCiphers(this.sslTransportClientProvider, false));
        this.log.debug("sslTransportServerProvider:{} with ciphers {}", (Object)this.sslTransportServerProvider, this.getEnabledSSLCiphers(this.sslTransportServerProvider, false));
        this.log.debug("sslHTTPProvider:{} with ciphers {}", (Object)this.sslHTTPProvider, this.getEnabledSSLCiphers(this.sslHTTPProvider, true));
        this.log.info("Enabled TLS protocols for transport layer : {}", (Object)Arrays.toString(this.getEnabledSSLProtocols(this.sslTransportServerProvider, false)));
        this.log.info("Enabled TLS protocols for HTTP layer      : {}", (Object)Arrays.toString(this.getEnabledSSLProtocols(this.sslHTTPProvider, true)));
        this.log.debug("sslTransportClientProvider:{} with protocols {}", (Object)this.sslTransportClientProvider, (Object)this.getEnabledSSLProtocols(this.sslTransportClientProvider, false));
        this.log.debug("sslTransportServerProvider:{} with protocols {}", (Object)this.sslTransportServerProvider, (Object)this.getEnabledSSLProtocols(this.sslTransportServerProvider, false));
        this.log.debug("sslHTTPProvider:{} with protocols {}", (Object)this.sslHTTPProvider, (Object)this.getEnabledSSLProtocols(this.sslHTTPProvider, true));
        if (this.transportSSLEnabled && (this.getEnabledSSLCiphers(this.sslTransportClientProvider, false).isEmpty() || this.getEnabledSSLCiphers(this.sslTransportServerProvider, false).isEmpty())) {
            throw new ElasticsearchSecurityException("no valid cipher suites for transport protocol", new Object[0]);
        }
        if (this.httpSSLEnabled && this.getEnabledSSLCiphers(this.sslHTTPProvider, true).isEmpty()) {
            throw new ElasticsearchSecurityException("no valid cipher suites for https", new Object[0]);
        }
        if (this.transportSSLEnabled && this.getEnabledSSLCiphers(this.sslTransportServerProvider, false).isEmpty()) {
            throw new ElasticsearchSecurityException("no ssl protocols for transport protocol", new Object[0]);
        }
        if (this.transportSSLEnabled && this.getEnabledSSLCiphers(this.sslTransportClientProvider, false).isEmpty()) {
            throw new ElasticsearchSecurityException("no ssl protocols for transport protocol", new Object[0]);
        }
        if (this.httpSSLEnabled && this.getEnabledSSLCiphers(this.sslHTTPProvider, true).isEmpty()) {
            throw new ElasticsearchSecurityException("no ssl protocols for https", new Object[0]);
        }
    }

    private String resolve(String propName, boolean mustBeValid) {
        String originalPath;
        String path = originalPath = this.settings.get(propName, null);
        this.log.debug("Value for {} is {}", (Object)propName, (Object)originalPath);
        if (this.env != null && originalPath != null && originalPath.length() > 0) {
            path = this.env.configFile().resolve(originalPath).toAbsolutePath().toString();
            this.log.debug("Resolved {} to {} against {}", (Object)originalPath, (Object)path, (Object)this.env.configFile().toAbsolutePath().toString());
        }
        if (mustBeValid) {
            DefaultSearchGuardKeyStore.checkPath(path, propName);
        }
        if ("".equals(path)) {
            path = null;
        }
        return path;
    }

    private void initSSLConfig() {
        boolean client;
        if (this.env == null) {
            this.log.info("No config directory, key- and truststore files are resolved absolutely");
        } else {
            this.log.info("Config directory is {}/, from there the key- and truststore files are resolved relatively", (Object)this.env.configFile().toAbsolutePath());
        }
        if (this.transportSSLEnabled) {
            this.initTransportSSLConfig();
        }
        boolean bl = client = !"node".equals(this.settings.get("client.type"));
        if (!client && this.httpSSLEnabled) {
            this.initHttpSSLConfig();
        }
    }

    @Override
    public void initTransportSSLConfig() {
        String rawKeyStoreFilePath = this.settings.get("searchguard.ssl.transport.keystore_filepath", null);
        String rawPemCertFilePath = this.settings.get("searchguard.ssl.transport.pemcert_filepath", null);
        if (rawKeyStoreFilePath != null) {
            String keystoreFilePath = this.resolve("searchguard.ssl.transport.keystore_filepath", true);
            String keystoreType = this.settings.get("searchguard.ssl.transport.keystore_type", DEFAULT_STORE_TYPE);
            String keystorePassword = this.settings.get("searchguard.ssl.transport.keystore_password", "changeit");
            String keyPassword = this.settings.get("searchguard.ssl.transport.keystore_keypassword", keystorePassword);
            String keystoreAlias = this.settings.get("searchguard.ssl.transport.keystore_alias", null);
            String truststoreFilePath = this.resolve("searchguard.ssl.transport.truststore_filepath", true);
            if (this.settings.get("searchguard.ssl.transport.truststore_filepath", null) == null) {
                throw new ElasticsearchException("searchguard.ssl.transport.truststore_filepath must be set if transport ssl is requested.", new Object[0]);
            }
            String truststoreType = this.settings.get("searchguard.ssl.transport.truststore_type", DEFAULT_STORE_TYPE);
            String truststorePassword = this.settings.get("searchguard.ssl.transport.truststore_password", "changeit");
            String truststoreAlias = this.settings.get("searchguard.ssl.transport.truststore_alias", null);
            try {
                KeyStore ks = KeyStore.getInstance(keystoreType);
                ks.load(new FileInputStream(new File(keystoreFilePath)), keystorePassword == null || keystorePassword.length() == 0 ? null : keystorePassword.toCharArray());
                X509Certificate[] transportKeystoreCert = SSLCertificateHelper.exportServerCertChain(ks, keystoreAlias);
                PrivateKey transportKeystoreKey = SSLCertificateHelper.exportDecryptedKey(ks, keystoreAlias, keyPassword == null || keyPassword.length() == 0 ? null : keyPassword.toCharArray());
                if (transportKeystoreKey == null) {
                    throw new ElasticsearchException("No key found in " + keystoreFilePath + " with alias " + keystoreAlias, new Object[0]);
                }
                if (transportKeystoreCert == null || transportKeystoreCert.length == 0) {
                    throw new ElasticsearchException("No certificates found in " + keystoreFilePath + " with alias " + keystoreAlias, new Object[0]);
                }
                KeyStore ts = KeyStore.getInstance(truststoreType);
                ts.load(new FileInputStream(new File(truststoreFilePath)), truststorePassword == null || truststorePassword.length() == 0 ? null : truststorePassword.toCharArray());
                X509Certificate[] trustedTransportCertificates = SSLCertificateHelper.exportRootCertificates(ts, truststoreAlias);
                if (trustedTransportCertificates == null || trustedTransportCertificates.length == 0) {
                    throw new ElasticsearchException("No truststore configured for server", new Object[0]);
                }
                this.onNewCerts("Transport", this.currentTransportCerts, transportKeystoreCert, this.currentTransportTrustedCerts, trustedTransportCertificates);
                this.transportServerSslContext = this.buildSSLServerContext(transportKeystoreKey, transportKeystoreCert, trustedTransportCertificates, this.getEnabledSSLCiphers(this.sslTransportServerProvider, false), this.sslTransportServerProvider, ClientAuth.REQUIRE);
                this.transportClientSslContext = this.buildSSLClientContext(transportKeystoreKey, transportKeystoreCert, trustedTransportCertificates, this.getEnabledSSLCiphers(this.sslTransportClientProvider, false), this.sslTransportClientProvider);
                this.setCurrentTransportSSLCerts(transportKeystoreCert);
                this.setCurrentTransportTrustedCerts(trustedTransportCertificates);
            }
            catch (Exception e) {
                this.logExplanation(e);
                throw new ElasticsearchSecurityException("Error while initializing transport SSL layer: " + e.toString(), e, new Object[0]);
            }
        } else if (rawPemCertFilePath != null) {
            String pemTransportCertFilePath = this.resolve("searchguard.ssl.transport.pemcert_filepath", true);
            String pemTransportKeyFilePath = this.resolve("searchguard.ssl.transport.pemkey_filepath", true);
            String pemTransportTrustedCasFilePath = this.resolve("searchguard.ssl.transport.pemtrustedcas_filepath", true);
            try {
                X509Certificate[] transportCertsChain = PemKeyReader.loadCertificatesFromFile(pemTransportCertFilePath);
                X509Certificate[] transportTrustedCaCerts = pemTransportTrustedCasFilePath != null ? PemKeyReader.loadCertificatesFromFile(pemTransportTrustedCasFilePath) : null;
                String pemKeyPassword = this.settings.get("searchguard.ssl.transport.pemkey_password");
                PrivateKey transportCertPrivateKey = PemKeyReader.loadKeyFromFile(pemKeyPassword, pemTransportKeyFilePath);
                this.onNewCerts("Transport", this.currentTransportCerts, transportCertsChain, this.currentTransportTrustedCerts, transportTrustedCaCerts);
                this.transportServerSslContext = this.buildSSLServerContext(transportCertPrivateKey, transportCertsChain, transportTrustedCaCerts, this.getEnabledSSLCiphers(this.sslTransportServerProvider, false), this.sslTransportServerProvider, ClientAuth.REQUIRE);
                this.transportClientSslContext = this.buildSSLClientContext(transportCertPrivateKey, transportCertsChain, transportTrustedCaCerts, this.getEnabledSSLCiphers(this.sslTransportClientProvider, false), this.sslTransportClientProvider);
                this.setCurrentTransportSSLCerts(transportCertsChain);
                this.setCurrentTransportTrustedCerts(transportTrustedCaCerts);
            }
            catch (Exception e) {
                this.logExplanation(e);
                throw new ElasticsearchSecurityException("Error while initializing transport SSL layer from PEM: " + e.toString(), e, new Object[0]);
            }
        } else {
            throw new ElasticsearchException("searchguard.ssl.transport.keystore_filepath or searchguard.ssl.transport.pemkey_filepath must be set if transport ssl is reqested.", new Object[0]);
        }
    }

    @Override
    public void initHttpSSLConfig() {
        String rawKeystoreFilePath = this.settings.get("searchguard.ssl.http.keystore_filepath", null);
        String rawPemCertFilePath = this.settings.get("searchguard.ssl.http.pemcert_filepath", null);
        ClientAuth httpClientAuthMode = ClientAuth.valueOf((String)this.settings.get("searchguard.ssl.http.clientauth_mode", ClientAuth.OPTIONAL.toString()));
        if (rawKeystoreFilePath != null) {
            String keystoreFilePath = this.resolve("searchguard.ssl.http.keystore_filepath", true);
            String keystoreType = this.settings.get("searchguard.ssl.http.keystore_type", DEFAULT_STORE_TYPE);
            String keystorePassword = this.settings.get("searchguard.ssl.http.keystore_password", "changeit");
            String keyPassword = this.settings.get("searchguard.ssl.http.keystore_password", keystorePassword);
            String keystoreAlias = this.settings.get("searchguard.ssl.http.keystore_alias", null);
            this.log.info("HTTPS client auth mode {}", (Object)httpClientAuthMode);
            if (this.settings.get("searchguard.ssl.http.keystore_filepath", null) == null) {
                throw new ElasticsearchException("searchguard.ssl.http.keystore_filepath must be set if https is reqested.", new Object[0]);
            }
            if (httpClientAuthMode == ClientAuth.REQUIRE && this.settings.get("searchguard.ssl.http.truststore_filepath", null) == null) {
                throw new ElasticsearchException("searchguard.ssl.http.truststore_filepath must be set if http ssl and client auth is reqested.", new Object[0]);
            }
            if ("BKS-V1".equalsIgnoreCase(keystoreType)) {
                throw new ElasticsearchException("Keystores of type BKS-V1 are not supported", new Object[0]);
            }
            try {
                KeyStore ks = KeyStore.getInstance(keystoreType);
                try (FileInputStream fin = new FileInputStream(new File(keystoreFilePath));){
                    ks.load(fin, keystorePassword == null || keystorePassword.length() == 0 ? null : keystorePassword.toCharArray());
                }
                X509Certificate[] httpKeystoreCert = SSLCertificateHelper.exportServerCertChain(ks, keystoreAlias);
                PrivateKey httpKeystoreKey = SSLCertificateHelper.exportDecryptedKey(ks, keystoreAlias, keyPassword == null || keyPassword.length() == 0 ? null : keyPassword.toCharArray());
                if (httpKeystoreKey == null) {
                    throw new ElasticsearchException("No key found in " + keystoreFilePath + " with alias " + keystoreAlias, new Object[0]);
                }
                if (httpKeystoreCert == null || httpKeystoreCert.length == 0) {
                    throw new ElasticsearchException("No certificates found in " + keystoreFilePath + " with alias " + keystoreAlias, new Object[0]);
                }
                X509Certificate[] trustedHTTPCertificates = null;
                if (this.settings.get("searchguard.ssl.http.truststore_filepath", null) != null) {
                    String truststoreFilePath = this.resolve("searchguard.ssl.http.truststore_filepath", true);
                    String truststoreType = this.settings.get("searchguard.ssl.http.truststore_type", DEFAULT_STORE_TYPE);
                    String truststorePassword = this.settings.get("searchguard.ssl.http.truststore_password", "changeit");
                    String truststoreAlias = this.settings.get("searchguard.ssl.http.truststore_alias", null);
                    KeyStore ts = KeyStore.getInstance(truststoreType);
                    try (FileInputStream fin = new FileInputStream(new File(truststoreFilePath));){
                        ts.load(fin, truststorePassword == null || truststorePassword.length() == 0 ? null : truststorePassword.toCharArray());
                    }
                    trustedHTTPCertificates = SSLCertificateHelper.exportRootCertificates(ts, truststoreAlias);
                }
                this.onNewCerts("HTTP", this.currentHttpCerts, httpKeystoreCert, this.currentHttpTrustedCerts, trustedHTTPCertificates);
                this.httpSslContext = this.buildSSLServerContext(httpKeystoreKey, httpKeystoreCert, trustedHTTPCertificates, this.getEnabledSSLCiphers(this.sslHTTPProvider, true), this.sslHTTPProvider, httpClientAuthMode);
                this.setCurrentHttpSSLCerts(httpKeystoreCert);
                this.setCurrentHttpTrustedCerts(trustedHTTPCertificates);
            }
            catch (Exception e) {
                this.logExplanation(e);
                throw new ElasticsearchSecurityException("Error while initializing HTTP SSL layer: " + e.toString(), e, new Object[0]);
            }
        }
        if (rawPemCertFilePath != null) {
            String pemHttpCertFilePath = this.resolve("searchguard.ssl.http.pemcert_filepath", true);
            String pemHttpKeyFilePath = this.resolve("searchguard.ssl.http.pemkey_filepath", true);
            String pemHttpTrustedCasFilePath = this.resolve("searchguard.ssl.http.pemtrustedcas_filepath", true);
            if (httpClientAuthMode == ClientAuth.REQUIRE) {
                DefaultSearchGuardKeyStore.checkPath(pemHttpTrustedCasFilePath, "searchguard.ssl.http.pemtrustedcas_filepath");
            }
            try {
                X509Certificate[] httpCertsChain = PemKeyReader.loadCertificatesFromFile(pemHttpCertFilePath);
                X509Certificate[] httpTrustedCaCerts = pemHttpTrustedCasFilePath != null ? PemKeyReader.loadCertificatesFromFile(pemHttpTrustedCasFilePath) : null;
                String pemKeyPassword = this.settings.get("searchguard.ssl.http.pemkey_password");
                PrivateKey httpCertPrivateKey = PemKeyReader.loadKeyFromFile(pemKeyPassword, pemHttpKeyFilePath);
                this.onNewCerts("HTTP", this.currentHttpCerts, httpCertsChain, this.currentHttpTrustedCerts, httpTrustedCaCerts);
                this.httpSslContext = this.buildSSLServerContext(httpCertPrivateKey, httpCertsChain, httpTrustedCaCerts, this.getEnabledSSLCiphers(this.sslHTTPProvider, true), this.sslHTTPProvider, httpClientAuthMode);
                this.setCurrentHttpSSLCerts(httpCertsChain);
                this.setCurrentHttpTrustedCerts(httpTrustedCaCerts);
            }
            catch (Exception e) {
                this.logExplanation(e);
                throw new ElasticsearchSecurityException("Error while initializing http SSL layer from PEM: " + e.toString(), e, new Object[0]);
            }
        } else {
            throw new ElasticsearchException("searchguard.ssl.http.keystore_filepath or searchguard.ssl.http.keystore_filepath must be set if http ssl is reqested.", new Object[0]);
        }
    }

    private void onNewCerts(String type, X509Certificate[] currentX509Certs, X509Certificate[] newX509Certs, X509Certificate[] currentTrustedCertificates, X509Certificate[] newTrustedCertificates) throws Exception {
        this.validateNewCerts(type, currentX509Certs != null ? Arrays.asList(currentX509Certs) : null, newX509Certs != null ? Arrays.asList(newX509Certs) : null, currentTrustedCertificates != null ? Arrays.asList(currentTrustedCertificates) : null, newTrustedCertificates != null ? Arrays.asList(newTrustedCertificates) : null);
    }

    private void validateNewCerts(String type, List<? extends Certificate> currentX509Certs, List<? extends Certificate> newX509Certs, List<? extends Certificate> currentTrustedCertificates, List<? extends Certificate> newTrustedCertificates) throws Exception {
        if (currentTrustedCertificates != null && !currentTrustedCertificates.equals(newTrustedCertificates)) {
            this.log.warn("================================\n" + type + " ROOT certificates updated:\n================================\nOld:\n" + currentTrustedCertificates + "\n================================\nNew:\n" + newTrustedCertificates + "\n================================");
        }
        if (currentX509Certs != null && !currentX509Certs.equals(newX509Certs)) {
            this.log.warn("================================\n" + type + " NODE certificates updated:\n================================\nOld:\n" + currentX509Certs + "\n================================\nNew:\n" + newX509Certs + "\n================================");
        }
    }

    @Override
    public SSLEngine createHTTPSSLEngine() throws SSLException {
        SSLEngine engine = this.httpSslContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        engine.setEnabledProtocols(this.getEnabledSSLProtocols(this.sslHTTPProvider, true));
        return engine;
    }

    @Override
    public SSLEngine createServerTransportSSLEngine() throws SSLException {
        SSLEngine engine = this.transportServerSslContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        engine.setEnabledProtocols(this.getEnabledSSLProtocols(this.sslTransportServerProvider, false));
        return engine;
    }

    @Override
    public SSLEngine createClientTransportSSLEngine(String peerHost, int peerPort) throws SSLException {
        if (peerHost != null) {
            SSLEngine engine = this.transportClientSslContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, peerHost, peerPort);
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParams);
            engine.setEnabledProtocols(this.getEnabledSSLProtocols(this.sslTransportClientProvider, false));
            return engine;
        }
        SSLEngine engine = this.transportClientSslContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        engine.setEnabledProtocols(this.getEnabledSSLProtocols(this.sslTransportClientProvider, false));
        return engine;
    }

    @Override
    public String getHTTPProviderName() {
        return this.sslHTTPProvider == null ? null : this.sslHTTPProvider.toString();
    }

    @Override
    public String getTransportServerProviderName() {
        return this.sslTransportServerProvider == null ? null : this.sslTransportServerProvider.toString();
    }

    @Override
    public String getTransportClientProviderName() {
        return this.sslTransportClientProvider == null ? null : this.sslTransportClientProvider.toString();
    }

    private void setCurrentHttpSSLCerts(X509Certificate[] httpKeystoreCert) {
        this.currentHttpCerts = httpKeystoreCert;
    }

    @Override
    public X509Certificate[] getHttpCerts() {
        return this.currentHttpCerts;
    }

    @Override
    public X509Certificate[] getTransportCerts() {
        return this.currentTransportCerts;
    }

    private void setCurrentTransportSSLCerts(X509Certificate[] transportKeystoreCert) {
        this.currentTransportCerts = transportKeystoreCert;
    }

    private void setCurrentHttpTrustedCerts(X509Certificate[] httpTrustedCerts) {
        this.currentHttpTrustedCerts = httpTrustedCerts;
    }

    private void setCurrentTransportTrustedCerts(X509Certificate[] transportTrustedCerts) {
        this.currentTransportTrustedCerts = transportTrustedCerts;
    }

    private List<String> getEnabledSSLCiphers(SslProvider provider, boolean http) {
        if (provider == null) {
            return Collections.emptyList();
        }
        if (http) {
            return this.enabledHttpCiphersJDKProvider;
        }
        return this.enabledTransportCiphersJDKProvider;
    }

    private String[] getEnabledSSLProtocols(SslProvider provider, boolean http) {
        if (provider == null) {
            return new String[0];
        }
        if (http) {
            return this.enabledHttpProtocolsJDKProvider.toArray(new String[0]);
        }
        return this.enabledTransportProtocolsJDKProvider.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEnabledSSLCiphers() {
        List<String> secureHttpSSLCiphers = SSLConfigConstants.getSecureSSLCiphers(this.settings, true);
        List<String> secureTransportSSLCiphers = SSLConfigConstants.getSecureSSLCiphers(this.settings, false);
        List<String> secureHttpSSLProtocols = Arrays.asList(SSLConfigConstants.getSecureSSLProtocols(this.settings, true));
        List<String> secureTransportSSLProtocols = Arrays.asList(SSLConfigConstants.getSecureSSLProtocols(this.settings, false));
        SSLEngine engine = null;
        List<String> jdkSupportedCiphers = null;
        List<String> jdkSupportedProtocols = null;
        try {
            SSLContext serverContext = SSLContext.getInstance("TLS");
            serverContext.init(null, null, null);
            engine = serverContext.createSSLEngine();
            jdkSupportedCiphers = Arrays.asList(engine.getEnabledCipherSuites());
            jdkSupportedProtocols = Arrays.asList(engine.getEnabledProtocols());
            this.log.debug("JVM supports the following {} protocols {}", (Object)jdkSupportedProtocols.size(), jdkSupportedProtocols);
            this.log.debug("JVM supports the following {} ciphers {}", (Object)jdkSupportedCiphers.size(), jdkSupportedCiphers);
            if (jdkSupportedProtocols.contains("TLSv1.3")) {
                this.log.info("JVM supports TLSv1.3");
            }
        }
        catch (Throwable e) {
            this.log.error("Unable to determine supported ciphers due to " + e, e);
        }
        finally {
            if (engine != null) {
                try {
                    engine.closeInbound();
                }
                catch (SSLException e) {
                    this.log.debug("Unable to close inbound ssl engine", (Throwable)e);
                }
                engine.closeOutbound();
            }
        }
        if (jdkSupportedCiphers == null || jdkSupportedCiphers.isEmpty() || jdkSupportedProtocols == null || jdkSupportedProtocols.isEmpty()) {
            throw new ElasticsearchException("Unable to determine supported ciphers or protocols", new Object[0]);
        }
        this.enabledHttpCiphersJDKProvider = new ArrayList<String>(jdkSupportedCiphers);
        this.enabledHttpCiphersJDKProvider.retainAll(secureHttpSSLCiphers);
        this.enabledTransportCiphersJDKProvider = new ArrayList<String>(jdkSupportedCiphers);
        this.enabledTransportCiphersJDKProvider.retainAll(secureTransportSSLCiphers);
        this.enabledHttpProtocolsJDKProvider = new ArrayList<String>(jdkSupportedProtocols);
        this.enabledHttpProtocolsJDKProvider.retainAll(secureHttpSSLProtocols);
        this.enabledTransportProtocolsJDKProvider = new ArrayList<String>(jdkSupportedProtocols);
        this.enabledTransportProtocolsJDKProvider.retainAll(secureTransportSSLProtocols);
    }

    private SslContext buildSSLServerContext(PrivateKey _key, X509Certificate[] _cert, X509Certificate[] _trustedCerts, Iterable<String> ciphers, SslProvider sslProvider, ClientAuth authMode) throws SSLException {
        SslContextBuilder _sslContextBuilder = SslContextBuilder.forServer((PrivateKey)_key, (X509Certificate[])_cert).ciphers(ciphers).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).clientAuth(Objects.requireNonNull(authMode)).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(sslProvider);
        if (_trustedCerts != null && _trustedCerts.length > 0) {
            _sslContextBuilder.trustManager(_trustedCerts);
        }
        return this.buildSSLContext0(_sslContextBuilder);
    }

    private SslContext buildSSLClientContext(PrivateKey _key, X509Certificate[] _cert, X509Certificate[] _trustedCerts, Iterable<String> ciphers, SslProvider sslProvider) throws SSLException {
        SslContextBuilder _sslClientContextBuilder = SslContextBuilder.forClient().ciphers(ciphers).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(sslProvider).trustManager(_trustedCerts).keyManager(_key, _cert);
        return this.buildSSLContext0(_sslClientContextBuilder);
    }

    private SslContext buildSSLContext0(final SslContextBuilder sslContextBuilder) throws SSLException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        SslContext sslContext = null;
        try {
            sslContext = AccessController.doPrivileged(new PrivilegedExceptionAction<SslContext>(){

                @Override
                public SslContext run() throws Exception {
                    return sslContextBuilder.build();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (SSLException)e.getCause();
        }
        return sslContext;
    }

    private void logExplanation(Exception e) {
        if (ExceptionUtils.findMsg(e, "not contain valid private key") != null) {
            this.log.error("Your keystore or PEM does not contain a key. If you specified a key password, try removing it. If you did not specify a key password, perhaps you need to if the key is in fact password-protected. Maybe you just confused keys and certificates.");
        }
        if (ExceptionUtils.findMsg(e, "not contain valid certificates") != null) {
            this.log.error("Your keystore or PEM does not contain a certificate. Maybe you confused keys and certificates.");
        }
    }

    private static void checkPath(String keystoreFilePath, String fileNameLogOnly) {
        if (keystoreFilePath == null || keystoreFilePath.length() == 0) {
            throw new ElasticsearchException("Empty file path for " + fileNameLogOnly, new Object[0]);
        }
        if (Files.isDirectory(Paths.get(keystoreFilePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new ElasticsearchException("Is a directory: " + keystoreFilePath + " Expected a file for " + fileNameLogOnly, new Object[0]);
        }
        if (!Files.isReadable(Paths.get(keystoreFilePath, new String[0]))) {
            throw new ElasticsearchException("Unable to read " + keystoreFilePath + " (" + Paths.get(keystoreFilePath, new String[0]) + "). Please make sure this files exists and is readable regarding to permissions. Property: " + fileNameLogOnly, new Object[0]);
        }
    }
}

