/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public final class PemKeyReader {
    protected static final Logger log = LogManager.getLogger(PemKeyReader.class);
    static final String JKS = "JKS";
    static final String PKCS12 = "PKCS12";

    private static void safeClose(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey toPrivateKey(File keyFile, String keyPassword) throws IOException, OperatorCreationException, PKCSException {
        if (keyFile == null) {
            return null;
        }
        FileInputStream in = new FileInputStream(keyFile);
        try {
            PrivateKey privateKey = PemKeyReader.getPrivateKeyFromByteBuffer(in, keyPassword);
            return privateKey;
        }
        finally {
            PemKeyReader.safeClose(in);
        }
    }

    public static PrivateKey toPrivateKey(InputStream in, String keyPassword) throws IOException, OperatorCreationException, PKCSException {
        if (in == null) {
            return null;
        }
        return PemKeyReader.getPrivateKeyFromByteBuffer(in, keyPassword);
    }

    private static PrivateKey getPrivateKeyFromByteBuffer(InputStream in, String keyPassword) throws IOException, OperatorCreationException, PKCSException {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(in, StandardCharsets.US_ASCII));){
            Object object = pemParser.readObject();
            if (object == null) {
                PrivateKey privateKey = null;
                return privateKey;
            }
            if (object instanceof PEMKeyPair) {
                PrivateKey privateKey = converter.getKeyPair((PEMKeyPair)object).getPrivate();
                return privateKey;
            }
            if (object instanceof PEMEncryptedKeyPair) {
                BcPEMDecryptorProvider pdp = new BcPEMDecryptorProvider(keyPassword == null ? null : keyPassword.toCharArray());
                PEMKeyPair kp = ((PEMEncryptedKeyPair)object).decryptKeyPair((PEMDecryptorProvider)pdp);
                PrivateKey privateKey = converter.getKeyPair(kp).getPrivate();
                return privateKey;
            }
            if (object instanceof PrivateKeyInfo) {
                PrivateKey pdp = converter.getPrivateKey((PrivateKeyInfo)object);
                return pdp;
            }
            if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                InputDecryptorProvider pdp = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(keyPassword == null ? null : keyPassword.toCharArray());
                PrivateKey privateKey = converter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)object).decryptPrivateKeyInfo(pdp));
                return privateKey;
            }
            throw new PKCSException("Unable to decrypt private key (Type: " + object.getClass() + " )");
        }
    }

    public static X509Certificate loadCertificateFromFile(String file) throws Exception {
        if (file == null) {
            return null;
        }
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        try (FileInputStream is = new FileInputStream(file);){
            X509Certificate x509Certificate = (X509Certificate)fact.generateCertificate(is);
            return x509Certificate;
        }
    }

    public static X509Certificate loadCertificateFromStream(InputStream in) throws Exception {
        if (in == null) {
            return null;
        }
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        return (X509Certificate)fact.generateCertificate(in);
    }

    public static KeyStore loadKeyStore(String storePath, String keyStorePassword, String type) throws Exception {
        if (storePath == null) {
            return null;
        }
        if (type == null || !type.toUpperCase().equals(JKS) || !type.toUpperCase().equals(PKCS12)) {
            type = JKS;
        }
        KeyStore store = KeyStore.getInstance(type.toUpperCase());
        store.load(new FileInputStream(storePath), keyStorePassword == null ? null : keyStorePassword.toCharArray());
        return store;
    }

    public static PrivateKey loadKeyFromFile(String password, String keyFile) throws Exception {
        if (keyFile == null) {
            return null;
        }
        return PemKeyReader.toPrivateKey(new File(keyFile), password);
    }

    public static PrivateKey loadKeyFromStream(String password, InputStream in) throws Exception {
        if (in == null) {
            return null;
        }
        return PemKeyReader.toPrivateKey(in, password);
    }

    public static void checkPath(String keystoreFilePath, String fileNameLogOnly) {
        if (keystoreFilePath == null || keystoreFilePath.length() == 0) {
            throw new ElasticsearchException("Empty file path for " + fileNameLogOnly, new Object[0]);
        }
        if (Files.isDirectory(Paths.get(keystoreFilePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new ElasticsearchException("Is a directory: " + keystoreFilePath + " Expected a file for " + fileNameLogOnly, new Object[0]);
        }
        if (!Files.isReadable(Paths.get(keystoreFilePath, new String[0]))) {
            throw new ElasticsearchException("Unable to read " + keystoreFilePath + " (" + Paths.get(keystoreFilePath, new String[0]) + "). Please make sure this files exists and is readable regarding to permissions. Property: " + fileNameLogOnly, new Object[0]);
        }
    }

    public static X509Certificate[] loadCertificatesFromFile(String file) throws Exception {
        if (file == null) {
            return null;
        }
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        try (FileInputStream is = new FileInputStream(file);){
            Collection<? extends Certificate> certs = fact.generateCertificates(is);
            X509Certificate[] x509Certs = new X509Certificate[certs.size()];
            int i = 0;
            for (Certificate certificate : certs) {
                x509Certs[i++] = (X509Certificate)certificate;
            }
            X509Certificate[] x509CertificateArray = x509Certs;
            return x509CertificateArray;
        }
    }

    public static X509Certificate[] loadCertificatesFromStream(InputStream in) throws CertificateException {
        if (in == null) {
            return null;
        }
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certs = fact.generateCertificates(in);
        X509Certificate[] x509Certs = new X509Certificate[certs.size()];
        int i = 0;
        for (Certificate certificate : certs) {
            x509Certs[i++] = (X509Certificate)certificate;
        }
        return x509Certs;
    }

    public static InputStream resolveStream(String propName, Settings settings) {
        String content = settings.get(propName, null);
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.US_ASCII));
    }

    public static String resolve(String propName, Settings settings, Path configPath, boolean mustBeValid) {
        String originalPath = settings.get(propName, null);
        return PemKeyReader.resolve(originalPath, propName, settings, configPath, mustBeValid);
    }

    public static String resolve(String originalPath, String propName, Settings settings, Path configPath, boolean mustBeValid) {
        log.debug("Path is is {}", (Object)originalPath);
        String path = originalPath;
        Environment env = new Environment(settings, configPath);
        if (env != null && originalPath != null && originalPath.length() > 0) {
            path = env.configFile().resolve(originalPath).toAbsolutePath().toString();
            log.debug("Resolved {} to {} against {}", (Object)originalPath, (Object)path, (Object)env.configFile().toAbsolutePath().toString());
        }
        if (mustBeValid) {
            PemKeyReader.checkPath(path, propName);
        }
        if ("".equals(path)) {
            path = null;
        }
        return path;
    }

    public static KeyStore toTruststore(String trustCertificatesAliasPrefix, X509Certificate[] trustCertificates) throws Exception {
        if (trustCertificates == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance(JKS);
        ks.load(null);
        if (trustCertificates != null && trustCertificates.length > 0) {
            for (int i = 0; i < trustCertificates.length; ++i) {
                X509Certificate x509Certificate = trustCertificates[i];
                ks.setCertificateEntry(trustCertificatesAliasPrefix + "_" + i, x509Certificate);
            }
        }
        return ks;
    }

    public static KeyStore toKeystore(String authenticationCertificateAlias, char[] password, X509Certificate[] authenticationCertificate, PrivateKey authenticationKey) throws Exception {
        if (authenticationCertificateAlias != null && authenticationCertificate != null && authenticationKey != null) {
            KeyStore ks = KeyStore.getInstance(JKS);
            ks.load(null, null);
            ks.setKeyEntry(authenticationCertificateAlias, authenticationKey, password, authenticationCertificate);
            return ks;
        }
        return null;
    }

    public static char[] randomChars(int len) {
        SecureRandom r = new SecureRandom();
        char[] ret = new char[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (char)(r.nextInt(26) + 97);
        }
        return ret;
    }

    private PemKeyReader() {
    }
}

