/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.test.helper.file.FileHelper;
import com.floragunn.searchguard.ssl.util.CertificateValidator;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.junit.Assert;
import org.junit.Test;

public class CertificateValidatorTest {
    public static final Date CRL_DATE = new Date(1525546426000L);
    protected final Logger log = LogManager.getLogger(this.getClass());

    @Test
    public void testStaticCRL() throws Exception {
        Collection<? extends Certificate> certsToValidate;
        Collection<? extends Certificate> rootCas;
        File staticCrl = FileHelper.getAbsoluteFilePathFromClassPath("ssl/crl/revoked.crl").toFile();
        Collection<? extends CRL> crls = null;
        try (FileInputStream crlin = new FileInputStream(staticCrl);){
            crls = CertificateFactory.getInstance("X.509").generateCRLs(crlin);
        }
        Assert.assertEquals((long)crls.size(), (long)1L);
        File trustedCas = FileHelper.getAbsoluteFilePathFromClassPath("ssl/chain-ca.pem").toFile();
        try (FileInputStream trin = new FileInputStream(trustedCas);){
            rootCas = CertificateFactory.getInstance("X.509").generateCertificates(trin);
        }
        Assert.assertEquals((long)rootCas.size(), (long)2L);
        File certs = FileHelper.getAbsoluteFilePathFromClassPath("ssl/crl/revoked.crt.pem").toFile();
        try (FileInputStream trin = new FileInputStream(certs);){
            certsToValidate = CertificateFactory.getInstance("X.509").generateCertificates(trin);
        }
        Assert.assertEquals((long)certsToValidate.size(), (long)2L);
        CertificateValidator validator = new CertificateValidator(rootCas.toArray(new X509Certificate[0]), crls);
        validator.setDate(CRL_DATE);
        try {
            validator.validate((Certificate[])certsToValidate.toArray(new X509Certificate[0]));
            Assert.fail();
        }
        catch (CertificateException e) {
            Assert.assertTrue((boolean)(ExceptionUtils.getRootCause((Throwable)e) instanceof CertificateRevokedException));
        }
    }

    @Test
    public void testStaticCRLOk() throws Exception {
        Collection<? extends Certificate> certsToValidate;
        Collection<? extends Certificate> rootCas;
        File staticCrl = FileHelper.getAbsoluteFilePathFromClassPath("ssl/crl/revoked.crl").toFile();
        Collection<? extends CRL> crls = null;
        try (FileInputStream crlin = new FileInputStream(staticCrl);){
            crls = CertificateFactory.getInstance("X.509").generateCRLs(crlin);
        }
        Assert.assertEquals((long)crls.size(), (long)1L);
        File trustedCas = FileHelper.getAbsoluteFilePathFromClassPath("ssl/chain-ca.pem").toFile();
        try (FileInputStream trin = new FileInputStream(trustedCas);){
            rootCas = CertificateFactory.getInstance("X.509").generateCertificates(trin);
        }
        Assert.assertEquals((long)rootCas.size(), (long)2L);
        File certs = FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.crt.pem").toFile();
        try (FileInputStream trin = new FileInputStream(certs);){
            certsToValidate = CertificateFactory.getInstance("X.509").generateCertificates(trin);
        }
        Assert.assertEquals((long)certsToValidate.size(), (long)3L);
        CertificateValidator validator = new CertificateValidator(rootCas.toArray(new X509Certificate[0]), crls);
        validator.setDate(CRL_DATE);
        try {
            validator.validate((Certificate[])certsToValidate.toArray(new X509Certificate[0]));
        }
        catch (CertificateException e) {
            Assert.fail((String)ExceptionsHelper.stackTrace((Throwable)ExceptionUtils.getRootCause((Throwable)e)));
        }
    }

    @Test
    public void testNoValidationPossible() throws Exception {
        Collection<? extends Certificate> certsToValidate;
        Collection<? extends Certificate> rootCas;
        File trustedCas = FileHelper.getAbsoluteFilePathFromClassPath("ssl/chain-ca.pem").toFile();
        try (FileInputStream trin = new FileInputStream(trustedCas);){
            rootCas = CertificateFactory.getInstance("X.509").generateCertificates(trin);
        }
        Assert.assertEquals((long)rootCas.size(), (long)2L);
        File certs = FileHelper.getAbsoluteFilePathFromClassPath("ssl/crl/revoked.crt.pem").toFile();
        try (FileInputStream trin = new FileInputStream(certs);){
            certsToValidate = CertificateFactory.getInstance("X.509").generateCertificates(trin);
        }
        Assert.assertEquals((long)certsToValidate.size(), (long)2L);
        CertificateValidator validator = new CertificateValidator(rootCas.toArray(new X509Certificate[0]), Collections.emptyList());
        validator.setDate(CRL_DATE);
        try {
            validator.validate((Certificate[])certsToValidate.toArray(new X509Certificate[0]));
            Assert.fail();
        }
        catch (CertificateException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof CertPathBuilderException));
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("unable to find valid certification path to requested target"));
        }
    }

    @Test
    public void testCRLDP() throws Exception {
        Collection<? extends Certificate> certsToValidate;
        Collection<? extends Certificate> rootCas;
        Security.setProperty("ocsp.enable", "true");
        File trustedCas = FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem").toFile();
        try (FileInputStream trin = new FileInputStream(trustedCas);){
            rootCas = CertificateFactory.getInstance("X.509").generateCertificates(trin);
        }
        Assert.assertEquals((long)rootCas.size(), (long)1L);
        File certs = FileHelper.getAbsoluteFilePathFromClassPath("ssl/crl/revoked.crt.pem").toFile();
        try (FileInputStream trin = new FileInputStream(certs);){
            certsToValidate = CertificateFactory.getInstance("X.509").generateCertificates(trin);
        }
        Assert.assertEquals((long)certsToValidate.size(), (long)2L);
        CertificateValidator validator = new CertificateValidator(rootCas.toArray(new X509Certificate[0]), Collections.emptyList());
        validator.setEnableCRLDP(true);
        validator.setDate(CRL_DATE);
        try {
            validator.validate((Certificate[])certsToValidate.toArray(new X509Certificate[0]));
            Assert.fail();
        }
        catch (CertificateException e) {
            Assert.assertTrue((boolean)(ExceptionUtils.getRootCause((Throwable)e) instanceof CertificateRevokedException));
        }
    }
}

