/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeConstruction;
import org.elasticsearch.node.NodeServiceProvider;
import org.elasticsearch.node.SgNodeServiceProvider;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsLoader;

public class PluginAwareNode
extends Node {
    private static final AtomicBoolean loggingInitialized = new AtomicBoolean();
    private final boolean masterEligible;

    public PluginAwareNode(boolean masterEligible, Settings preparedSettings) {
        this(masterEligible, preparedSettings, Collections.emptyList());
    }

    public PluginAwareNode(boolean masterEligible, Settings preparedSettings, List<Class<? extends Plugin>> additionalPlugins) {
        super(NodeConstruction.prepareConstruction((Environment)PluginAwareNode.createEnvironment(preparedSettings), (PluginsLoader)PluginsLoader.createPluginsLoader(Set.of(), Set.of(), Map.of(), (boolean)false), (NodeServiceProvider)new SgNodeServiceProvider(additionalPlugins), (boolean)true));
        this.masterEligible = masterEligible;
    }

    private static Environment createEnvironment(Settings preparedSettings) {
        return PluginAwareNode.configureESLogging(InternalSettingsPreparer.prepareEnvironment((Settings)preparedSettings, Collections.emptyMap(), null, () -> System.getenv("HOSTNAME")));
    }

    private static Environment configureESLogging(Environment environment) {
        if (!loggingInitialized.get()) {
            try {
                environment.configDir().toFile().mkdirs();
                byte[] log4jprops = Files.readAllBytes(Paths.get("src/test/resources/log4j2-test.properties", new String[0]));
                Files.write(environment.configDir().resolve("log4j2.properties"), log4jprops, new OpenOption[0]);
                LogConfigurator.registerErrorListener();
                LogConfigurator.setNodeName((String)"node");
                LogConfigurator.configure((Environment)environment, (boolean)true);
                loggingInitialized.set(true);
                return environment;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return environment;
    }

    public boolean isMasterEligible() {
        return this.masterEligible;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
    }
}

