/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.test.helper.network;

import com.floragunn.searchguard.ssl.test.helper.network.SocketUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class PortAllocator {
    public static final PortAllocator TCP = new PortAllocator(SocketUtils.SocketType.TCP, Duration.ofSeconds(100L));
    public static final PortAllocator UDP = new PortAllocator(SocketUtils.SocketType.UDP, Duration.ofSeconds(100L));
    private final SocketUtils.SocketType socketType;
    private final Duration timeoutDuration;
    private final Map<Integer, AllocatedPort> allocatedPorts = new HashMap<Integer, AllocatedPort>();

    PortAllocator(SocketUtils.SocketType socketType, Duration timeoutDuration) {
        this.socketType = socketType;
        this.timeoutDuration = timeoutDuration;
    }

    public SortedSet<Integer> allocate(String clientName, int numRequested, int minPort) {
        int startPort = minPort;
        while (!this.isAvailable(startPort)) {
            startPort += 10;
        }
        TreeSet<Integer> foundPorts = new TreeSet<Integer>();
        for (int currentPort = startPort; foundPorts.size() < numRequested && currentPort < 65535 && currentPort - startPort < 10000; ++currentPort) {
            if (!this.allocate(clientName, currentPort)) continue;
            foundPorts.add(currentPort);
        }
        if (foundPorts.size() < numRequested) {
            throw new IllegalStateException("Could not find " + numRequested + " free ports starting at " + minPort + " for " + clientName);
        }
        return foundPorts;
    }

    public int allocateSingle(String clientName, int minPort) {
        int startPort;
        for (int currentPort = startPort = minPort; currentPort < 65535 && currentPort - startPort < 10000; ++currentPort) {
            if (!this.allocate(clientName, currentPort)) continue;
            return currentPort;
        }
        throw new IllegalStateException("Could not find free port starting at " + minPort + " for " + clientName);
    }

    public void blacklist(int ... ports) {
        for (int port : ports) {
            this.allocate("blacklisted", port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInUse(int port) {
        boolean result;
        boolean bl = result = !this.socketType.isPortAvailable(port);
        if (result) {
            PortAllocator portAllocator = this;
            synchronized (portAllocator) {
                this.allocatedPorts.put(port, new AllocatedPort("external"));
            }
        }
        return result;
    }

    private boolean isAvailable(int port) {
        return !this.isAllocated(port) && !this.isInUse(port);
    }

    private synchronized boolean isAllocated(int port) {
        AllocatedPort allocatedPort = this.allocatedPorts.get(port);
        return allocatedPort != null && !allocatedPort.isTimedOut();
    }

    private synchronized boolean allocate(String clientName, int port) {
        AllocatedPort allocatedPort = this.allocatedPorts.get(port);
        if (allocatedPort != null && allocatedPort.isTimedOut()) {
            allocatedPort = null;
            this.allocatedPorts.remove(port);
        }
        if (allocatedPort == null && !this.isInUse(port)) {
            this.allocatedPorts.put(port, new AllocatedPort(clientName));
            return true;
        }
        return false;
    }

    private class AllocatedPort {
        final String client;
        final Instant allocatedAt;

        AllocatedPort(String client) {
            this.client = client;
            this.allocatedAt = Instant.now();
        }

        boolean isTimedOut() {
            return this.allocatedAt.plus(PortAllocator.this.timeoutDuration).isBefore(Instant.now());
        }

        public String toString() {
            return "AllocatedPort [client=" + this.client + ", allocatedAt=" + this.allocatedAt + "]";
        }
    }
}

