/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.test.helper.cluster;

import com.floragunn.searchguard.ssl.test.NodeSettingsSupplier;
import com.floragunn.searchguard.ssl.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.ssl.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.ssl.test.helper.network.SocketUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksRequest;
import org.elasticsearch.action.admin.cluster.tasks.TransportPendingClusterTasksAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.PluginAwareNode;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;

public final class ClusterHelper {
    private static final AtomicLong num;
    protected final Logger log = LogManager.getLogger(ClusterHelper.class);
    protected final List<PluginAwareNode> esNodes = new LinkedList<PluginAwareNode>();
    private final String clusternamePrefix;

    public ClusterHelper(String prefix, int clusterNumber) {
        this.clusternamePrefix = prefix + num.incrementAndGet() + "_f" + System.getProperty("forkno") + "_c" + clusterNumber + "_t";
    }

    public final ClusterInfo startCluster(NodeSettingsSupplier nodeSettingsSupplier, ClusterConfiguration clusterConfiguration) throws Exception {
        return this.startCluster(nodeSettingsSupplier, clusterConfiguration, null, 10, null);
    }

    public final synchronized ClusterInfo startCluster(NodeSettingsSupplier nodeSettingsSupplier, ClusterConfiguration clusterConfiguration, List<Class<? extends Plugin>> additionalPlugins, int timeout, Integer nodes) throws Exception {
        PluginAwareNode node;
        int nodeNum;
        ClusterConfiguration.NodeSettings setting;
        int i;
        if (!this.esNodes.isEmpty()) {
            throw new RuntimeException("There are still " + this.esNodes.size() + " nodes instantiated, close them first.");
        }
        String clustername = this.clusternamePrefix + System.nanoTime();
        File homeDir = null;
        try {
            homeDir = Files.createTempDirectory(clustername, new FileAttribute[0]).toFile();
            homeDir.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<ClusterConfiguration.NodeSettings> internalNodeSettings = clusterConfiguration.getNodeSettings();
        String forkno = System.getProperty("forkno");
        int forkNumber = 1;
        if (forkno != null && forkno.length() > 0) {
            forkNumber = Integer.parseInt(forkno.split("_")[1]);
        }
        int min = 1024 + forkNumber * 5000;
        int max = 1024 + (forkNumber + 1) * 5000 - 1;
        SortedSet<Integer> freePorts = SocketUtils.findAvailableTcpPorts(internalNodeSettings.size() * 2, min, max);
        assert (freePorts.size() == internalNodeSettings.size() * 2);
        TreeSet<Integer> tcpMasterPortsOnly = new TreeSet<Integer>();
        TreeSet tcpAllPorts = new TreeSet();
        freePorts.stream().limit(clusterConfiguration.getMasterNodes()).forEach(el -> tcpMasterPortsOnly.add((Integer)el));
        freePorts.stream().limit(internalNodeSettings.size()).forEach(el -> tcpAllPorts.add(el));
        Iterator tcpPortsAllIt = tcpAllPorts.iterator();
        TreeSet httpPorts = new TreeSet();
        freePorts.stream().skip(internalNodeSettings.size()).limit(internalNodeSettings.size()).forEach(el -> httpPorts.add(el));
        Iterator httpPortsIt = httpPorts.iterator();
        System.out.println("tcpMasterPorts: " + tcpMasterPortsOnly + "/tcpAllPorts: " + tcpAllPorts + "/httpPorts: " + httpPorts + " for (" + min + "-" + max + ") fork " + forkNumber);
        final CountDownLatch latch = new CountDownLatch(internalNodeSettings.size());
        final AtomicReference err = new AtomicReference();
        List<ClusterConfiguration.NodeSettings> internalMasterNodeSettings = clusterConfiguration.getMasterNodeSettings();
        List<ClusterConfiguration.NodeSettings> internalNonMasterNodeSettings = clusterConfiguration.getNonMasterNodeSettings();
        int nodeNumCounter = internalNodeSettings.size();
        for (i = 0; i < internalMasterNodeSettings.size(); ++i) {
            setting = internalMasterNodeSettings.get(i);
            nodeNum = nodeNumCounter--;
            node = new PluginAwareNode(setting.masterNode, this.getMinimumNonSgNodeSettingsBuilder(nodeNum, setting.masterNode, setting.dataNode, tcpMasterPortsOnly, (Integer)tcpPortsAllIt.next(), (Integer)httpPortsIt.next(), clustername, homeDir).put(nodeSettingsSupplier == null ? Settings.builder().build() : nodeSettingsSupplier.get(nodeNum)).build());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        node.start();
                        latch.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ClusterHelper.this.log.error("Unable to start node: " + e);
                        err.set(e);
                        latch.countDown();
                    }
                }
            }).start();
            this.esNodes.add(node);
        }
        for (i = 0; i < internalNonMasterNodeSettings.size(); ++i) {
            setting = internalNonMasterNodeSettings.get(i);
            nodeNum = nodeNumCounter--;
            node = new PluginAwareNode(setting.masterNode, this.getMinimumNonSgNodeSettingsBuilder(nodeNum, setting.masterNode, setting.dataNode, tcpMasterPortsOnly, (Integer)tcpPortsAllIt.next(), (Integer)httpPortsIt.next(), clustername, homeDir).put(nodeSettingsSupplier == null ? Settings.builder().build() : nodeSettingsSupplier.get(nodeNum)).build());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        node.start();
                        latch.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ClusterHelper.this.log.error("Unable to start node: " + e);
                        err.set(e);
                        latch.countDown();
                    }
                }
            }).start();
            this.esNodes.add(node);
        }
        assert (nodeNumCounter == 0);
        latch.await();
        if (err.get() != null) {
            throw new RuntimeException("Could not start all nodes " + err.get(), (Throwable)err.get());
        }
        ClusterInfo cInfo = this.waitForCluster(ClusterHealthStatus.GREEN, TimeValue.timeValueSeconds((long)timeout), nodes == null ? this.esNodes.size() : nodes.intValue());
        cInfo.numNodes = internalNodeSettings.size();
        cInfo.clustername = clustername;
        cInfo.tcpMasterPortsOnly = tcpMasterPortsOnly.stream().map(s -> "127.0.0.1:" + s).collect(Collectors.toList());
        String defaultTemplate = "{\n          \"index_patterns\": [\"*\"],\n          \"order\": -1,\n          \"settings\": {\n            \"number_of_shards\": \"5\",\n            \"number_of_replicas\": \"1\"\n          }\n        }";
        AcknowledgedResponse templateAck = (AcknowledgedResponse)this.nodeClient().admin().indices().putTemplate(new PutIndexTemplateRequest("default").source("{\n          \"index_patterns\": [\"*\"],\n          \"order\": -1,\n          \"settings\": {\n            \"number_of_shards\": \"5\",\n            \"number_of_replicas\": \"1\"\n          }\n        }", XContentType.JSON)).actionGet();
        if (!templateAck.isAcknowledged()) {
            throw new RuntimeException("Default template could not be created");
        }
        return cInfo;
    }

    public final void stopCluster() throws Exception {
        this.esNodes.stream().filter(n -> !n.isMasterEligible()).forEach(node -> ClusterHelper.closeNode(node));
        this.esNodes.stream().filter(n -> n.isMasterEligible()).forEach(node -> ClusterHelper.closeNode(node));
        this.esNodes.clear();
    }

    private static void closeNode(Node node) {
        try {
            node.close();
            node.awaitClose(10L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Client nodeClient() {
        return this.esNodes.get(0).client();
    }

    public PluginAwareNode node() {
        if (this.esNodes.size() == 0) {
            for (int i = 0; i < 100; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (this.esNodes.size() != 0) break;
            }
        }
        if (this.esNodes.size() == 0) {
            throw new RuntimeException("Could not get intialized cluster");
        }
        return this.esNodes.get(0);
    }

    public List<PluginAwareNode> allNodes() {
        return Collections.unmodifiableList(this.esNodes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClusterInfo waitForCluster(ClusterHealthStatus status, TimeValue timeout, int expectedNodeCount) throws IOException {
        if (this.esNodes.isEmpty()) {
            throw new RuntimeException("List of nodes was empty.");
        }
        ClusterInfo clusterInfo = new ClusterInfo();
        Node node = this.esNodes.get(0);
        Client client = node.client();
        try {
            this.log.debug("waiting for cluster state {} and {} nodes", (Object)status.name(), (Object)expectedNodeCount);
            TimeValue masterNodeTimeout = new TimeValue(40L, TimeUnit.SECONDS);
            ClusterHealthResponse healthResponse = (ClusterHealthResponse)((ClusterHealthRequestBuilder)client.admin().cluster().prepareHealth(masterNodeTimeout, new String[0]).setWaitForStatus(status).setTimeout(timeout).setMasterNodeTimeout(timeout)).setWaitForNodes("" + expectedNodeCount).execute().actionGet();
            if (healthResponse.isTimedOut()) {
                this.log.error(Strings.toString((ToXContent)healthResponse));
                this.log.error(Strings.toString((ChunkedToXContent)((ChunkedToXContent)client.execute(TransportPendingClusterTasksAction.TYPE, (ActionRequest)new PendingClusterTasksRequest(masterNodeTimeout)).actionGet())));
                this.log.error(Strings.toString((ChunkedToXContent)((ChunkedToXContent)client.admin().indices().getIndex(new GetIndexRequest().includeDefaults(true).features(new GetIndexRequest.Feature[]{GetIndexRequest.Feature.MAPPINGS})).actionGet())));
                this.log.error(Strings.toString((ChunkedToXContent)((ChunkedToXContent)client.admin().indices().stats(new IndicesStatsRequest().all()).actionGet())));
                this.log.error(Strings.toString((ToXContent)((ToXContent)client.admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet())));
                this.log.error(Strings.toString((ChunkedToXContent)((ChunkedToXContent)client.admin().cluster().nodesStats(new NodesStatsRequest()).actionGet())));
                throw new IOException("cluster state is " + healthResponse.getStatus().name() + " with " + healthResponse.getNumberOfNodes() + " nodes: " + Strings.toString((ToXContent)healthResponse));
            }
            this.log.debug("... cluster state ok " + healthResponse.getStatus().name() + " with " + healthResponse.getNumberOfNodes() + " nodes");
            Assert.assertEquals((long)expectedNodeCount, (long)healthResponse.getNumberOfNodes());
            NodesInfoResponse res = (NodesInfoResponse)client.admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet();
            List nodes = res.getNodes();
            List masterNodes = nodes.stream().filter(n -> n.getNode().getRoles().contains(DiscoveryNodeRole.MASTER_ROLE)).collect(Collectors.toList());
            List dataNodes = nodes.stream().filter(n -> n.getNode().getRoles().contains(DiscoveryNodeRole.DATA_ROLE) && !n.getNode().getRoles().contains(DiscoveryNodeRole.MASTER_ROLE)).collect(Collectors.toList());
            List clientNodes = nodes.stream().filter(n -> !n.getNode().getRoles().contains(DiscoveryNodeRole.MASTER_ROLE) && !n.getNode().getRoles().contains(DiscoveryNodeRole.DATA_ROLE)).collect(Collectors.toList());
            for (NodeInfo nodeInfo : masterNodes) {
                TransportAddress is = ((TransportInfo)nodeInfo.getInfo(TransportInfo.class)).getAddress().publishAddress();
                clusterInfo.nodePort = is.getPort();
                clusterInfo.nodeHost = is.getAddress();
            }
            if (!clientNodes.isEmpty()) {
                NodeInfo nodeInfo = (NodeInfo)clientNodes.get(0);
                if (nodeInfo.getInfo(HttpInfo.class) == null || ((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address() == null) throw new RuntimeException("no http host/port for client node");
                TransportAddress his = ((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address().publishAddress();
                clusterInfo.httpPort = his.getPort();
                clusterInfo.httpHost = his.getAddress();
            } else if (!dataNodes.isEmpty()) {
                for (NodeInfo nodeInfo : dataNodes) {
                    if (nodeInfo.getInfo(HttpInfo.class) == null || ((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address() == null) continue;
                    his = ((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address().publishAddress();
                    clusterInfo.httpPort = his.getPort();
                    clusterInfo.httpHost = his.getAddress();
                    break;
                }
            } else {
                for (NodeInfo nodeInfo : nodes) {
                    if (nodeInfo.getInfo(HttpInfo.class) == null || ((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address() == null) continue;
                    his = ((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address().publishAddress();
                    clusterInfo.httpPort = his.getPort();
                    clusterInfo.httpHost = his.getAddress();
                    break;
                }
            }
            for (NodeInfo nodeInfo : nodes) {
                clusterInfo.httpAdresses.add(((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address().publishAddress());
            }
            return clusterInfo;
        }
        catch (ElasticsearchTimeoutException e) {
            throw new IOException("timeout, cluster does not respond to health request, cowardly refusing to continue with operations");
        }
    }

    private Settings.Builder getMinimumNonSgNodeSettingsBuilder(int nodenum, boolean masterNode, boolean dataNode, SortedSet<Integer> masterTcpPorts, int tcpPort, int httpPort, String clustername, File homeDir) {
        ArrayList<String> nodeRoles = new ArrayList<String>();
        if (dataNode) {
            nodeRoles.add("data");
        }
        if (masterNode) {
            nodeRoles.add("master");
        }
        nodeRoles.add("remote_cluster_client");
        return Settings.builder().put("node.name", "node_" + clustername + "_num" + nodenum).putList("node.roles", nodeRoles).put("cluster.name", clustername).put("path.home", homeDir.getAbsolutePath() + "/" + nodenum).put("path.data", homeDir.getAbsolutePath() + "/" + nodenum + "/data").put("path.logs", homeDir.getAbsolutePath() + "/" + nodenum + "/logs").putList("cluster.initial_master_nodes", masterTcpPorts.stream().map(s -> "127.0.0.1:" + s).collect(Collectors.toList())).put("discovery.initial_state_timeout", "8s").putList("discovery.seed_hosts", masterTcpPorts.stream().map(s -> "127.0.0.1:" + s).collect(Collectors.toList())).put("transport.port", tcpPort).put("http.port", httpPort).put("cluster.routing.allocation.disk.threshold_enabled", false).put("http.cors.enabled", true);
    }

    static {
        System.setProperty("es.enforce.bootstrap.checks", "true");
        System.setProperty("sg.default_init.dir", new File("./sgconfig").getAbsolutePath());
        num = new AtomicLong();
    }
}

